/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph;

import com.isencia.passerelle.actor.gui.SaveInLibraryAction;
import com.isencia.passerelle.actor.gui.graph.EditPreferencesAction;
import com.isencia.passerelle.actor.gui.graph.ModelGraphPanel;
import com.isencia.passerelle.actor.gui.graph.ViewOpener;
import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionDragger;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.JContextMenu;
import diva.gui.toolbox.MenuCreator;
import diva.gui.toolbox.MenuFactory;
import java.awt.Toolkit;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorEditorGraphController;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.actor.ActorInstanceController;
import ptolemy.vergil.actor.ClassDefinitionController;
import ptolemy.vergil.actor.ExternalIOPortController;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.actor.LinkController;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.PopupMouseFilter;
import ptolemy.vergil.basic.WithIconGraphController;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.kernel.Link;
import ptolemy.vergil.kernel.RelationController;
import ptolemy.vergil.toolbox.MenuItemFactory;

public class EditorGraphController
extends ActorEditorGraphController
implements ViewOpener {
    private static final Logger logger = LoggerFactory.getLogger(EditorGraphController.class);
    private ModelGraphPanel parentPanel;
    private ViewFactory parentViewFactory;
    private SelectionDragger _selectionDragger;
    private Action _newInputPortAction = new WithIconGraphController.NewPortAction((WithIconGraphController)this, ExternalIOPortController._GENERIC_INPUT, "New input port", 73);
    private Action _newOutputPortAction = new WithIconGraphController.NewPortAction((WithIconGraphController)this, ExternalIOPortController._GENERIC_OUTPUT, "New output port", 79);
    protected SaveInLibraryAction _saveInLibraryAction;
    protected EditPreferencesAction _editPreferencesAction;
    private Action _newRelationAction = new ActorEditorGraphController.NewRelationAction((ActorEditorGraphController)this);
    private LinkCreator _linkCreator;
    private MouseFilter _shortcutFilter = new MouseFilter(16, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private ActorEditorGraphController.RelationCreator _relationCreator;

    public EditorGraphController(ModelGraphPanel modelGraphPanel) {
        this.parentPanel = modelGraphPanel;
    }

    public ModelGraphPanel getParentPanel() {
        return this.parentPanel;
    }

    protected void initializeInteraction() {
        GraphPane graphPane = this.getGraphPane();
        this._selectionDragger = new SelectionDragger((GraphicsPane)graphPane);
        this._selectionDragger.addSelectionModel(this.getSelectionModel());
        this._selectionDragger.setConsuming(false);
        this._menuFactory = new BasicGraphController.SchematicContextMenuFactory((GraphController)this);
        this._menuCreator = new MenuCreator((MenuFactory)this._menuFactory);
        this._menuCreator.setMouseFilter((MouseFilter)new PopupMouseFilter());
        this._saveInLibraryAction = new SaveInLibraryAction();
        this._saveInLibraryAction.setConfiguration(this.getConfiguration());
        this._editPreferencesAction = new EditPreferencesAction(this);
        this._editPreferencesAction.setConfiguration(this.getConfiguration());
        this._menuFactory.addMenuItemFactory((MenuItemFactory)new CompositeActorMenuItemFactory());
        graphPane.getBackgroundEventLayer().addInteractor((Interactor)this._menuCreator);
        graphPane.getBackgroundEventLayer().setConsuming(false);
        this._relationCreator = new ActorEditorGraphController.RelationCreator((ActorEditorGraphController)this);
        this._relationCreator.setMouseFilter(this._shortcutFilter);
        graphPane.getBackgroundEventLayer().addInteractor((Interactor)this._relationCreator);
        this._linkCreator = new LinkCreator();
        this._linkCreator.setMouseFilter(this._shortcutFilter);
        ((CompositeInteractor)this._portController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        ((CompositeInteractor)this._entityPortController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        ((CompositeInteractor)this._relationController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
        LinkCreator linkCreator = new LinkCreator();
        linkCreator.setMouseFilter(new MouseFilter(16, 0));
        ((CompositeInteractor)this._entityPortController.getNodeInteractor()).addInteractor((Interactor)linkCreator);
    }

    public AttributeController getAttributeController() {
        return (AttributeController)this._attributeController;
    }

    public IOPortController getEntityPortController() {
        return (IOPortController)this._entityPortController;
    }

    public ExternalIOPortController getPortController() {
        return (ExternalIOPortController)this._portController;
    }

    protected void _createControllers() {
        this._attributeController = new AttributeController((GraphController)this, AttributeController.FULL);
        this._classDefinitionController = new ClassDefinitionController((GraphController)this);
        this._entityController = new ActorInstanceController((GraphController)this);
        this._entityPortController = new IOPortController((GraphController)this, AttributeController.FULL);
        this._portController = new ExternalIOPortController((GraphController)this, AttributeController.FULL);
        this._relationController = new RelationController((GraphController)this);
        this._linkController = new LinkController((GraphController)this);
    }

    public void registerViewFactory(ViewFactory viewFactory) {
        this.parentViewFactory = viewFactory;
    }

    public void event(DebugEvent debugEvent) {
        Actor actor;
        if (debugEvent instanceof FiringEvent && (actor = ((FiringEvent)debugEvent).getActor()) instanceof NamedObj) {
            Figure figure;
            NamedObj namedObj = (NamedObj)actor;
            AbstractBasicGraphModel abstractBasicGraphModel = (AbstractBasicGraphModel)this.getGraphModel();
            NamedObj namedObj2 = abstractBasicGraphModel.getPtolemyModel();
            while (namedObj != null && namedObj.getContainer() != namedObj2) {
                namedObj = namedObj.getContainer();
            }
            if (namedObj == null) {
                return;
            }
            Attribute attribute = namedObj.getAttribute("_location");
            if (attribute != null && (figure = this.getFigure(attribute)) != null) {
                FiringEvent.FiringEventType firingEventType;
                if (this._animationRenderer == null) {
                    this._animationRenderer = new AnimationRenderer();
                }
                if ((firingEventType = ((FiringEvent)debugEvent).getType()) == FiringEvent.BEFORE_FIRE) {
                    this._animationRenderer.renderSelected(figure);
                    this._animated = figure;
                    long l = this.getAnimationDelay();
                    if (l > 0L) {
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (this._animated != null) {
                    this._animationRenderer.renderDeselected(this._animated);
                }
            }
        }
    }

    public void addToMenuAndToolbar(JMenu jMenu, JToolBar jToolBar) {
        if (jMenu == null) {
            jToolBar.addSeparator();
            GUIUtilities.addToolBarButton((JToolBar)jToolBar, (Action)this._newInputPortAction);
            GUIUtilities.addToolBarButton((JToolBar)jToolBar, (Action)this._newOutputPortAction);
            jToolBar.addSeparator();
            GUIUtilities.addToolBarButton((JToolBar)jToolBar, (Action)this._newRelationAction);
        } else {
            super.addToMenuAndToolbar(jMenu, jToolBar);
        }
    }

    public void postUndoableEdit(String string) {
        if (this.parentPanel != null) {
            this.parentPanel.postUndoableEdit(string);
        }
    }

    @Override
    public void openView(NamedObj namedObj, Configuration configuration) throws Exception {
        if (this.parentViewFactory == null) {
            throw new Exception("No view factory");
        }
        this.parentViewFactory.openView(this._getEffigy(namedObj, configuration));
    }

    private PtolemyEffigy _getEffigy(NamedObj namedObj, Configuration configuration) throws IllegalActionException, NameDuplicationException {
        PtolemyEffigy ptolemyEffigy = configuration.getEffigy(namedObj);
        if (ptolemyEffigy != null) {
            return ptolemyEffigy;
        }
        ptolemyEffigy = new PtolemyEffigy(configuration.workspace());
        ptolemyEffigy.setModel(namedObj);
        List list = namedObj.attributeList(URIAttribute.class);
        if (list.size() > 0) {
            URI uRI = ((URIAttribute)list.get(0)).getURI();
            ptolemyEffigy.uri.setURI(uRI);
            if (uRI == null) {
                ptolemyEffigy.identifier.setExpression(this._effigyIdentifier((Effigy)ptolemyEffigy, namedObj));
            } else {
                ptolemyEffigy.identifier.setExpression(uRI.toString());
            }
            ModelDirectory modelDirectory = configuration.getDirectory();
            ptolemyEffigy.setName(modelDirectory.uniqueName(namedObj.getName()));
            ptolemyEffigy.setContainer((CompositeEntity)modelDirectory);
            return ptolemyEffigy;
        }
        NamedObj namedObj2 = namedObj.getContainer();
        PtolemyEffigy ptolemyEffigy2 = null;
        while (namedObj2 != null && ptolemyEffigy2 == null) {
            ptolemyEffigy2 = configuration.getEffigy(namedObj2);
            namedObj2 = namedObj2.getContainer();
        }
        boolean bl = false;
        if (ptolemyEffigy2 != null) {
            ptolemyEffigy.setName(ptolemyEffigy2.uniqueName(namedObj.getName()));
            ptolemyEffigy.setContainer((CompositeEntity)ptolemyEffigy2);
            ptolemyEffigy.uri.setURI(ptolemyEffigy2.uri.getURI());
            bl = true;
        }
        if (!bl) {
            ModelDirectory modelDirectory = configuration.getDirectory();
            ptolemyEffigy.setName(modelDirectory.uniqueName(namedObj.getName()));
            ptolemyEffigy.setContainer((CompositeEntity)modelDirectory);
        }
        ptolemyEffigy.identifier.setExpression(this._effigyIdentifier((Effigy)ptolemyEffigy, namedObj));
        return ptolemyEffigy;
    }

    private String _effigyIdentifier(Effigy effigy, NamedObj namedObj) {
        Effigy effigy2 = null;
        try {
            effigy2 = (Effigy)effigy.getContainer();
        }
        catch (ClassCastException classCastException) {}
        if (effigy2 == null) {
            return effigy.getFullName();
        }
        String string = effigy2.identifier.getExpression();
        String string2 = "#";
        if (string.indexOf("#") > 0) {
            string2 = ".";
        }
        return String.valueOf(string) + string2 + namedObj.getName();
    }

    private class CompositeActorMenuItemFactory
    implements MenuItemFactory {
        private CompositeActorMenuItemFactory() {
        }

        public JMenuItem create(JContextMenu jContextMenu, NamedObj namedObj) {
            JMenuItem jMenuItem = null;
            if (namedObj != null && namedObj instanceof CompositeEntity) {
                jMenuItem = jContextMenu.add((Action)((Object)EditorGraphController.this._saveInLibraryAction), "Save In Library");
                jMenuItem = jContextMenu.add((Action)((Object)EditorGraphController.this._editPreferencesAction), "Show/hide parameters");
            }
            return jMenuItem;
        }
    }

    protected class LinkCreator
    extends AbstractInteractor {
        protected LinkCreator() {
        }

        public void mousePressed(LayerEvent layerEvent) {
            Figure figure = layerEvent.getFigureSource();
            NamedObj namedObj = (NamedObj)figure.getUserObject();
            Link link = new Link();
            ActorGraphModel actorGraphModel = (ActorGraphModel)EditorGraphController.this.getGraphModel();
            actorGraphModel.getLinkModel().setTail((Object)link, (Object)namedObj);
            try {
                FigureLayer figureLayer = EditorGraphController.this.getGraphPane().getForegroundLayer();
                AutonomousSite autonomousSite = new AutonomousSite((CanvasLayer)figureLayer, layerEvent.getLayerX(), layerEvent.getLayerY());
                AutonomousSite autonomousSite2 = new AutonomousSite((CanvasLayer)figureLayer, layerEvent.getLayerX(), layerEvent.getLayerY());
                Connector connector = EditorGraphController.this.getEdgeController(link).render((Object)link, figureLayer, (Site)autonomousSite2, (Site)autonomousSite);
                autonomousSite2 = EditorGraphController.this.getEdgeController(link).getConnectorTarget().getTailSite(connector, figure, layerEvent.getLayerX(), layerEvent.getLayerY());
                if (autonomousSite2 == null) {
                    throw new RuntimeException("Invalid connector target: no valid site found for tail of new connector.");
                }
                connector.setTailSite((Site)autonomousSite2);
                EditorGraphController.this.getSelectionModel().addSelection((Object)connector);
                ConnectorManipulator connectorManipulator = (ConnectorManipulator)connector.getParent();
                GrabHandle grabHandle = connectorManipulator.getHeadHandle();
                figureLayer.grabPointer(layerEvent, (Figure)grabHandle);
            }
            catch (Exception exception) {
                MessageHandler.error((String)"Drag connection failed:", (Throwable)exception);
            }
        }
    }

    public static interface ViewFactory {
        public void openView(PtolemyEffigy var1);
    }
}

