/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.gui.LocatableNodeDragInteractor;
import com.isencia.passerelle.actor.gui.SaveInLibraryAction;
import com.isencia.passerelle.actor.gui.graph.EditorGraphController;
import com.isencia.passerelle.actor.gui.graph.ModelGraphPanel;
import com.isencia.passerelle.actor.gui.graph.ViewOpener;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.NodeInteractor;
import diva.graph.basic.BasicLayoutTarget;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.gui.toolbox.JContextMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PortConfigurerDialog;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.toolbox.PortSite;

public class PasserelleActorController
extends AttributeController {
    private static final Logger logger = LoggerFactory.getLogger(PasserelleActorController.class);
    protected LookInsideAction _lookInsideAction = new LookInsideAction(this);
    protected SaveInLibraryAction _saveInLibraryAction = new SaveInLibraryAction();
    private static Font _portLabelFont = new Font("SansSerif", 0, 8);

    public PasserelleActorController(GraphController graphController) {
        this(graphController, FULL);
    }

    public PasserelleActorController(GraphController graphController, AttributeController.Access access) {
        super(graphController, access);
        ((NodeInteractor)this.getNodeInteractor()).setDragInteractor((DragInteractor)new LocatableNodeDragInteractor(this));
        if (access == FULL) {
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new PortDialogFactory());
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new CompositeActorMenuItemFactory(this));
        }
    }

    public void postUndoableEdit(String string) {
        ((EditorGraphController)this.getController()).postUndoableEdit(string);
    }

    protected static int _getCardinality(Port port) {
        Token token;
        Parameter parameter;
        NamedObj namedObj;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (port instanceof IOPort) {
            bl = ((IOPort)port).isInput();
            bl2 = ((IOPort)port).isOutput();
            bl3 = bl && bl2;
        }
        StringAttribute stringAttribute = null;
        int n = 0;
        try {
            stringAttribute = (StringAttribute)port.getAttribute("_cardinal", StringAttribute.class);
            namedObj = port.getContainer();
            if (namedObj != null && (parameter = (Parameter)namedObj.getAttribute("_rotatePorts", Parameter.class)) != null && (token = parameter.getToken()) instanceof IntToken) {
                n = ((IntToken)token).intValue();
            }
        }
        catch (IllegalActionException illegalActionException) {}
        if (stringAttribute == null) {
            if (bl3) {
                n -= 90;
            } else if (bl2) {
                n += 180;
            }
        } else {
            n = stringAttribute.getExpression().equalsIgnoreCase("NORTH") ? 90 : (stringAttribute.getExpression().equalsIgnoreCase("SOUTH") ? -90 : (stringAttribute.getExpression().equalsIgnoreCase("EAST") ? 180 : (stringAttribute.getExpression().equalsIgnoreCase("WEST") ? 0 : (n -= 90))));
        }
        n = 90 * (n / 90 % 4);
        try {
            namedObj = port.getContainer();
            if (namedObj != null) {
                Token token2;
                parameter = (Parameter)namedObj.getAttribute("_flipPortsHorizontal", Parameter.class);
                if (parameter != null && (token = parameter.getToken()) instanceof BooleanToken && ((BooleanToken)token).booleanValue()) {
                    if (n == 0 || n == -180) {
                        n += 180;
                    } else if (n == 180) {
                        n = 0;
                    }
                }
                if ((token = (Parameter)namedObj.getAttribute("_flipPortsVertical", Parameter.class)) != null && (token2 = token.getToken()) instanceof BooleanToken && ((BooleanToken)token2).booleanValue()) {
                    if (n == -270 || n == -90) {
                        n += 180;
                    } else if (n == 90 || n == 270) {
                        n -= 180;
                    }
                }
            }
        }
        catch (IllegalActionException illegalActionException) {}
        return n;
    }

    protected static int _getDirection(int n) {
        int n2 = n == 90 || n == -270 ? 1 : (n == 180 || n == -180 ? 3 : (n == 270 || n == -90 ? 5 : 7));
        return n2;
    }

    private LabelFigure _createPortLabelFigure(String string, Font font, double d, double d2, int n) {
        LabelFigure labelFigure;
        if (n == 5) {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d, d2 + 5.0);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966, d, d2 + 5.0);
            labelFigure.transform(affineTransform);
        } else if (n == 3) {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d + 5.0, d2);
        } else if (n == 7) {
            labelFigure = new LabelFigure(string, font, 1.0, 4);
            labelFigure.translateTo(d - 5.0, d2);
        } else {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d, d2 - 5.0);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966, d, d2 - 5.0);
            labelFigure.transform(affineTransform);
        }
        return labelFigure;
    }

    private class CompositeActorMenuItemFactory
    implements MenuItemFactory {
        private PasserelleActorController ctrlr;

        public CompositeActorMenuItemFactory(PasserelleActorController passerelleActorController2) {
            this.ctrlr = passerelleActorController2;
        }

        public JMenuItem create(JContextMenu jContextMenu, NamedObj namedObj) {
            JMenuItem jMenuItem = null;
            if (namedObj != null && namedObj instanceof CompositeEntity) {
                PasserelleActorController.this._saveInLibraryAction.setConfiguration(this.ctrlr._configuration);
                jMenuItem = jContextMenu.add((Action)((Object)PasserelleActorController.this._lookInsideAction), "Look Inside");
            }
            return jMenuItem;
        }
    }

    public class EntityLayout
    extends AbstractGlobalLayout {
        public EntityLayout() {
            super((LayoutTarget)new BasicLayoutTarget(PasserelleActorController.this.getController()));
        }

        public void layout(Object object) {
            Port port;
            GraphModel graphModel = PasserelleActorController.this.getController().getGraphModel();
            Iterator iterator = graphModel.nodes(object);
            Vector<Port> vector = new Vector<Port>();
            Vector<Port> vector2 = new Vector<Port>();
            Vector<Port> vector3 = new Vector<Port>();
            Vector<Port> vector4 = new Vector<Port>();
            while (iterator.hasNext()) {
                port = (Port)iterator.next();
                int n = PasserelleActorController._getCardinality(port);
                int n2 = PasserelleActorController._getDirection(n);
                if (n2 == 7) {
                    vector.add(port);
                    continue;
                }
                if (n2 == 1) {
                    vector4.add(port);
                    continue;
                }
                if (n2 == 3) {
                    vector2.add(port);
                    continue;
                }
                vector3.add(port);
            }
            port = (CompositeFigure)this.getLayoutTarget().getVisualObject(object);
            this._reOrderPorts(vector);
            this._placePortFigures((CompositeFigure)port, vector, 7);
            this._reOrderPorts(vector2);
            this._placePortFigures((CompositeFigure)port, vector2, 3);
            this._reOrderPorts(vector3);
            this._placePortFigures((CompositeFigure)port, vector3, 5);
            this._reOrderPorts(vector4);
            this._placePortFigures((CompositeFigure)port, vector4, 1);
        }

        private void _reOrderPorts(Vector vector) {
            int n = vector.size();
            Enumeration enumeration = vector.elements();
            StringAttribute stringAttribute = null;
            int n2 = 0;
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                Port port = (Port)enumeration.nextElement();
                stringAttribute = (StringAttribute)port.getAttribute("_ordinal");
                if (stringAttribute != null) {
                    n2 = Integer.parseInt(stringAttribute.getExpression());
                    if (n2 >= n) {
                        vector.remove(n3);
                        try {
                            stringAttribute.setExpression(Integer.toString(n - 1));
                        }
                        catch (Exception exception) {
                            MessageHandler.error((String)"Error setting ordinal property", (Throwable)exception);
                        }
                        vector.add(port);
                    } else if (n2 < 0) {
                        vector.remove(n3);
                        try {
                            stringAttribute.setExpression(Integer.toString(0));
                        }
                        catch (Exception exception) {
                            MessageHandler.error((String)"Error setting ordinal property", (Throwable)exception);
                        }
                        vector.add(0, port);
                    } else if (n2 != n3) {
                        vector.remove(n3);
                        vector.add(n2, port);
                    }
                }
                ++n3;
            }
        }

        private void _placePortFigures(CompositeFigure compositeFigure, List list, int n) {
            Iterator iterator = list.iterator();
            int n2 = 0;
            int n3 = list.size();
            Figure figure = compositeFigure.getBackgroundFigure();
            if (figure == null) {
                figure = compositeFigure;
            }
            while (iterator.hasNext()) {
                Object object;
                Attribute attribute;
                String string;
                Port port = (Port)iterator.next();
                Figure figure2 = PasserelleActorController.this.getController().getFigure((Object)port);
                if (figure2 == null) continue;
                Rectangle2D rectangle2D = figure2.getShape().getBounds2D();
                PortSite portSite = new PortSite(figure, port, n2, n3, n);
                ++n2;
                double d = portSite.getX() - rectangle2D.getCenterX();
                double d2 = portSite.getY() - rectangle2D.getCenterY();
                figure2.translate(d, d2);
                Attribute attribute2 = port.getAttribute("_showRate");
                if (port instanceof IOPort && attribute2 instanceof Variable) {
                    boolean bl = false;
                    try {
                        bl = ((Variable)attribute2).getToken().equals(BooleanToken.TRUE);
                    }
                    catch (Exception exception) {}
                    if (bl) {
                        string = "";
                        attribute = null;
                        if (((IOPort)port).isInput()) {
                            attribute = (Variable)port.getAttribute("tokenConsumptionRate");
                            if (attribute == null) {
                                object = "_tokenConsumptionRate";
                                attribute = (Variable)port.getAttribute((String)object);
                            }
                        } else if (((IOPort)port).isOutput() && (attribute = (Variable)port.getAttribute("tokenProductionRate")) == null) {
                            object = "_tokenProductionRate";
                            attribute = (Variable)port.getAttribute((String)object);
                        }
                        if (attribute != null) {
                            try {
                                string = attribute.getToken().toString();
                            }
                            catch (KernelException kernelException) {}
                        }
                        object = PasserelleActorController.this._createPortLabelFigure(string, _portLabelFont, d, d2, n);
                        object.setFillPaint((Paint)Color.BLUE);
                        compositeFigure.add((Figure)object);
                    }
                }
                Attribute attribute3 = port.getAttribute("_showName");
                string = null;
                if (attribute3 != null) {
                    boolean bl = true;
                    if (attribute3 instanceof Parameter) {
                        try {
                            object = ((Parameter)attribute3).getToken();
                            if (object instanceof BooleanToken) {
                                bl = ((BooleanToken)object).booleanValue();
                            }
                        }
                        catch (IllegalActionException illegalActionException) {}
                    }
                    if (bl) {
                        string = port.getDisplayName();
                    }
                }
                attribute = port.getAttribute("_showInfo");
                try {
                    if (attribute instanceof Variable && !((Variable)attribute).isStringMode()) {
                        object = ((Variable)attribute).getToken().toString();
                        string = string != null ? String.valueOf(string) + " (" + (String)object + ")" : object;
                    } else if (attribute instanceof Settable) {
                        string = string != null ? String.valueOf(string) + " (" + ((Settable)attribute).getExpression() + ")" : ((Settable)attribute).getExpression();
                    }
                }
                catch (IllegalActionException illegalActionException) {
                    string = String.valueOf(string) + illegalActionException.getMessage();
                }
                if (string == null) continue;
                object = PasserelleActorController.this._createPortLabelFigure(string, _portLabelFont, d, d2, n);
                compositeFigure.add((Figure)object);
            }
        }
    }

    private static class LookInsideAction
    extends FigureAction {
        private PasserelleActorController ctrlr;

        public LookInsideAction(PasserelleActorController passerelleActorController) {
            super("Look Inside");
            this.ctrlr = passerelleActorController;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NamedObj namedObj;
            super.actionPerformed(actionEvent);
            NamedObj namedObj2 = this.getTarget();
            if (this.ctrlr._configuration == null) {
                namedObj = namedObj2.toplevel();
                if (namedObj instanceof Configuration) {
                    this.ctrlr._configuration = (Configuration)namedObj;
                } else {
                    this.ctrlr._configuration = new Configuration(namedObj2.workspace());
                    try {
                        new ModelDirectory((CompositeEntity)this.ctrlr._configuration, "directory");
                    }
                    catch (Exception exception) {
                        MessageHandler.error((String)"Cannot look inside without a configuration.");
                        return;
                    }
                }
            }
            try {
                namedObj = this.ctrlr.getController();
                ((ViewOpener)namedObj).openView(namedObj2, this.ctrlr._configuration);
            }
            catch (Exception exception) {
                MessageHandler.error((String)"Cannot open view for looking inside.", (Throwable)exception);
            }
        }
    }

    private static class PortDialogFactory
    implements MenuItemFactory {
        private static String _configPorts = "Configure Ports";
        private Configuration _configuration;

        private PortDialogFactory() {
        }

        public JMenuItem create(final JContextMenu jContextMenu, NamedObj namedObj) {
            JMenuItem jMenuItem = null;
            final NamedObj namedObj2 = namedObj;
            if (namedObj2 == null || !(namedObj2 instanceof Entity) || namedObj2 instanceof Actor) {
                return null;
            }
            AbstractAction abstractAction = new AbstractAction(_configPorts){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTableau dialogTableau;
                    Component component = jContextMenu.getInvoker();
                    ModelGraphPanel modelGraphPanel = null;
                    while (component.getParent() != null) {
                        if (component instanceof ModelGraphPanel) {
                            modelGraphPanel = (ModelGraphPanel)component;
                        }
                        component = component.getParent();
                    }
                    if (modelGraphPanel != null) {
                        DialogTableau dialogTableau2 = DialogTableau.createDialog((Frame)((Frame)component), (Configuration)PortDialogFactory.this._configuration, (Effigy)modelGraphPanel.getEffigy(), PortConfigurerDialog.class, (Entity)((Entity)namedObj2));
                        if (dialogTableau2 != null) {
                            dialogTableau2.show();
                        }
                    } else if (component instanceof TableauFrame && (dialogTableau = DialogTableau.createDialog((Frame)((Frame)component), (Configuration)PortDialogFactory.this._configuration, (Effigy)((TableauFrame)component).getEffigy(), PortConfigurerDialog.class, (Entity)((Entity)namedObj2))) != null) {
                        dialogTableau.show();
                    }
                }
            };
            jMenuItem = jContextMenu.add((Action)abstractAction, _configPorts);
            return jMenuItem;
        }

        public void setConfiguration(Configuration configuration) {
            this._configuration = configuration;
        }
    }
}

