/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.message.ChannelException;
import com.isencia.message.ISenderChannel;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.interceptor.MessageToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class ChannelSink
extends Sink {
    private static Logger logger = LoggerFactory.getLogger(ChannelSink.class);
    private ISenderChannel sendChannel = null;

    public ChannelSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    public ISenderChannel getChannel() {
        return this.sendChannel;
    }

    @Override
    protected void sendMessage(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            if (managedMessage != null) {
                this.getChannel().sendMessage((Object)managedMessage);
            } else {
                this.requestFinish();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - getChannel().sendMessage() caused exception :" + exception, managedMessage, exception);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        ISenderChannel iSenderChannel = null;
        try {
            iSenderChannel = this.createChannel();
        }
        catch (ChannelException channelException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Sender channel for " + this.getInfo() + " not created correctly.", this, channelException);
        }
        if (iSenderChannel == null) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Sender channel for " + this.getInfo() + " not created correctly.", this, null);
        }
        try {
            this.closeChannel(this.getChannel());
        }
        catch (ChannelException channelException) {
            throw new InitializationException("Sender channel for " + this.getInfo() + " not initialized correctly.", this.getChannel(), channelException);
        }
        this.sendChannel = iSenderChannel;
        if (!this.isPassThrough()) {
            IMessageInterceptorChain iMessageInterceptorChain = this.createInterceptorChain();
            this.sendChannel.setInterceptorChainOnEnter(iMessageInterceptorChain);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        boolean bl = true;
        try {
            if (!this.getChannel().isOpen()) {
                this.openChannel(this.getChannel());
                if (logger.isInfoEnabled()) {
                    logger.info(String.valueOf(this.getInfo()) + " - Opened :" + this.getChannel());
                }
            }
        }
        catch (ChannelException channelException) {
            throw new ProcessingException(PasserelleException.Severity.FATAL, "Sender channel for " + this.getInfo() + " not opened correctly.", this.getChannel(), channelException);
        }
        boolean bl2 = bl = bl && super.doPreFire();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit :" + bl);
        }
        return bl;
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            this.closeChannel(this.getChannel());
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Closed :" + this.getChannel());
            }
        }
        catch (ChannelException channelException) {
            throw new TerminationException(String.valueOf(this.getInfo()) + " - Error closing channel.", this.getChannel(), channelException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract ISenderChannel createChannel() throws ChannelException, InitializationException;

    protected IMessageInterceptorChain createInterceptorChain() {
        if (logger.isDebugEnabled()) {
            logger.debug(String.valueOf(this.getInfo()) + "Converting message to text");
        }
        MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
        messageInterceptorChain.add((IMessageInterceptor)new MessageToTextConverter());
        return messageInterceptorChain;
    }

    @Override
    protected String getExtendedInfo() {
        return null;
    }

    protected void closeChannel(ISenderChannel iSenderChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iSenderChannel);
        }
        if (iSenderChannel != null && iSenderChannel.isOpen()) {
            iSenderChannel.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void openChannel(ISenderChannel iSenderChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iSenderChannel);
        }
        if (iSenderChannel != null) {
            iSenderChannel.open();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }
}

