/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.xspress;

import java.io.Serializable;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.DetectorROI;

public class XspressROI
implements DetectorROI,
Serializable {
    public static final String VIRTUALSCALER = "Virtual Scaler";
    public static final String MCA = "MCA";
    public static final String SUMALL = "sum all";
    public static final String ONE_GAUSSIAN = "1 Gaussian";
    public static final String TWO_GAUSSIAN = "2 Gaussians";
    public static final String THREE_GAUSSIAN = "3 Gaussians";
    private int regionStart;
    private int regionEnd;
    private String regionType = "Virtual Scaler";
    private String roiName;
    private String fitType;

    public XspressROI() {
    }

    public XspressROI(String string, int n, int n2, String string2, String string3) {
        this.roiName = string;
        this.regionStart = n;
        this.regionEnd = n2;
        this.regionType = string2;
        this.fitType = string3;
    }

    public int getRegionStart() {
        return this.regionStart;
    }

    public void setRegionStart(int n) {
        this.regionStart = n;
    }

    public int getRegionEnd() {
        return this.regionEnd;
    }

    public void setRegionEnd(int n) {
        this.regionEnd = n;
    }

    public String getRegionType() {
        return this.regionType;
    }

    public void setRegionType(String string) {
        this.regionType = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getFitType() == null ? 0 : this.getFitType().hashCode());
        n = 31 * n + this.regionEnd;
        n = 31 * n + this.regionStart;
        n = 31 * n + (this.regionType == null ? 0 : this.regionType.hashCode());
        n = 31 * n + (this.roiName == null ? 0 : this.roiName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XspressROI xspressROI = (XspressROI)object;
        if (this.getFitType() == null ? xspressROI.getFitType() != null : !this.getFitType().equals(xspressROI.getFitType())) {
            return false;
        }
        if (this.regionEnd != xspressROI.regionEnd) {
            return false;
        }
        if (this.regionStart != xspressROI.regionStart) {
            return false;
        }
        if (this.regionType == null ? xspressROI.regionType != null : !this.regionType.equals(xspressROI.regionType)) {
            return false;
        }
        return !(this.roiName == null ? xspressROI.roiName != null : !this.roiName.equals(xspressROI.roiName));
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String getRoiName() {
        return this.roiName;
    }

    public void setRoiName(String string) {
        this.roiName = string;
    }

    public void setFitType(String string) {
        this.fitType = string;
    }

    public String getFitType() {
        if (this.fitType == null) {
            this.fitType = SUMALL;
        }
        return this.fitType;
    }

    public int numberPeaks() {
        if (this.getFitType().equals(SUMALL)) {
            return 0;
        }
        if (this.getFitType().equals(ONE_GAUSSIAN)) {
            return 1;
        }
        if (this.getFitType().equals(TWO_GAUSSIAN)) {
            return 2;
        }
        if (this.getFitType().equals(THREE_GAUSSIAN)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getRoiEnd() {
        return this.getRegionEnd();
    }

    @Override
    public int getRoiStart() {
        return this.getRegionStart();
    }
}

