/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.xspress;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.exafs.IDetectorElement;
import uk.ac.gda.beans.xspress.XspressROI;

public class DetectorElement
implements Serializable,
IDetectorElement {
    private static String[] labels = new String[]{"allCounts", "resets", "inWindow", "time"};
    private String name;
    private int number;
    private int windowStart;
    private int windowEnd;
    private double gain;
    private double offset;
    private double processDeadTimeAllEventGradient;
    private double processDeadTimeAllEventOffset;
    private double processDeadTimeInWindow;
    private boolean excluded = false;
    private List<XspressROI> regionList;

    public DetectorElement() {
        this.regionList = new ArrayList<XspressROI>();
    }

    public DetectorElement(String string, int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, boolean bl, ArrayList<XspressROI> arrayList) {
        this.name = string;
        this.number = n;
        this.windowStart = n2;
        this.windowEnd = n3;
        this.gain = d;
        this.processDeadTimeAllEventGradient = d3;
        this.processDeadTimeAllEventOffset = d4;
        this.processDeadTimeInWindow = d5;
        this.offset = d2;
        this.excluded = bl;
        this.regionList = arrayList;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String[] getLabels() {
        return labels;
    }

    public void setWindow(int n, int n2) {
        this.windowStart = n;
        this.windowEnd = n2;
    }

    public int getWindowStart() {
        return this.windowStart;
    }

    public int getWindowEnd() {
        return this.windowEnd;
    }

    public double getGain() {
        return this.gain;
    }

    public double getProcessDeadTimeAllEventGradient() {
        return this.processDeadTimeAllEventGradient;
    }

    public void setProcessDeadTimeAllEventGradient(double d) {
        this.processDeadTimeAllEventGradient = d;
    }

    public double getProcessDeadTimeAllEventOffset() {
        return this.processDeadTimeAllEventOffset;
    }

    public void setProcessDeadTimeAllEventOffset(double d) {
        this.processDeadTimeAllEventOffset = d;
    }

    public double getProcessDeadTimeInWindow() {
        return this.processDeadTimeInWindow;
    }

    public void setProcessDeadTimeInWindow(double d) {
        this.processDeadTimeInWindow = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public void setWindowStart(int n) {
        this.windowStart = n;
    }

    public void setWindowEnd(int n) {
        this.windowEnd = n;
    }

    public double getOffset() {
        return this.offset;
    }

    public int getNumber() {
        return this.number;
    }

    public void setGain(double d) {
        this.gain = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean bl) {
        this.excluded = bl;
    }

    public void addRegion(XspressROI xspressROI) {
        this.regionList.add(xspressROI);
    }

    public List<XspressROI> getRegionList() {
        return this.regionList;
    }

    public void setRegionList(List<XspressROI> list) {
        this.regionList = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.excluded ? 1231 : 1237);
        long l = Double.doubleToLongBits(this.gain);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.number;
        l = Double.doubleToLongBits(this.offset);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.processDeadTimeAllEventGradient);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.processDeadTimeAllEventOffset);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.processDeadTimeInWindow);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.regionList == null ? 0 : this.regionList.hashCode());
        n = 31 * n + this.windowEnd;
        n = 31 * n + this.windowStart;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DetectorElement detectorElement = (DetectorElement)object;
        if (this.excluded != detectorElement.excluded) {
            return false;
        }
        if (Double.doubleToLongBits(this.gain) != Double.doubleToLongBits(detectorElement.gain)) {
            return false;
        }
        if (this.name == null ? detectorElement.name != null : !this.name.equals(detectorElement.name)) {
            return false;
        }
        if (this.number != detectorElement.number) {
            return false;
        }
        if (Double.doubleToLongBits(this.offset) != Double.doubleToLongBits(detectorElement.offset)) {
            return false;
        }
        if (Double.doubleToLongBits(this.processDeadTimeAllEventGradient) != Double.doubleToLongBits(detectorElement.processDeadTimeAllEventGradient)) {
            return false;
        }
        if (Double.doubleToLongBits(this.processDeadTimeAllEventOffset) != Double.doubleToLongBits(detectorElement.processDeadTimeAllEventOffset)) {
            return false;
        }
        if (Double.doubleToLongBits(this.processDeadTimeInWindow) != Double.doubleToLongBits(detectorElement.processDeadTimeInWindow)) {
            return false;
        }
        if (this.regionList == null ? detectorElement.regionList != null : !this.regionList.equals(detectorElement.regionList)) {
            return false;
        }
        if (this.windowEnd != detectorElement.windowEnd) {
            return false;
        }
        return this.windowStart == detectorElement.windowStart;
    }
}

