/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.vortex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.exafs.IDetectorElement;
import uk.ac.gda.beans.vortex.RegionOfInterest;

public class DetectorElement
implements Serializable,
IDetectorElement {
    private List<RegionOfInterest> regionList = new ArrayList<RegionOfInterest>();
    private String name;
    private int number;
    private double gain;
    private double offset;
    private double processDeadTimeAllEvent;
    private double processDeadTimeInWindow;
    private boolean excluded = false;
    private double peakingTime;

    public void clear() {
        if (this.regionList != null) {
            this.regionList.clear();
        }
    }

    public double getPeakingTime() {
        return this.peakingTime;
    }

    public void setPeakingTime(double d) {
        this.peakingTime = d;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public double getGain() {
        return this.gain;
    }

    public double getProcessDeadTimeAllEvent() {
        return this.processDeadTimeAllEvent;
    }

    public void setProcessDeadTimeAllEvent(double d) {
        this.processDeadTimeAllEvent = d;
    }

    public double getProcessDeadTimeInWindow() {
        return this.processDeadTimeInWindow;
    }

    public void setProcessDeadTimeInWindow(double d) {
        this.processDeadTimeInWindow = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public double getOffset() {
        return this.offset;
    }

    public int getNumber() {
        return this.number;
    }

    public void setGain(double d) {
        this.gain = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean bl) {
        this.excluded = bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.excluded ? 1231 : 1237);
        long l = Double.doubleToLongBits(this.gain);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + this.number;
        l = Double.doubleToLongBits(this.offset);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.peakingTime);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.processDeadTimeAllEvent);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.processDeadTimeInWindow);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.regionList == null ? 0 : this.regionList.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DetectorElement detectorElement = (DetectorElement)object;
        if (this.excluded != detectorElement.excluded) {
            return false;
        }
        if (Double.doubleToLongBits(this.gain) != Double.doubleToLongBits(detectorElement.gain)) {
            return false;
        }
        if (this.name == null ? detectorElement.name != null : !this.name.equals(detectorElement.name)) {
            return false;
        }
        if (this.number != detectorElement.number) {
            return false;
        }
        if (Double.doubleToLongBits(this.offset) != Double.doubleToLongBits(detectorElement.offset)) {
            return false;
        }
        if (Double.doubleToLongBits(this.peakingTime) != Double.doubleToLongBits(detectorElement.peakingTime)) {
            return false;
        }
        if (Double.doubleToLongBits(this.processDeadTimeAllEvent) != Double.doubleToLongBits(detectorElement.processDeadTimeAllEvent)) {
            return false;
        }
        if (Double.doubleToLongBits(this.processDeadTimeInWindow) != Double.doubleToLongBits(detectorElement.processDeadTimeInWindow)) {
            return false;
        }
        return !(this.regionList == null ? detectorElement.regionList != null : !this.regionList.equals(detectorElement.regionList));
    }

    public void addRegion(RegionOfInterest regionOfInterest) {
        this.regionList.add(regionOfInterest);
    }

    public List<RegionOfInterest> getRegionList() {
        return this.regionList;
    }

    public void setRegionList(List<RegionOfInterest> list) {
        this.regionList = list;
    }
}

