/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.exafs.i20;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.gda.beans.exafs.i20.CryostatParameters;
import uk.ac.gda.beans.exafs.i20.FurnaceParameters;
import uk.ac.gda.beans.exafs.i20.I20SampleParameters;
import uk.ac.gda.beans.exafs.i20.SampleStageParameters;
import uk.ac.gda.doe.DOEUtils;

public class I20SampleParametersTest
extends TestCase {
    public static I20SampleParameters createTestParameters() {
        SampleStageParameters sampleStageParameters = new SampleStageParameters();
        sampleStageParameters.setRoll("0.0");
        sampleStageParameters.setRotation("0.0");
        sampleStageParameters.setYaw("0.0");
        sampleStageParameters.setX("0.0;9.0;1.0");
        sampleStageParameters.setY("0.0;9.0;1.0");
        sampleStageParameters.setZ("0.0");
        CryostatParameters cryostatParameters = new CryostatParameters();
        cryostatParameters.setTemperature("80.0");
        cryostatParameters.setTime(60.0);
        cryostatParameters.setTolerance(1.0);
        cryostatParameters.setSampleHolder("3 Samples");
        cryostatParameters.setSampleNumber("2,1,3");
        cryostatParameters.setPosition("1.0");
        cryostatParameters.setFinePosition("1.0");
        cryostatParameters.setProfileType("PID");
        cryostatParameters.setP(1.0);
        cryostatParameters.setI(2.0);
        cryostatParameters.setHeaterRange(1);
        cryostatParameters.setFinePosition("0.1");
        cryostatParameters.setD(3.0);
        FurnaceParameters furnaceParameters = new FurnaceParameters();
        furnaceParameters.setX("5.0;9.0;1.0");
        furnaceParameters.setY("5.0");
        furnaceParameters.setZ("5.0");
        furnaceParameters.setTemperature("295.0");
        furnaceParameters.setTolerance(5.0);
        furnaceParameters.setTime(5.0);
        I20SampleParameters i20SampleParameters = new I20SampleParameters();
        i20SampleParameters.setSampleStageParameters(sampleStageParameters);
        i20SampleParameters.setCryostatParameters(cryostatParameters);
        i20SampleParameters.setFurnaceParameters(furnaceParameters);
        i20SampleParameters.setShouldValidate(true);
        i20SampleParameters.setSampleWheelPosition(1);
        return i20SampleParameters;
    }

    @Test
    public void testLimitedDOEExpansion() {
        try {
            I20SampleParameters i20SampleParameters = I20SampleParametersTest.createTestParameters();
            List list = DOEUtils.expand((Object)i20SampleParameters);
            I20SampleParametersTest.assertEquals((int)1, (int)list.size());
            i20SampleParameters.setTemperatureControl("Cryostat");
            list = DOEUtils.expand((Object)i20SampleParameters);
            I20SampleParametersTest.assertEquals((int)3, (int)list.size());
            i20SampleParameters.setTemperatureControl("Furnace");
            list = DOEUtils.expand((Object)i20SampleParameters);
            I20SampleParametersTest.assertEquals((int)5, (int)list.size());
            i20SampleParameters.setTemperatureControl("None");
            i20SampleParameters.setSampleStage("Room Temperature");
            list = DOEUtils.expand((Object)i20SampleParameters);
            I20SampleParametersTest.assertEquals((int)100, (int)list.size());
        }
        catch (Exception exception) {
            I20SampleParametersTest.fail((String)exception.getMessage());
        }
    }
}

