/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.HashSet;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class ClassChanges
implements MoMLFilter {
    private static HashMap _classChanges = new HashMap();
    private static HashSet _classesToRemove;

    static {
        _classChanges.put("ptolemy.moml.Location", "ptolemy.kernel.util.Location");
        _classChanges.put("ptolemy.kernel.util.VersionAttribute", "ptolemy.kernel.attributes.VersionAttribute");
        _classChanges.put("ptolemy.actor.lib.comm.SerialComm", "ptolemy.actor.lib.io.comm.SerialComm");
        _classChanges.put("ptolemy.domains.fsm.lib.RelationList", "ptolemy.domains.fsm.kernel.RelationList");
        _classChanges.put("ptolemy.vergil.icon.ImageEditorIcon", "ptolemy.vergil.icon.ImageIcon");
        _classChanges.put("ptolemy.kernel.attributes.FileAttribute", "ptolemy.data.expr.FileParameter");
        _classChanges.put("ptolemy.domains.sdf.kernel.SDFIOPort", "ptolemy.actor.TypedIOPort");
        _classChanges.put("ptolemy.actor.hoc.MultiInstanceComposite", "ptolemy.actor.lib.hoc.MultiInstanceComposite");
        _classChanges.put("ptolemy.vergil.fsm.modal.ModalModel", "ptolemy.domains.fsm.modal.ModalModel");
        _classChanges.put("ptolemy.domains.fsm.kernel.InterfaceAutomatonTransition", "ptolemy.domains.fsm.kernel.ia.InterfaceAutomatonTransition");
        _classChanges.put("ptolemy.vergil.fsm.modal.ModalModel$ModalTableauFactory", "ptolemy.vergil.fsm.modal.ModalTableauFactory");
        _classChanges.put("ptolemy.vergil.fsm.modal.ModalPort", "ptolemy.domains.fsm.modal.ModalPort");
        _classChanges.put("ptolemy.vergil.fsm.modal.ModalController", "ptolemy.domains.fsm.modal.ModalController");
        _classChanges.put("ptolemy.vergil.fsm.modal.Refinement", "ptolemy.domains.fsm.modal.Refinement");
        _classChanges.put("ptolemy.vergil.fsm.modal.RefinementPort", "ptolemy.domains.fsm.modal.RefinementPort");
        _classChanges.put("ptolemy.vergil.fsm.modal.TransitionRefinement", "ptolemy.domains.fsm.modal.TransitionRefinement");
        _classChanges.put("ptolemy.vergil.fsm.modal.TransitionRefinementPort", "ptolemy.domains.fsm.modal.TransitionRefinementPort");
        _classChanges.put("ptolemy.kernel.attributes.IDAttribute", "ptolemy.vergil.kernel.attributes.IDAttribute");
        _classChanges.put("ptolemy.domains.gr.lib.ViewScreen", "ptolemy.domains.gr.lib.ViewScreen3D");
        _classChanges.put("ptolemy.domains.sr.lib.Latch", "ptolemy.domains.sr.lib.Current");
        _classChanges.put("ptolemy.vergil.VergilPreferences", "ptolemy.actor.gui.PtolemyPreferences");
        _classChanges.put("ptolemy.domains.sr.kernel.SROptimizedScheduler", "ptolemy.actor.sched.FixedPointScheduler");
        _classChanges.put("ptolemy.domains.fsm.kernel.HSFSMDirector", "ptolemy.domains.ct.kernel.HSFSMDirector");
        _classChanges.put("ptolemy.data.expr.ParameterSet", "ptolemy.actor.parameters.ParameterSet");
        _classChanges.put("ptolemy.actor.lib.colt.ColtSeedParameter", "ptolemy.moml.SharedParameter");
        _classChanges.put("ptolemy.domains.sr.lib.SingleTokenCommutator", "ptolemy.actor.lib.SingleTokenCommutator");
        try {
            Class.forName("org.kepler.moml.NamedObjId");
        }
        catch (ClassNotFoundException classNotFoundException) {
            _classChanges.put("org.kepler.moml.NamedObjId", "ptolemy.kernel.util.StringAttribute");
        }
        _classesToRemove = new HashSet();
        _classesToRemove.add("ptolemy.data.expr.NotEditableParameter");
        _classesToRemove.add("ptolemy.domains.de.kernel.DEIOPort");
        _classesToRemove.add("ptolemy.domains.sr.kernel.SROptimizedScheduler");
        _classesToRemove.add("ptolemy.domains.sr.kernel.SRRandomizedScheduler");
    }

    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("class")) {
            if (_classChanges.containsKey(attributeValue)) {
                MoMLParser.setModified(true);
                return (String)_classChanges.get(attributeValue);
            }
            if (_classesToRemove.contains(attributeValue)) {
                return null;
            }
        }
        return attributeValue;
    }

    public void filterEndElement(NamedObj container, String elementName) throws Exception {
    }

    public String toString() {
        StringBuffer results = new StringBuffer(String.valueOf(this.getClass().getName()) + ": change any class names that have been " + "renamed and remove obsolete classes.\n" + "Below are original class names followed by " + "the new class names:\n");
        for (String className : _classChanges.keySet()) {
            results.append("\t" + className + "\t -> " + _classChanges.get(className) + "\n");
        }
        results.append("\nBelow are the classes to remove:\n");
        for (String className : _classesToRemove) {
            results.append("\t" + className + "\n");
        }
        return results.toString();
    }
}

