/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Singleton;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.Documentation;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.HandlesInternalLinks;
import ptolemy.moml.IconLoader;
import ptolemy.moml.MissingClassException;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLUndoEntry;
import ptolemy.moml.ParserAttribute;
import ptolemy.moml.SharedParameter;
import ptolemy.moml.UndoContext;
import ptolemy.moml.Vertex;
import ptolemy.util.CancelException;
import ptolemy.util.ClassUtilities;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class MoMLParser
extends HandlerBase
implements ChangeListener {
    public static String MoML_DTD_1 = "<!ELEMENT model (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | property | relation | rename | rendition | unlink)*><!ATTLIST model name CDATA #REQUIRED class CDATA #IMPLIED><!ELEMENT class (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | port | property | relation | rename | rendition | unlink)*><!ATTLIST class name CDATA #REQUIRED extends CDATA #IMPLIED source CDATA #IMPLIED><!ELEMENT configure (#PCDATA)><!ATTLIST configure source CDATA #IMPLIED><!ELEMENT deleteEntity EMPTY><!ATTLIST deleteEntity name CDATA #REQUIRED><!ELEMENT deletePort EMPTY><!ATTLIST deletePort name CDATA #REQUIRED><!ELEMENT deleteProperty EMPTY><!ATTLIST deleteProperty name CDATA #REQUIRED><!ELEMENT deleteRelation EMPTY><!ATTLIST deleteRelation name CDATA #REQUIRED><!ELEMENT director (configure | doc | property)*><!ATTLIST director name CDATA \"director\" class CDATA #REQUIRED><!ELEMENT display EMPTY><!ATTLIST display name CDATA #REQUIRED><!ELEMENT doc (#PCDATA)><!ATTLIST doc name CDATA #IMPLIED><!ELEMENT entity (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | port | property | relation | rename | rendition | unlink)*><!ATTLIST entity name CDATA #REQUIRED class CDATA #IMPLIED source CDATA #IMPLIED><!ELEMENT group ANY><!ATTLIST group name CDATA #IMPLIED><!ELEMENT import EMPTY><!ATTLIST import source CDATA #REQUIRED base CDATA #IMPLIED><!ELEMENT input EMPTY><!ATTLIST input source CDATA #REQUIRED base CDATA #IMPLIED><!ELEMENT link EMPTY><!ATTLIST link insertAt CDATA #IMPLIED insertInsideAt CDATA #IMPLIED port CDATA #REQUIRED relation CDATA #IMPLIED vertex CDATA #IMPLIED><!ELEMENT location EMPTY><!ATTLIST location value CDATA #REQUIRED><!ELEMENT port (configure | display | doc | property | rename)*><!ATTLIST port class CDATA #IMPLIED name CDATA #REQUIRED><!ELEMENT property (configure | display | doc | property | rename)*><!ATTLIST property class CDATA #IMPLIED name CDATA #REQUIRED value CDATA #IMPLIED><!ELEMENT relation (configure | display | doc | property | rename | vertex)*><!ATTLIST relation name CDATA #REQUIRED class CDATA #IMPLIED><!ELEMENT rename EMPTY><!ATTLIST rename name CDATA #REQUIRED><!ELEMENT rendition (configure | location | property)*><!ATTLIST rendition class CDATA #REQUIRED><!ELEMENT unlink EMPTY><!ATTLIST unlink index CDATA #IMPLIED insideIndex CDATA #IMPLIED port CDATA #REQUIRED relation CDATA #IMPLIED><!ELEMENT vertex (configure | display | doc | location | property | rename)*><!ATTLIST vertex name CDATA #REQUIRED pathTo CDATA #IMPLIED value CDATA #IMPLIED>";
    public static String MoML_PUBLIC_ID_1 = "-//UC Berkeley//DTD MoML 1//EN";
    public static List inputFileNamesToSkip = null;
    private static Set _approvedRemoteXmlFiles = new HashSet();
    private Map _attributes = new HashMap();
    private List _attributeNameList = new ArrayList(0);
    private static String _AUTO_NAMESPACE = "auto";
    private URL _base;
    private ClassLoader _classLoader = this.getClass().getClassLoader();
    private int _configureNesting = 0;
    private String _configureSource;
    private Stack _containers = new Stack();
    private NamedObj _current;
    private StringBuffer _currentCharData;
    private String _currentDocName;
    private static String _DEFAULT_NAMESPACE = "";
    private static int _DELETE_ENTITY = 0;
    private static int _DELETE_PORT = 1;
    private static int _DELETE_PROPERTY = 2;
    private static int _DELETE_RELATION = 3;
    private List _deleteRequests;
    private Stack _deleteRequestStack = new Stack();
    private int _docNesting = 0;
    private Stack _externalEntities = new Stack();
    private static ErrorHandler _handler = null;
    private static List _filterList = null;
    private static IconLoader _iconLoader;
    private static Map _imports;
    private List _linkRequests;
    private Stack _linkRequestStack = new Stack();
    private static boolean _modified;
    private String _namespace = _DEFAULT_NAMESPACE;
    private Stack _namespaces = new Stack();
    private boolean _namespacesPushed = false;
    private Map _namespaceTranslationTable = null;
    private Stack _namespaceTranslations = new Stack();
    private NamedObj _originalContext = null;
    private List _paramsToParse = new LinkedList();
    private XmlParser _xmlParser;
    private boolean _previousDeferStatus = false;
    private int _skipElement = 0;
    private boolean _skipElementIsNew = false;
    private String _skipElementName;
    private boolean _skipRendition = false;
    private NamedObj _toplevel = null;
    private List _topObjectsCreated = null;
    private Stack _undoContexts = new Stack();
    private UndoContext _undoContext = null;
    private static boolean _undoDebug;
    private boolean _undoEnabled = false;
    private List _unrecognized;
    private Workspace _workspace;
    private URL _xmlFile = null;

    static {
        _modified = false;
        _undoDebug = false;
    }

    public MoMLParser() {
        this(null);
    }

    public MoMLParser(Workspace workspace) {
        if (workspace == null) {
            workspace = new Workspace();
        }
        this._workspace = workspace;
    }

    public MoMLParser(Workspace workspace, ClassLoader loader) {
        this(workspace);
        this._classLoader = loader;
    }

    public static void addMoMLFilter(MoMLFilter filter) {
        if (_filterList == null) {
            _filterList = new LinkedList();
        }
        if (!_filterList.contains(filter)) {
            _filterList.add(filter);
        }
    }

    public static void addMoMLFilters(List filterList) {
        if (_filterList == null) {
            _filterList = new LinkedList();
        }
        _filterList.addAll(filterList);
    }

    public void attribute(String name, String value, boolean specified) throws XmlException {
        if (name == null) {
            throw new XmlException("Attribute has no name", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (this._namespace.equals(_AUTO_NAMESPACE) && this._current != null && (name.equals("name") || name.equals("port") || name.startsWith("relation") || name.equals("vertex") || name.equals("pathTo"))) {
            boolean nameSeenAlready = false;
            if (this._namespaceTranslationTable != null) {
                String replacement;
                String prefix = value;
                String suffix = "";
                int period = -1;
                if (value != null) {
                    period = value.indexOf(".");
                }
                if (period >= 0) {
                    prefix = value.substring(0, period);
                    suffix = value.substring(period);
                }
                if ((replacement = (String)this._namespaceTranslationTable.get(prefix)) != null) {
                    value = String.valueOf(replacement) + suffix;
                    nameSeenAlready = true;
                }
            }
            if (!nameSeenAlready && name.equals("name")) {
                String oldValue = value;
                String createIfNecessary = (String)this._attributes.get("createIfNecessary");
                value = this._current.uniqueName(oldValue);
                if (createIfNecessary != null && createIfNecessary.equals("true") && !value.equals(oldValue)) {
                    String currentElement = this._xmlParser.getCurrentElement();
                    ++this._skipElement;
                    this._skipElementIsNew = true;
                    this._skipElementName = currentElement;
                    return;
                }
                this._namespaceTranslationTable.put(oldValue, value);
            }
        } else if (!this._namespace.equals(_DEFAULT_NAMESPACE) && !this._namespace.equals(_AUTO_NAMESPACE) && (name.equals("name") || name.equals("port") || name.equals("relation") || name.equals("vertex") || name.equals("pathTo"))) {
            value = String.valueOf(this._namespace) + ":" + value;
        }
        if (_filterList != null) {
            String currentElement = this._xmlParser.getCurrentElement();
            Iterator filters = _filterList.iterator();
            String filteredValue = value;
            while (filters.hasNext()) {
                MoMLFilter filter = (MoMLFilter)filters.next();
                filteredValue = filter.filterAttributeValue(this._current, currentElement, name, filteredValue);
            }
            if (value != null && filteredValue == null) {
                this._skipElementIsNew = true;
                this._skipElementName = currentElement;
                ++this._skipElement;
            }
            value = filteredValue;
        }
        this._attributes.put(name, value);
        this._attributeNameList.add(name);
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        int reply;
        if (_handler != null && (reply = _handler.handleError(change.toString(), this._toplevel, exception)) == 0) {
            return;
        }
        System.err.println(exception.toString());
        exception.printStackTrace();
    }

    public void charData(char[] chars, int offset, int length) {
        if (this._currentCharData != null) {
            this._currentCharData.append(chars, offset, length);
        }
    }

    public void clearTopObjectsList() {
        if (this._topObjectsCreated == null) {
            this._topObjectsCreated = new LinkedList();
        } else {
            this._topObjectsCreated.clear();
        }
    }

    public void doctypeDecl(String name, String publicID, String systemID) throws CancelException {
        if (publicID != null && !publicID.trim().equals("") && !publicID.startsWith("-//UC Berkeley//DTD MoML")) {
            throw new CancelException("Public ID is not that of MoML version 1: " + publicID);
        }
    }

    public void endDocument() throws Exception {
        this._processPendingRequests();
        if (this._undoContext != null && this._undoContext.hasUndoMoML()) {
            NamedObj context;
            String undoMoML = this._undoContext.getUndoMoML();
            if (_undoDebug) {
                System.out.println("=======================");
                System.out.println("Generated UNDO MoML: ");
                System.out.print(undoMoML);
                System.out.println("=======================");
            }
            if ((context = this._current) == null) {
                context = this._toplevel;
            }
            MoMLUndoEntry newEntry = new MoMLUndoEntry(context, undoMoML);
            UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo(context);
            undoInfo.push(newEntry);
            this._resetUndo();
        }
        if (this._unrecognized != null) {
            StringBuffer warning = new StringBuffer("Warning: Unrecognized XML elements:");
            Iterator elements = this._unrecognized.iterator();
            while (elements.hasNext()) {
                warning.append(" " + elements.next().toString());
            }
            try {
                MessageHandler.warning(warning.toString());
            }
            catch (CancelException cancelException) {}
        }
        try {
            if (this._toplevel != null) {
                this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                this._toplevel.executeChangeRequests();
            }
            Iterator parameters = this._paramsToParse.iterator();
            HashSet<Settable> parametersValidated = new HashSet<Settable>();
            while (parameters.hasNext()) {
                Settable param = (Settable)parameters.next();
                if (parametersValidated.contains(param)) continue;
                try {
                    param.validate();
                    for (Settable derivedParam : ((NamedObj)((Object)param)).getDerivedList()) {
                        derivedParam.validate();
                        parametersValidated.add(derivedParam);
                    }
                    if (!(param instanceof SharedParameter)) continue;
                    parametersValidated.addAll(((SharedParameter)param).sharedParameterSet());
                }
                catch (Exception ex) {
                    int reply;
                    if (_handler != null && (reply = _handler.handleError("<param name=\"" + param.getName() + "\" value=\"" + param.getExpression() + "\"/>", param.getContainer(), ex)) == 0) continue;
                    throw ex;
                }
            }
        }
        finally {
            if (_handler != null) {
                _handler.enableErrorSkipping(false);
            }
        }
    }

    public void endElement(String elementName) throws Exception {
        String undoMoML;
        block61: {
            if (_filterList != null) {
                for (MoMLFilter filter : _filterList) {
                    filter.filterEndElement(this._current, elementName);
                }
            }
            if (this._skipElement <= 0) {
                if (elementName.equals("configure")) {
                    --this._configureNesting;
                    if (this._configureNesting < 0) {
                        throw new XmlException("Internal Error: _configureNesting is " + this._configureNesting + " which is <0, which indicates a nesting bug", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                } else if (elementName.equals("doc")) {
                    --this._docNesting;
                    if (this._docNesting < 0) {
                        throw new XmlException("Internal Error: _docNesting is " + this._docNesting + " which is <0, which indicates a nesting bug", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                }
                if (this._configureNesting > 0 || this._docNesting > 0) {
                    this._currentCharData.append("</");
                    this._currentCharData.append(elementName);
                    this._currentCharData.append(">");
                    return;
                }
            }
            if (this._skipRendition) {
                if (elementName.equals("rendition")) {
                    this._skipRendition = false;
                }
            } else if (this._skipElement > 0) {
                if (elementName.equals(this._skipElementName)) {
                    --this._skipElement;
                }
            } else if (elementName.equals("configure")) {
                try {
                    Configurable castCurrent = (Configurable)((Object)this._current);
                    String previousSource = castCurrent.getConfigureSource();
                    String previousText = castCurrent.getConfigureText();
                    castCurrent.configure(this._base, this._configureSource, this._currentCharData.toString());
                    try {
                        this._current.propagateValue();
                    }
                    catch (IllegalActionException ex) {
                        castCurrent.configure(this._base, previousSource, previousText);
                        throw ex;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            } else if (elementName.equals("doc")) {
                if (this._currentDocName == null && this._docNesting == 0) {
                    this._currentDocName = "_doc";
                }
                Documentation previous = (Documentation)this._current.getAttribute(this._currentDocName);
                String previousValue = null;
                if (previous != null) {
                    previousValue = previous.getValueAsString();
                }
                if (!this._currentCharData.toString().equals(previousValue)) {
                    if (previous != null) {
                        String newString = this._currentCharData.toString();
                        previous.setExpression(newString);
                        try {
                            previous.propagateValue();
                        }
                        catch (IllegalActionException ex) {
                            previous.setExpression(previousValue);
                            throw ex;
                        }
                    } else {
                        Documentation doc = new Documentation(this._current, this._currentDocName);
                        doc.setValue(this._currentCharData.toString());
                        doc.propagateExistence();
                        doc.propagateValue();
                    }
                }
                if (this._undoEnabled) {
                    this._undoContext.appendUndoMoML("<doc name=\"" + this._currentDocName + "\">");
                    if (previous != null) {
                        this._undoContext.appendUndoMoML(previousValue);
                    }
                    this._undoContext.appendUndoMoML("</doc>\n");
                }
                this._currentDocName = null;
            } else if (elementName.equals("group")) {
                this._processPendingRequests();
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
                try {
                    this._linkRequests = (List)this._linkRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._linkRequests = null;
                }
                try {
                    this._deleteRequests = (List)this._deleteRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._deleteRequests = null;
                }
            } else if (elementName.equals("class") || elementName.equals("entity") || elementName.equals("model")) {
                this._processPendingRequests();
                try {
                    this._current = (NamedObj)this._containers.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._current = null;
                }
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
                try {
                    this._linkRequests = (List)this._linkRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._linkRequests = null;
                }
                try {
                    this._deleteRequests = (List)this._deleteRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._deleteRequests = null;
                }
            } else if (elementName.equals("property") || elementName.equals("director") || elementName.equals("port") || elementName.equals("relation") || elementName.equals("rendition") || elementName.equals("vertex")) {
                try {
                    this._current = (NamedObj)this._containers.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._current = null;
                }
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
            }
            undoMoML = null;
            if (this._undoContext != null && this._undoContext.hasUndoMoML()) {
                undoMoML = this._undoContext.generateUndoEntry();
                if (_undoDebug) {
                    System.out.println("Completed element: " + elementName + "\n" + this._undoContext.getUndoMoML());
                }
            }
            try {
                this._undoContext = (UndoContext)this._undoContexts.pop();
                this._undoEnabled = this._undoContext.isUndoable();
            }
            catch (EmptyStackException emptyStackException) {
                if (!_undoDebug) break block61;
                System.out.println("Reached top level of undo context stack");
            }
        }
        if (undoMoML != null) {
            this._undoContext.pushUndoEntry(undoMoML);
        }
    }

    public void endExternalEntity(String systemID) {
        this._externalEntities.pop();
    }

    public void error(String message, String systemID, int line, int column) throws XmlException {
        String currentExternalEntity = "";
        try {
            currentExternalEntity = this._currentExternalEntity();
            if (this._toplevel != null) {
                this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                this._toplevel.executeChangeRequests();
            }
        }
        catch (Throwable throwable) {}
        throw new XmlException(message, currentExternalEntity, line, column);
    }

    public URL fileNameToURL(String source, URL base) throws Exception {
        URL result = null;
        StringBuffer errorMessage = new StringBuffer();
        InputStream input = null;
        try {
            result = new URL(base, source);
            String protocol = result.getProtocol();
            if (protocol != null && protocol.trim().toLowerCase().equals("http")) {
                SecurityManager security = System.getSecurityManager();
                boolean withinUntrustedApplet = false;
                if (security != null) {
                    try {
                        security.checkCreateClassLoader();
                    }
                    catch (SecurityException securityException) {
                        withinUntrustedApplet = true;
                    }
                }
                if (!(security != null && withinUntrustedApplet || _approvedRemoteXmlFiles.contains(result))) {
                    String resultBase = result.toString().substring(0, result.toString().lastIndexOf("/"));
                    if (this._base == null || !resultBase.startsWith(this._base.toString())) {
                        MessageHandler.warning("Security concern:\nAbout to look for MoML from the net at address:\n" + result.toExternalForm() + "\nOK to proceed?");
                    }
                    _approvedRemoteXmlFiles.add(result);
                }
            }
            input = result.openStream();
        }
        catch (IOException ioException) {
            errorMessage.append("-- " + ioException.getMessage() + "\n");
            result = this._classLoader.getResource(source);
            if (result != null) {
                input = result.openStream();
            }
            errorMessage.append("-- XML file not found relative to classpath.\n");
            String cwd = StringUtilities.getProperty("user.dir");
            try {
                base = new File(cwd).toURI().toURL();
                result = new URL(base, source);
                input = result.openStream();
            }
            catch (Throwable throwable) {
                errorMessage.append("-- " + cwd + File.separator + source + "\n" + throwable.getMessage() + "\n");
            }
        }
        if (input == null) {
            throw new XmlException(errorMessage.toString(), this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        input.close();
        return result;
    }

    public static ErrorHandler getErrorHandler() {
        return _handler;
    }

    public static IconLoader getIconLoader() {
        return _iconLoader;
    }

    public static List getMoMLFilters() {
        return _filterList;
    }

    public NamedObj getToplevel() {
        return this._toplevel;
    }

    public static boolean isModified() {
        return _modified;
    }

    public NamedObj parse(URL base, URL input) throws Exception {
        this._xmlFile = input;
        try {
            NamedObj namedObj;
            block15: {
                if (_imports == null) {
                    _imports = new HashMap();
                } else {
                    WeakReference reference = (WeakReference)_imports.get(input);
                    NamedObj previous = null;
                    if (reference != null && (previous = (NamedObj)reference.get()) == null) {
                        _imports.remove(input);
                    }
                    if (previous != null) {
                        NamedObj namedObj2 = previous;
                        return namedObj2;
                    }
                }
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = input.openStream();
                    }
                    catch (Exception ex) {
                        URL jarURL = ClassUtilities.jarURLEntryResource(input.toExternalForm());
                        if (jarURL != null) {
                            inputStream = jarURL.openStream();
                        }
                        throw ex;
                    }
                    NamedObj result = this.parse(base, inputStream);
                    _imports.put(input, new WeakReference<NamedObj>(result));
                    namedObj = result;
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return namedObj;
        }
        finally {
            this._xmlFile = null;
        }
    }

    public NamedObj parse(URL base, InputStream input) throws Exception {
        return this.parse(base, new InputStreamReader(input));
    }

    public NamedObj parse(URL base, Reader reader) throws Exception {
        block23: {
            this._base = base;
            BufferedReader buffered = new BufferedReader(reader);
            try {
                try {
                    this._xmlParser = new XmlParser();
                    this._xmlParser.setHandler((XmlHandler)this);
                    if (base == null) {
                        this._xmlParser.parse(null, null, (Reader)buffered);
                        break block23;
                    }
                    boolean xmlFileWasNull = false;
                    if (this._xmlFile == null) {
                        xmlFileWasNull = true;
                        this._xmlFile = new URL(base.toExternalForm());
                    }
                    try {
                        this._xmlParser.parse(base.toExternalForm(), null, (Reader)buffered);
                    }
                    finally {
                        if (xmlFileWasNull) {
                            this._xmlFile = null;
                        }
                    }
                }
                catch (CancelException cancelException) {
                    this._xmlParser = null;
                    ((Reader)buffered).close();
                    return null;
                }
                catch (Exception ex) {
                    if (this._toplevel != null && this._toplevel instanceof ComponentEntity) {
                        try {
                            ((ComponentEntity)this._toplevel).setContainer(null);
                        }
                        catch (Exception exception) {}
                        try {
                            this._workspace.getWriteAccess();
                            this._workspace.remove(this._toplevel);
                        }
                        finally {
                            this._workspace.doneWriting();
                        }
                        this._toplevel = null;
                    }
                    this._paramsToParse.clear();
                    this.reset();
                    if (base != null) {
                        MoMLParser.purgeModelRecord(base);
                    }
                    throw ex;
                }
            }
            finally {
                this._xmlParser = null;
                ((Reader)buffered).close();
            }
        }
        if (this._toplevel == null) {
            throw new Exception("Toplevel was null?  Perhaps the xml does not contain a Ptolemy model?\n base ='" + base + "',\n reader = '" + reader + "'");
        }
        MoMLParser parser = ParserAttribute.getParser(this._toplevel);
        if (parser != this) {
            ParserAttribute parserAttribute = (ParserAttribute)this._toplevel.getAttribute("_parser", ParserAttribute.class);
            if (parserAttribute == null) {
                parserAttribute = new ParserAttribute(this._toplevel, "_parser");
            }
            parserAttribute.setParser(this);
        }
        return this._toplevel;
    }

    public NamedObj parse(String text) throws Exception {
        String cwd = StringUtilities.getProperty("user.dir");
        URL base = new File(cwd).toURI().toURL();
        return this.parse(base, new StringReader(text));
    }

    public NamedObj parse(URL base, String text) throws Exception {
        return this.parse(base, new StringReader(text));
    }

    public NamedObj parseFile(String filename) throws Exception {
        String cwd = StringUtilities.getProperty("user.dir");
        URL base = new File(cwd).toURI().toURL();
        File file = new File(new File(cwd), filename);
        return this.parse(base, file.toURI().toURL());
    }

    public void processingInstruction(String target, String data) {
        if (this._currentCharData != null) {
            this._currentCharData.append("<?");
            this._currentCharData.append(target);
            this._currentCharData.append(" ");
            this._currentCharData.append(data);
            this._currentCharData.append("?>");
        }
    }

    public static void purgeAllModelRecords() {
        _imports = null;
    }

    public static void purgeModelRecord(URL url) {
        if (_imports != null && url != null) {
            Object modelToPurge;
            WeakReference reference = (WeakReference)_imports.get(url);
            if (reference != null && (modelToPurge = reference.get()) instanceof Instantiable) {
                boolean keepTheModel = false;
                List children = ((Instantiable)modelToPurge).getChildren();
                if (children != null) {
                    for (WeakReference child : children) {
                        if (child == null || child.get() == null) continue;
                        keepTheModel = true;
                        break;
                    }
                }
                if (keepTheModel) {
                    return;
                }
            }
            _imports.remove(url);
        }
    }

    public static void purgeModelRecord(String filename) throws MalformedURLException {
        String cwd = StringUtilities.getProperty("user.dir");
        File file = new File(new File(cwd), filename);
        MoMLParser.purgeModelRecord(file.toURI().toURL());
    }

    public void reset() {
        this._attributes = new HashMap();
        this._configureNesting = 0;
        this._containers = new Stack();
        this._linkRequests = null;
        this._linkRequestStack = new Stack();
        this._deleteRequests = null;
        this._deleteRequestStack = new Stack();
        this._current = null;
        this._docNesting = 0;
        this._externalEntities = new Stack();
        _modified = false;
        this._namespace = _DEFAULT_NAMESPACE;
        this._namespaces = new Stack();
        this._namespaceTranslations = new Stack();
        this._skipRendition = false;
        this._skipElementIsNew = false;
        this._skipElement = 0;
        this._toplevel = null;
        this._resetUndo();
    }

    public Object resolveEntity(String publicID, String systemID) {
        if (publicID != null && publicID.equals(MoML_PUBLIC_ID_1)) {
            return new StringReader(MoML_DTD_1);
        }
        return null;
    }

    public ComponentEntity searchForClass(String name, String source) throws Exception {
        ComponentEntity candidate;
        if (_imports != null && source != null) {
            ComponentEntity candidate2;
            WeakReference reference = (WeakReference)_imports.get(source);
            Object possibleCandidate = null;
            if (reference != null && (possibleCandidate = reference.get()) == null) {
                _imports.remove(source);
            }
            if (possibleCandidate instanceof ComponentEntity && (candidate2 = (ComponentEntity)possibleCandidate).isClassDefinition()) {
                String candidateClassName;
                String realClassName = name;
                int lastPeriod = name.lastIndexOf(".");
                if (lastPeriod >= 0 && name.length() > lastPeriod + 1) {
                    realClassName = name.substring(lastPeriod + 1);
                }
                if ((lastPeriod = (candidateClassName = candidate2.getClassName()).lastIndexOf(".")) >= 0 && candidateClassName.length() > lastPeriod + 1) {
                    candidateClassName = candidateClassName.substring(lastPeriod + 1);
                }
                if (candidateClassName.equals(realClassName)) {
                    return candidate2;
                }
            }
        }
        if (source == null && (candidate = this._searchForEntity(name, this._current)) != null && candidate.isClassDefinition()) {
            return candidate;
        }
        return null;
    }

    public void setContext(NamedObj context) {
        this.reset();
        this._toplevel = context.toplevel();
        this._current = context;
        this._originalContext = context;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        _handler = handler;
    }

    public static void setIconLoader(IconLoader loader) {
        _iconLoader = loader;
    }

    public static void setMoMLFilters(List filterList) {
        _filterList = filterList;
    }

    public static void setModified(boolean modified) {
        _modified = modified;
    }

    public void setToplevel(NamedObj toplevel) {
        this.reset();
        this._toplevel = toplevel;
    }

    public void setUndoable(boolean undoable) {
        this._undoEnabled = undoable;
    }

    public void startDocument() {
        this._paramsToParse.clear();
        this._unrecognized = null;
        if (_handler != null) {
            _handler.enableErrorSkipping(true);
        }
        this._previousDeferStatus = this._toplevel != null ? this._toplevel.setDeferringChangeRequests(true) : false;
        this._linkRequests = null;
        this._deleteRequests = null;
        this._linkRequestStack.clear();
        this._deleteRequestStack.clear();
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(String elementName) throws XmlException {
        block201: {
            block200: {
                pushedLinkRequests = false;
                pushedDeleteRequests = false;
                pushedUndoContexts = false;
                exceptionThrown = false;
                this._namespacesPushed = false;
                if (this._skipElement > 0 || this._configureNesting <= 0 && this._docNesting <= 0) break block200;
                if (elementName.equals("configure")) {
                    ++this._configureNesting;
                } else if (elementName.equals("doc")) {
                    ++this._docNesting;
                }
                this._currentCharData.append(this._getCurrentElement(elementName));
                this._attributes.clear();
                this._attributeNameList.clear();
lbl17:
                // 7 sources

                while (true) {
                    this._attributes.clear();
                    this._attributeNameList.clear();
                    if (exceptionThrown) {
                        if (pushedDeleteRequests) {
                            try {
                                this._deleteRequests = (List)this._deleteRequestStack.pop();
                            }
                            catch (EmptyStackException v0) {
                                this._deleteRequests = null;
                            }
                        }
                        if (pushedLinkRequests) {
                            try {
                                this._linkRequests = (List)this._linkRequestStack.pop();
                            }
                            catch (EmptyStackException v1) {
                                this._linkRequests = null;
                            }
                        }
                        if (this._namespacesPushed) {
                            try {
                                this._namespace = (String)this._namespaces.pop();
                                this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                            }
                            catch (EmptyStackException v2) {
                                this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                            }
                        }
                        if (pushedUndoContexts) {
                            try {
                                this._undoContext = (UndoContext)this._undoContexts.pop();
                            }
                            catch (EmptyStackException v3) {}
                        }
                    }
                    return;
                }
            }
            try {
                try {
                    block203: {
                        block204: {
                            if (this._skipRendition) ** GOTO lbl17
                            v4 = this._undoEnabled = this._undoEnabled != false && this._isUndoableElement(elementName) != false;
                            if (this._undoContext != null) {
                                this._undoContexts.push(this._undoContext);
                                pushedUndoContexts = true;
                                this._undoEnabled = this._undoEnabled != false && this._undoContext.hasUndoableChildren() != false;
                            }
                            this._undoContext = new UndoContext(this._undoEnabled);
                            if (MoMLParser._undoDebug) {
                                System.out.println("Current start element: " + elementName);
                            }
                            if (this._skipElement <= 0) break block203;
                            if (!elementName.equals(this._skipElementName)) ** GOTO lbl17
                            if (!this._skipElementIsNew) break block204;
                            this._skipElementIsNew = false;
                            ** GOTO lbl17
                        }
                        ++this._skipElement;
                        ** GOTO lbl17
                    }
                    if (elementName.equals("class")) {
                        className = (String)this._attributes.get("extends");
                        entityName = (String)this._attributes.get("name");
                        source = (String)this._attributes.get("source");
                        this._checkForNull(entityName, "No name for element \"class\"");
                        entity = this._searchForEntity(entityName, this._current);
                        v5 = existedAlready = entity != null;
                        if (!existedAlready) {
                            candidate = this._createEntity(className, entityName, source);
                            if (candidate instanceof Entity) {
                                entity = (Entity)candidate;
                            } else {
                                throw new IllegalActionException((Nameable)this._current, "Attempt to create a class named " + entityName + " from a class that " + "is not a subclass of Entity: " + className);
                            }
                        }
                        if (this._deleteRequests != null) {
                            this._deleteRequestStack.push(this._deleteRequests);
                            pushedDeleteRequests = true;
                        }
                        this._deleteRequests = new LinkedList<E>();
                        if (this._linkRequests != null) {
                            this._linkRequestStack.push(this._linkRequests);
                            pushedLinkRequests = true;
                        }
                        this._linkRequests = new LinkedList<E>();
                        if (this._current != null) {
                            this._pushContext();
                        } else if (this._toplevel == null) {
                            this._toplevel = entity.toplevel();
                            this._toplevel.setDeferringChangeRequests(true);
                            if (this._xmlFile != null) {
                                attribute = new URIAttribute(this._toplevel, "_uri");
                                attribute.setURL(this._xmlFile);
                            }
                        }
                        converted = false;
                        if (!existedAlready) {
                            entity.setClassDefinition(true);
                            entity.setClassName(className);
                        } else if (!entity.isClassDefinition()) {
                            entity.setClassDefinition(true);
                            converted = true;
                        }
                        this._current = entity;
                        this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        if (this._undoEnabled) {
                            if (existedAlready) {
                                if (!converted) {
                                    this._undoContext.appendUndoMoML("<class name=\"" + entityName + "\" >\n");
                                    this._undoContext.appendClosingUndoMoML("</class>\n");
                                } else {
                                    this._undoContext.appendUndoMoML("<entity name=\"" + entityName + "\" >\n");
                                    this._undoContext.appendClosingUndoMoML("</entity>\n");
                                }
                                this._undoContext.setChildrenUndoable(true);
                            } else {
                                this._undoContext.appendUndoMoML("<deleteEntity name=\"" + entityName + "\" />\n");
                                this._undoContext.setChildrenUndoable(false);
                                this._undoContext.setUndoable(false);
                                this._undoEnabled = false;
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("configure")) {
                        this._checkClass(this._current, Configurable.class, "Element \"configure\" found inside an element that does not implement Configurable. It is: " + this._current);
                        this._configureSource = (String)this._attributes.get("source");
                        this._currentCharData = new StringBuffer();
                        ++this._configureNesting;
                        break block201;
                    }
                    if (elementName.equals("deleteEntity")) {
                        entityName = (String)this._attributes.get("name");
                        this._checkForNull(entityName, "No name for element \"deleteEntity\"");
                        request = new DeleteRequest(MoMLParser._DELETE_ENTITY, entityName, null);
                        if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                            this._deleteRequests.add(request);
                        } else {
                            request.execute();
                        }
                        break block201;
                    }
                    if (elementName.equals("deletePort")) {
                        portName = (String)this._attributes.get("name");
                        this._checkForNull(portName, "No name for element \"deletePort\"");
                        entityName = (String)this._attributes.get("entity");
                        toDelete = null;
                        try {
                            toDelete = this._searchForPort(portName);
                        }
                        catch (XmlException v6) {}
                        if (toDelete != null && (container = toDelete.getContainer()) != null && container instanceof Entity && (attribute = ((Entity)container).getAttribute(portName)) != null && attribute instanceof PortParameter) {
                            request = new DeleteRequest(MoMLParser._DELETE_PROPERTY, attribute.getName(), null);
                            if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                                this._deleteRequests.add(request);
                            } else {
                                request.execute();
                            }
                        }
                        request = new DeleteRequest(MoMLParser._DELETE_PORT, portName, entityName);
                        if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                            this._deleteRequests.add(request);
                        } else {
                            request.execute();
                        }
                        break block201;
                    }
                    if (elementName.equals("deleteProperty")) {
                        propName = (String)this._attributes.get("name");
                        this._checkForNull(propName, "No name for element \"deleteProperty\"");
                        request = new DeleteRequest(MoMLParser._DELETE_PROPERTY, propName, null);
                        toDelete = this._searchForAttribute(propName);
                        if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                            this._deleteRequests.add(request);
                        } else {
                            request.execute();
                        }
                        container = toDelete.getContainer();
                        if (container != null && container instanceof Entity && (port = ((Entity)container).getPort(propName)) != null && port instanceof ParameterPort) {
                            request = new DeleteRequest(MoMLParser._DELETE_PORT, port.getName(), container.getFullName());
                            if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                                this._deleteRequests.add(request);
                            } else {
                                request.execute();
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("deleteRelation")) {
                        relationName = (String)this._attributes.get("name");
                        this._checkForNull(relationName, "No name for element \"deleteRelation\"");
                        request = new DeleteRequest(MoMLParser._DELETE_RELATION, relationName, null);
                        if (this._deleteRequests != null && this._current instanceof InstantiableNamedObj) {
                            this._deleteRequests.add(request);
                        } else {
                            request.execute();
                        }
                        break block201;
                    }
                    if (elementName.equals("director")) {
                        className = (String)this._attributes.get("class");
                        this._checkForNull(className, "No class for element \"director\"");
                        dirName = (String)this._attributes.get("name");
                        this._checkForNull(dirName, "No name for element \"director\"");
                        this._checkClass(this._current, CompositeActor.class, "Element \"director\" found inside an element that is not a CompositeActor. It is: " + this._current);
                        arguments = new Object[]{this._current, dirName};
                        this._pushContext();
                        newClass = Class.forName(className, true, this._classLoader);
                        this._current = this._createInstance(newClass, arguments);
                        this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        break block201;
                    }
                    if (elementName.equals("display")) {
                        displayName = (String)this._attributes.get("name");
                        if (this._current != null) {
                            derivedObjects = this._current.getDerivedList().iterator();
                            currentName = this._current.getName();
                            while (derivedObjects.hasNext()) {
                                derived = (NamedObj)derivedObjects.next();
                                if (!derived.getName().equals(currentName) || displayName == null) continue;
                                if (displayName.equals(currentName)) {
                                    derived.setDisplayName(null);
                                    continue;
                                }
                                derived.setDisplayName(displayName);
                            }
                            oldDisplayName = this._current.getDisplayName();
                            if (displayName != null) {
                                if (displayName.equals(currentName) || displayName.equals("")) {
                                    this._current.setDisplayName(null);
                                } else {
                                    this._current.setDisplayName(displayName);
                                }
                                if (this._undoEnabled) {
                                    this._undoContext.appendUndoMoML("<display name=\"" + StringUtilities.escapeForXML(oldDisplayName) + "\"/>\n");
                                    this._undoContext.setChildrenUndoable(false);
                                    ** GOTO lbl666
                                }
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("doc")) {
                        this._currentDocName = (String)this._attributes.get("name");
                        this._currentCharData = new StringBuffer();
                        ++this._docNesting;
                        break block201;
                    }
                    if (elementName.equals("entity") || elementName.equals("model")) {
                        className = (String)this._attributes.get("class");
                        entityName = (String)this._attributes.get("name");
                        this._checkForNull(entityName, "No name for element \"entity\"");
                        source = (String)this._attributes.get("source");
                        entity = this._searchForEntity(entityName, this._current);
                        existedAlready = entity != null;
                        converted = false;
                        if (existedAlready) {
                            if (entity.isClassDefinition()) {
                                entity.setClassDefinition(false);
                                converted = true;
                            }
                        } else {
                            candidate = this._createEntity(className, entityName, source);
                            if (candidate instanceof Entity) {
                                entity = (Entity)candidate;
                                entity.setClassName(className);
                            } else {
                                throw new IllegalActionException((Nameable)this._current, "Attempt to create an entity named " + entityName + " from a class that " + "is not a subclass of Entity: " + className);
                            }
                        }
                        if (this._deleteRequests != null) {
                            this._deleteRequestStack.push(this._deleteRequests);
                            pushedDeleteRequests = true;
                        }
                        this._deleteRequests = new LinkedList<E>();
                        if (this._linkRequests != null) {
                            this._linkRequestStack.push(this._linkRequests);
                            pushedLinkRequests = true;
                        }
                        this._linkRequests = new LinkedList<E>();
                        if (this._current != null) {
                            this._pushContext();
                        } else if (this._toplevel == null) {
                            this._toplevel = entity.toplevel();
                            this._toplevel.setDeferringChangeRequests(true);
                            if (this._xmlFile != null) {
                                attribute = new URIAttribute(this._toplevel, "_uri");
                                attribute.setURL(this._xmlFile);
                            }
                        }
                        this._current = entity;
                        this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        if (this._undoEnabled) {
                            if (existedAlready) {
                                if (!converted) {
                                    this._undoContext.appendUndoMoML("<entity name=\"" + entityName + "\" >\n");
                                    this._undoContext.appendClosingUndoMoML("</entity>\n");
                                } else {
                                    this._undoContext.appendUndoMoML("<class name=\"" + entityName + "\" >\n");
                                    this._undoContext.appendClosingUndoMoML("</class>\n");
                                }
                                this._undoContext.setChildrenUndoable(true);
                            } else {
                                this._undoContext.appendUndoMoML("<deleteEntity name=\"" + entityName + "\" />\n");
                                this._undoContext.setChildrenUndoable(false);
                                this._undoContext.setUndoable(false);
                                this._undoEnabled = false;
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("group")) {
                        groupName = (String)this._attributes.get("name");
                        if (groupName != null) {
                            this._namespaces.push(this._namespace);
                            this._namespaceTranslations.push(this._namespaceTranslationTable);
                            this._namespacesPushed = true;
                            if (groupName.equals("auto")) {
                                this._namespace = MoMLParser._AUTO_NAMESPACE;
                                this._namespaceTranslationTable = new HashMap<K, V>();
                            } else {
                                this._namespace = groupName;
                            }
                        } else {
                            this._namespaces.push(MoMLParser._DEFAULT_NAMESPACE);
                            this._namespaceTranslations.push(this._namespaceTranslationTable);
                            this._namespacesPushed = true;
                            this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                            this._namespaceTranslationTable = new HashMap<K, V>();
                        }
                        if (this._deleteRequests != null) {
                            this._deleteRequestStack.push(this._deleteRequests);
                            pushedDeleteRequests = true;
                        }
                        this._deleteRequests = new LinkedList<E>();
                        if (this._linkRequests != null) {
                            this._linkRequestStack.push(this._linkRequests);
                            pushedLinkRequests = true;
                        }
                        this._linkRequests = new LinkedList<E>();
                        if (this._undoEnabled) {
                            this._undoContext.appendUndoMoML("<group>\n");
                            this._undoContext.appendClosingUndoMoML("</group>\n");
                            this._undoContext.setChildrenUndoable(true);
                        }
                        break block201;
                    }
                    if (elementName.equals("input")) {
                        source = (String)this._attributes.get("source");
                        this._checkForNull(source, "No source for element \"input\"");
                        skip = false;
                        if (MoMLParser.inputFileNamesToSkip != null) {
                            for (String inputFileName : MoMLParser.inputFileNamesToSkip) {
                                if (!source.endsWith(inputFileName)) continue;
                                skip = true;
                                break;
                            }
                        }
                        if (!skip) {
                            modified = MoMLParser.isModified();
                            newParser = new MoMLParser(this._workspace, this._classLoader);
                            newParser.setContext(this._current);
                            MoMLParser.setModified(modified);
                            this._parse(newParser, this._base, source);
                        }
                        break block201;
                    }
                    if (elementName.equals("link")) {
                        portName = (String)this._attributes.get("port");
                        relationName = (String)this._attributes.get("relation");
                        insertAtSpec = (String)this._attributes.get("insertAt");
                        insertInsideAtSpec = (String)this._attributes.get("insertInsideAt");
                        if (portName != null) {
                            request = new LinkRequest(portName, relationName, insertAtSpec, insertInsideAtSpec);
                        } else {
                            relation1Name = (String)this._attributes.get("relation1");
                            relation2Name = (String)this._attributes.get("relation2");
                            request = new LinkRequest(relation1Name, relation2Name);
                        }
                        if (this._linkRequests != null) {
                            this._linkRequests.add(request);
                        } else {
                            request.execute();
                        }
                        break block201;
                    }
                    if (elementName.equals("port")) {
                        className = (String)this._attributes.get("class");
                        portName = (String)this._attributes.get("name");
                        this._checkForNull(portName, "No name for element \"port\"");
                        this._checkClass(this._current, Entity.class, "Element \"port\" found inside an element that is not an Entity. It is: " + this._current);
                        container = (Entity)this._current;
                        newClass = null;
                        if (className != null && !className.trim().equals("")) {
                            newClass = Class.forName(className, true, this._classLoader);
                        }
                        v7 = alreadyExisted = (port = container.getPort(portName)) != null;
                        if (port != null) {
                            if (newClass != null) {
                                this._checkClass(port, newClass, "port named \"" + portName + "\" exists and is not an instance of " + className);
                            }
                        } else {
                            derivedList = container.getDerivedList();
                            for (Entity derived : derivedList) {
                                if (derived.getPort(portName) == null) continue;
                                throw new IllegalActionException((Nameable)container, "Cannot create port because a subclass or instance contains a port with the same name: " + derived.getPort(portName).getFullName());
                            }
                            if (newClass == null) {
                                port = container.newPort(portName);
                                if (this._topObjectsCreated != null && container == this._originalContext) {
                                    this._topObjectsCreated.add(port);
                                }
                                port.propagateExistence();
                            } else {
                                arguments = new Object[]{container, portName};
                                port = (Port)this._createInstance(newClass, arguments);
                                port.propagateExistence();
                            }
                        }
                        this._pushContext();
                        this._current = port;
                        this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        if (this._undoEnabled) {
                            if (alreadyExisted) {
                                this._undoContext.appendUndoMoML("<port name=\"" + portName + "\" ");
                                if (className != null) {
                                    this._undoContext.appendUndoMoML("class=\"" + className + "\" ");
                                }
                                this._undoContext.appendUndoMoML(">\n");
                                this._undoContext.appendClosingUndoMoML("</port>\n");
                                this._undoContext.setChildrenUndoable(true);
                            } else {
                                this._undoContext.appendUndoMoML("<deletePort name=\"" + portName + "\" />\n");
                                this._undoContext.setChildrenUndoable(false);
                                this._undoContext.setUndoable(false);
                                this._undoEnabled = false;
                            }
                        }
                        if (port instanceof IOPort && (direction = (String)this._attributes.get("direction")) != null) {
                            ioport = (IOPort)port;
                            isOutput = direction.equals("output") != false || direction.equals("both") != false;
                            v8 = isInput = direction.equals("input") != false || direction.equals("both") != false;
                            if (alreadyExisted && ioport.getDerivedLevel() < 0x7FFFFFFF && (ioport.isInput() != isInput || ioport.isOutput() != isOutput)) {
                                throw new IllegalActionException((Nameable)ioport, "Cannot change whether this port is an input or output. That property is fixed by the class definition.");
                            }
                            ioport.setOutput(isOutput);
                            ioport.setInput(isInput);
                        }
                        break block201;
                    }
                    if (elementName.equals("property")) {
                        createIfNecessary = (String)this._attributes.get("createIfNecessary");
                        className = (String)this._attributes.get("class");
                        propertyName = (String)this._attributes.get("name");
                        this._checkForNull(propertyName, "No name for element \"property\"");
                        if (createIfNecessary == null || !createIfNecessary.equals("true") || this._current == null || propertyName == null || this._current.getAttribute(propertyName) == null) {
                            value = (String)this._attributes.get("value");
                            this._handlePropertyElement(className, propertyName, value);
                        }
                        break block201;
                    }
                    if (elementName.equals("relation")) {
                        className = (String)this._attributes.get("class");
                        relationName = (String)this._attributes.get("name");
                        this._checkForNull(relationName, "No name for element \"relation\"");
                        this._checkClass(this._current, CompositeEntity.class, "Element \"relation\" found inside an element that is not a CompositeEntity. It is: " + this._current);
                        container = (CompositeEntity)this._current;
                        newClass = null;
                        if (className != null) {
                            newClass = Class.forName(className, true, this._classLoader);
                        }
                        v9 = alreadyExisted = (relation = container.getRelation(relationName)) != null;
                        if (relation == null) {
                            derivedList = container.getDerivedList();
                            for (CompositeEntity derived : derivedList) {
                                if (derived.getRelation(relationName) == null) continue;
                                throw new IllegalActionException((Nameable)container, "Cannot create relation because a subclass or instance contains a relation with the same name: " + derived.getRelation(relationName).getFullName());
                            }
                            newRelation = null;
                            this._pushContext();
                            if (newClass == null) {
                                newRelation = container.newRelation(relationName);
                                if (this._topObjectsCreated != null && container == this._originalContext) {
                                    this._topObjectsCreated.add(newRelation);
                                }
                                newRelation.propagateExistence();
                            } else {
                                arguments = new Object[]{(CompositeEntity)this._current, relationName};
                                newRelation = this._createInstance(newClass, arguments);
                                newRelation.propagateExistence();
                            }
                            this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                            this._current = newRelation;
                        } else {
                            if (newClass != null) {
                                this._checkClass(relation, newClass, "relation named \"" + relationName + "\" exists and is not an instance of " + className);
                            }
                            this._pushContext();
                            this._current = relation;
                            this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        }
                        if (this._undoEnabled) {
                            if (alreadyExisted) {
                                this._undoContext.appendUndoMoML("<relation name=\"" + relationName + "\" ");
                                if (className != null) {
                                    this._undoContext.appendUndoMoML("class=\"" + className + "\" ");
                                }
                                this._undoContext.appendUndoMoML(">\n");
                                this._undoContext.appendClosingUndoMoML("</relation>\n");
                                this._undoContext.setChildrenUndoable(true);
                            } else {
                                this._undoContext.appendUndoMoML("<deleteRelation name=\"" + relationName + "\" />\n");
                                this._undoContext.setChildrenUndoable(false);
                                this._undoContext.setUndoable(false);
                                this._undoEnabled = false;
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("rename")) {
                        block202: {
                            newName = (String)this._attributes.get("name");
                            this._checkForNull(newName, "No new name for element \"rename\"");
                            if (this._current == null) break block201;
                            oldName = this._current.getName();
                            if (!oldName.equals(newName) && this._current.getDerivedLevel() < 0x7FFFFFFF) {
                                throw new IllegalActionException((Nameable)this._current, "Cannot change the name to " + newName + ". The name is fixed by the class definition.");
                            }
                            derivedObjects = this._current.getDerivedList().iterator();
                            changedName = new HashSet<NamedObj>();
                            changedClassName = new HashMap<NamedObj, String>();
                            derived = null;
                            try {
                                while (derivedObjects.hasNext()) {
                                    derived = (NamedObj)derivedObjects.next();
                                    if (derived.getName().equals(oldName)) {
                                        derived.setName(newName);
                                        changedName.add(derived);
                                    }
                                    if (!(derived instanceof Instantiable) || (parent = ((Instantiable)derived).getParent()) == null || parent != this._current && !changedName.contains(parent)) continue;
                                    previousClassName = derived.getClassName();
                                    last = previousClassName.lastIndexOf(oldName);
                                    if (last < 0) {
                                        throw new InternalErrorException("Expected instance " + derived.getFullName() + " to have class name ending with " + oldName + " but its class name is " + previousClassName);
                                    }
                                    newClassName = newName;
                                    if (last > 0) {
                                        newClassName = String.valueOf(previousClassName.substring(0, last)) + newName;
                                    }
                                    derived.setClassName(newClassName);
                                    changedClassName.put(derived, previousClassName);
                                }
                                break block202;
                            }
                            catch (NameDuplicationException ex) {
                                ** for (revert : changedName)
                            }
lbl-1000:
                            // 1 sources

                            {
                                revert.setName(oldName);
                                continue;
                            }
lbl517:
                            // 2 sources

                            for (Map.Entry<K, V> revert : changedClassName.entrySet()) {
                                toFix = (NamedObj)revert.getKey();
                                previousClassName = (String)revert.getValue();
                                toFix.setClassName(previousClassName);
                            }
                            throw new IllegalActionException((Nameable)this._current, ex, "Propagation to instance and/or derived class causesname duplication: " + derived.getFullName());
                        }
                        this._current.setName(newName);
                        if (this._undoEnabled) {
                            parentContext = (UndoContext)this._undoContexts.peek();
                            parentContext.applyRename(newName);
                            this._undoContext.appendUndoMoML("<rename name=\"" + oldName + "\" />\n");
                            this._undoContext.setChildrenUndoable(false);
                        }
                        if (this._current instanceof Instantiable && ((Instantiable)this._current).isClassDefinition() && (deferredFrom = ((Instantiable)this._current).getChildren()) != null) {
                            for (WeakReference reference : deferredFrom) {
                                deferrer = (InstantiableNamedObj)reference.get();
                                if (deferrer == null) continue;
                                replacementName = newName;
                                if (deferrer.getClassName().startsWith(".")) {
                                    replacementName = this._current.getFullName();
                                }
                                deferrer.setClassName(replacementName);
                            }
                        }
                        break block201;
                    }
                    if (elementName.equals("rendition")) {
                        this._skipRendition = true;
                        break block201;
                    }
                    if (elementName.equals("unlink")) {
                        portName = (String)this._attributes.get("port");
                        relationName = (String)this._attributes.get("relation");
                        indexSpec = (String)this._attributes.get("index");
                        insideIndexSpec = (String)this._attributes.get("insideIndex");
                        if (portName != null) {
                            request = new UnlinkRequest(portName, relationName, indexSpec, insideIndexSpec);
                        } else {
                            relation1Name = (String)this._attributes.get("relation1");
                            relation2Name = (String)this._attributes.get("relation2");
                            request = new UnlinkRequest(relation1Name, relation2Name);
                        }
                        if (this._linkRequests != null) {
                            this._linkRequests.add(request);
                        } else {
                            request.execute();
                        }
                        break block201;
                    }
                    if (elementName.equals("vertex")) {
                        vertexName = (String)this._attributes.get("name");
                        this._checkForNull(vertexName, "No name for element \"vertex\"");
                        this._checkClass(this._current, Relation.class, "Element \"vertex\" found inside an element that is not a Relation. It is: " + this._current);
                        previous = (Vertex)this._current.getAttribute(vertexName);
                        previousValue = null;
                        if (previous != null) {
                            previousValue = previous.getExpression();
                        }
                        if ((vertex = previous) == null) {
                            vertex = new Vertex((Relation)this._current, vertexName);
                            vertex.propagateExistence();
                        }
                        if ((value = (String)this._attributes.get("value")) != null && !value.equals(previousValue)) {
                            vertex.setExpression(value);
                            try {
                                vertex.propagateValue();
                                this._paramsToParse.add(vertex);
                            }
                            catch (IllegalActionException ex) {
                                vertex.setExpression(previousValue);
                                throw ex;
                            }
                        }
                        this._pushContext();
                        this._current = vertex;
                        this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        if (this._undoEnabled) {
                            this._undoContext.appendUndoMoML("<vertex name=\"" + vertexName + "\" ");
                            if (previousValue != null) {
                                this._undoContext.appendUndoMoML("value=\"" + previousValue + "\" ");
                            }
                            this._undoContext.appendUndoMoML(">\n");
                            this._undoContext.setChildrenUndoable(true);
                            this._undoContext.appendClosingUndoMoML("</vertex>\n");
                        }
                        break block201;
                    }
                    if (this._unrecognized == null) {
                        this._unrecognized = new LinkedList<E>();
                    }
                    this._unrecognized.add(elementName);
                }
                catch (InvocationTargetException ex) {
                    block205: {
                        block206: {
                            exceptionThrown = true;
                            if (MoMLParser._handler == null) break block205;
                            reply = MoMLParser._handler.handleError(this._getCurrentElement(elementName), this._current, ex.getTargetException());
                            if (reply != 0) break block206;
                            this._attributes.clear();
                            this._attributeNameList.clear();
                            this._skipElement = 1;
                            this._skipElementName = elementName;
                            ** GOTO lbl17
                        }
                        if (reply == 1) {
                            throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                    }
                    throw new XmlException("XML element \"" + elementName + "\" triggers exception:\n  " + ex.getTargetException(), this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), ex.getTargetException());
                }
                catch (Exception ex) {
                    exceptionThrown = true;
                    if (MoMLParser._handler != null) {
                        reply = MoMLParser._handler.handleError(this._getCurrentElement(elementName), this._current, ex);
                        if (reply == 0) {
                            this._attributes.clear();
                            this._attributeNameList.clear();
                            this._skipElement = 1;
                            this._skipElementName = elementName;
                            ** continue;
                        }
                        if (reply == 1) {
                            if (this._toplevel != null) {
                                this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                                this._toplevel.executeChangeRequests();
                            }
                            throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                    }
                    if (this._toplevel != null) {
                        this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                        this._toplevel.executeChangeRequests();
                    }
                    if (ex instanceof XmlException) {
                        throw (XmlException)ex;
                    }
                    throw new XmlException("XML element \"" + elementName + "\" triggers exception.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex);
                }
            }
            catch (Throwable var18_116) {
                this._attributes.clear();
                this._attributeNameList.clear();
                if (exceptionThrown) {
                    if (pushedDeleteRequests) {
                        try {
                            this._deleteRequests = (List)this._deleteRequestStack.pop();
                        }
                        catch (EmptyStackException v10) {
                            this._deleteRequests = null;
                        }
                    }
                    if (pushedLinkRequests) {
                        try {
                            this._linkRequests = (List)this._linkRequestStack.pop();
                        }
                        catch (EmptyStackException v11) {
                            this._linkRequests = null;
                        }
                    }
                    if (this._namespacesPushed) {
                        try {
                            this._namespace = (String)this._namespaces.pop();
                            this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                        }
                        catch (EmptyStackException v12) {
                            this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                        }
                    }
                    if (pushedUndoContexts) {
                        try {
                            this._undoContext = (UndoContext)this._undoContexts.pop();
                        }
                        catch (EmptyStackException v13) {}
                    }
                }
                throw var18_116;
            }
        }
        this._attributes.clear();
        this._attributeNameList.clear();
        if (exceptionThrown) {
            if (pushedDeleteRequests) {
                try {
                    this._deleteRequests = (List)this._deleteRequestStack.pop();
                }
                catch (EmptyStackException v14) {
                    this._deleteRequests = null;
                }
            }
            if (pushedLinkRequests) {
                try {
                    this._linkRequests = (List)this._linkRequestStack.pop();
                }
                catch (EmptyStackException v15) {
                    this._linkRequests = null;
                }
            }
            if (this._namespacesPushed) {
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException v16) {
                    this._namespace = MoMLParser._DEFAULT_NAMESPACE;
                }
            }
            if (pushedUndoContexts) {
                try {
                    this._undoContext = (UndoContext)this._undoContexts.pop();
                }
                catch (EmptyStackException v17) {}
            }
        }
    }

    public void startExternalEntity(String systemID) {
        this._externalEntities.push(systemID);
    }

    public List topObjectsCreated() {
        return this._topObjectsCreated;
    }

    protected String _currentExternalEntity() {
        try {
            return (String)this._externalEntities.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private void _addParamsToParamsToParse(NamedObj object) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._addParamsToParamsToParse(containedObject);
        }
    }

    private ComponentEntity _attemptToFindMoMLClass(String className, String source) throws Exception {
        String classAsFile = null;
        String altClassAsFile = null;
        ComponentEntity reference = null;
        if (source == null) {
            classAsFile = String.valueOf(className.replace('.', '/')) + ".xml";
            altClassAsFile = String.valueOf(className.replace('.', '/')) + ".moml";
        } else {
            classAsFile = source;
        }
        URL url = null;
        try {
            url = this.fileNameToURL(classAsFile, this._base);
            if (_imports != null) {
                WeakReference possiblePrevious = (WeakReference)_imports.get(url);
                NamedObj previous = null;
                if (possiblePrevious != null && (previous = (NamedObj)possiblePrevious.get()) == null) {
                    _imports.remove(url);
                }
                if (previous instanceof ComponentEntity) {
                    return (ComponentEntity)previous;
                }
            }
        }
        catch (Exception exception) {}
        MoMLParser newParser = new MoMLParser(this._workspace, this._classLoader);
        NamedObj candidateReference = null;
        try {
            candidateReference = this._findOrParse(newParser, this._base, classAsFile, className, source);
        }
        catch (Exception ex2) {
            url = null;
            if (altClassAsFile != null) {
                url = this.fileNameToURL(altClassAsFile, this._base);
                if (_imports != null) {
                    WeakReference possiblePrevious = (WeakReference)_imports.get(url);
                    NamedObj previous = null;
                    if (possiblePrevious != null && (previous = (NamedObj)possiblePrevious.get()) == null) {
                        _imports.remove(url);
                    }
                    if (previous instanceof ComponentEntity) {
                        return (ComponentEntity)previous;
                    }
                }
                try {
                    candidateReference = this._findOrParse(newParser, this._base, altClassAsFile, className, source);
                    classAsFile = altClassAsFile;
                }
                catch (Exception exception) {
                    throw new XmlException("Could not find '" + classAsFile + "' or '" + altClassAsFile + "' using base '" + this._base + "': ", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex2);
                }
            }
            throw ex2;
        }
        if (!(candidateReference instanceof ComponentEntity)) {
            throw new XmlException("File " + classAsFile + " does not define a ComponentEntity.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        reference = (ComponentEntity)candidateReference;
        String referenceName = reference.getName();
        if (!className.equals(referenceName) && !className.endsWith("." + referenceName)) {
            reference = reference instanceof CompositeEntity ? (className.startsWith(String.valueOf(referenceName) + ".") ? ((CompositeEntity)reference).getEntity(className.substring(referenceName.length() + 1)) : null) : null;
            if (reference == null) {
                throw new XmlException("File " + classAsFile + " does not define a class named " + className, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
            }
        }
        this._loadIconForClass(className, reference);
        if (reference != null) {
            if (_imports == null) {
                _imports = new HashMap();
            }
            _imports.put(url, new WeakReference<ComponentEntity>(reference));
        }
        return reference;
    }

    private void _checkClass(Object object, Class correctClass, String msg) throws XmlException {
        if (!correctClass.isInstance(object)) {
            throw new XmlException(msg, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
    }

    private void _checkForNull(Object object, String message) throws XmlException {
        if (object == null) {
            throw new XmlException(message, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
    }

    private NamedObj _createEntity(String className, String entityName, String source) throws Exception {
        URIAttribute modelURI;
        if (this._current != null && !(this._current instanceof CompositeEntity)) {
            throw new XmlException("Cannot create an entity inside of another that is not a CompositeEntity (Container is '" + this._current + "').", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity container = (CompositeEntity)this._current;
        ComponentEntity previous = this._searchForEntity(entityName, this._current);
        Class<?> newClass = null;
        ComponentEntity reference = null;
        if (className != null) {
            reference = this.searchForClass(className, source);
            if (reference == null && source == null) {
                reference = this._searchForClassInContext(className, null);
            }
            if (reference == null) {
                try {
                    newClass = Class.forName(className, true, this._classLoader);
                }
                catch (Exception exception) {
                    try {
                        reference = this._attemptToFindMoMLClass(className, source);
                    }
                    catch (Exception ex2) {
                        throw new IllegalActionException(null, ex2, "Cannot find class: " + className);
                    }
                }
                catch (Error error) {
                    StringBuffer errorMessage = new StringBuffer();
                    if (error instanceof ExceptionInInitializerError) {
                        Throwable staticThrowable = ((ExceptionInInitializerError)error).getCause();
                        errorMessage.append("ExceptionInInitializerError: Caused by:\n " + KernelException.stackTraceToString(staticThrowable));
                    } else {
                        errorMessage.append(String.valueOf(className) + ": \n " + error.toString() + "\n");
                    }
                    try {
                        reference = this._attemptToFindMoMLClass(className, source);
                    }
                    catch (XmlException ex2) {
                        throw new Exception("-- " + errorMessage.toString() + className + ": XmlException:\n" + ex2.getMessage());
                    }
                    catch (ClassFormatError ex3) {
                        throw new Exception("-- :" + errorMessage.toString() + className + ": ClassFormatError: " + "found invalid Java class file.\n" + ex3.getMessage());
                    }
                    catch (Exception ex4) {
                        throw new Exception("-- " + errorMessage.toString() + className + ": Exception:\n" + ex4.getMessage());
                    }
                }
            }
        }
        if (previous != null) {
            if (newClass != null) {
                this._checkClass(previous, newClass, "entity named \"" + entityName + "\" exists and is not an instance of " + className);
            }
            return previous;
        }
        this._checkForNull(className, "Cannot create entity without a class name.");
        if (reference == null) {
            if (this._current != null) {
                List derivedList = container.getDerivedList();
                for (CompositeEntity derived : derivedList) {
                    if (derived.getEntity(entityName) == null) continue;
                    throw new IllegalActionException((Nameable)container, "Cannot create entity because a subclass or instance contains an entity with the same name: " + derived.getEntity(entityName).getFullName());
                }
                this._checkClass(this._current, CompositeEntity.class, "Cannot create an entity inside an element that is not a CompositeEntity. It is: " + this._current);
                Object[] arguments = new Object[]{this._current, entityName};
                NamedObj newEntity = this._createInstance(newClass, arguments);
                newEntity.propagateExistence();
                this._loadIconForClass(className, newEntity);
                this._addParamsToParamsToParse(newEntity);
                return newEntity;
            }
            Object[] arguments = new Object[]{this._workspace};
            NamedObj result = this._createInstance(newClass, arguments);
            result.setName(entityName);
            this._loadIconForClass(className, result);
            return result;
        }
        if (!reference.isClassDefinition()) {
            throw new MissingClassException("Attempt to extend an entity that is not a class: " + reference.getFullName(), reference.getFullName(), this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        List derivedList = null;
        if (container != null) {
            derivedList = container.getDerivedList();
            for (CompositeEntity derived : derivedList) {
                if (derived.getEntity(entityName) == null) continue;
                throw new IllegalActionException((Nameable)container, "Cannot create entity because a subclass or instance contains an entity with the same name: " + derived.getEntity(entityName).getFullName());
            }
        }
        ComponentEntity newEntity = (ComponentEntity)reference.instantiate(container, entityName);
        if (this._topObjectsCreated != null && container == this._originalContext) {
            this._topObjectsCreated.add(newEntity);
        }
        if ((modelURI = (URIAttribute)newEntity.getAttribute("_uri", URIAttribute.class)) != null) {
            modelURI.setContainer(null);
        }
        this._markParametersToParse(newEntity);
        newEntity.setClassName(className);
        for (ComponentEntity propagatedEntity : newEntity.propagateExistence()) {
            URIAttribute propagatedURI = (URIAttribute)propagatedEntity.getAttribute("_uri", URIAttribute.class);
            if (propagatedURI == null) continue;
            propagatedURI.setContainer(null);
        }
        return newEntity;
    }

    private NamedObj _createInstance(Class newClass, Object[] arguments) throws Exception {
        Constructor<?>[] constructors = newClass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == arguments.length) {
                boolean match = true;
                int j = 0;
                while (j < parameterTypes.length) {
                    if (!parameterTypes[j].isInstance(arguments[j])) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    NamedObj newEntity = (NamedObj)constructor.newInstance(arguments);
                    this._markContentsDerived(newEntity, 0);
                    if (this._topObjectsCreated != null && arguments[0] == this._originalContext) {
                        this._topObjectsCreated.add(newEntity);
                    }
                    return newEntity;
                }
            }
            ++i;
        }
        StringBuffer argumentBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < arguments.length) {
            argumentBuffer.append(arguments[i2].getClass() + " = \"" + arguments[i2].toString() + "\"");
            if (i2 < arguments.length - 1) {
                argumentBuffer.append(", ");
            }
            ++i2;
        }
        throw new XmlException("Cannot find a suitable constructor (" + arguments.length + " args) (" + argumentBuffer + ") for '" + newClass.getName() + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
    }

    private NamedObj _deleteEntity(String entityName) throws Exception {
        ComponentEntity toDelete = this._searchForEntity(entityName, this._current);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This entity is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (ComponentEntity derived : reverse) {
                String toUndo = this._getUndoForDeleteEntity(derived);
                derived.setContainer(null);
                undoMoML.insert(0, toUndo);
            }
            String toUndo = this._getUndoForDeleteEntity(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Port _deletePort(String portName, String entityName) throws Exception {
        Port toDelete = null;
        Entity portContainer = null;
        if (entityName == null) {
            toDelete = this._searchForPort(portName);
            if (toDelete != null) {
                portContainer = (Entity)toDelete.getContainer();
            }
        } else {
            portContainer = this._searchForEntity(entityName, this._current);
            if (portContainer != null) {
                toDelete = portContainer.getPort(portName);
            }
        }
        if (toDelete == null) {
            return null;
        }
        if (portContainer == null) {
            throw new XmlException("No container for the port: " + portName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This port is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (Port derived : reverse) {
                String toUndo = this._getUndoForDeletePort(derived);
                derived.setContainer(null);
                undoMoML.insert(0, toUndo);
            }
            String toUndo = this._getUndoForDeletePort(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Attribute _deleteProperty(String attributeName) throws Exception {
        Attribute toDelete = this._searchForAttribute(attributeName);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This attribute is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            String toUndo = this._getUndoForDeleteAttribute(toDelete);
            toDelete.setContainer(null);
            undoMoML.append(toUndo);
            while (derivedObjects.hasNext()) {
                Attribute derived = (Attribute)derivedObjects.next();
                toUndo = this._getUndoForDeleteAttribute(derived);
                derived.setContainer(null);
                undoMoML.append(toUndo);
            }
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Relation _deleteRelation(String relationName) throws Exception {
        ComponentRelation toDelete = this._searchForRelation(relationName);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This relation is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (ComponentRelation derived : reverse) {
                derived.setContainer(null);
            }
            String toUndo = this._getUndoForDeleteRelation(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private NamedObj _findOrParse(MoMLParser parser, URL base, String file, String className, String source) throws Exception {
        URL previousXmlFile = parser._xmlFile;
        boolean modified = MoMLParser.isModified();
        parser._xmlFile = this.fileNameToURL(file, base);
        try {
            NamedObj toplevel = parser.parse(parser._xmlFile, parser._xmlFile);
            toplevel.setSource(source);
            if (_imports == null) {
                _imports = new HashMap();
            }
            _imports.put(parser._xmlFile, new WeakReference<NamedObj>(toplevel));
            NamedObj namedObj = toplevel;
            return namedObj;
        }
        catch (CancelException cancelException) {
            return null;
        }
        finally {
            parser._xmlFile = previousXmlFile;
            MoMLParser.setModified(modified);
        }
    }

    private int _getColumnNumber() {
        if (this._xmlParser == null) {
            return -1;
        }
        return this._xmlParser.getColumnNumber();
    }

    private String _getCurrentElement(String elementName) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(elementName);
        for (String name : this._attributeNameList) {
            String value = (String)this._attributes.get(name);
            if (value == null) continue;
            result.append(" ");
            result.append(name);
            result.append("=\"");
            result.append(StringUtilities.escapeForXML(value));
            result.append("\"");
        }
        result.append(">");
        return result.toString();
    }

    private int _getLineNumber() {
        if (this._xmlParser == null) {
            return -1;
        }
        return this._xmlParser.getLineNumber();
    }

    private ComponentPort _getPort(String portspec, CompositeEntity context) throws XmlException {
        ComponentPort port = (ComponentPort)context.getPort(portspec);
        this._checkForNull(port, "No port named \"" + portspec + "\" in " + context.getFullName());
        return port;
    }

    private String _getUndoForDeleteAttribute(Attribute toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private String _getUndoForDeleteEntity(ComponentEntity toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (depth < 0) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        CompositeEntity container = (CompositeEntity)toDelete.getContainer();
        if (container instanceof HandlesInternalLinks) {
            return moml.toString();
        }
        HashSet<NamedObj> filter = new HashSet<NamedObj>();
        if (toDelete.getDerivedLevel() == Integer.MAX_VALUE) {
            filter.addAll(toDelete.linkedRelationList());
        } else {
            for (Relation relation : toDelete.linkedRelationList()) {
                if (relation == null || relation.getDerivedLevel() != Integer.MAX_VALUE) continue;
                filter.add(relation);
            }
        }
        filter.add(toDelete);
        moml.append(container.exportLinks(0, filter));
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private String _getUndoForDeletePort(Port toDelete) throws IOException {
        NamedObj containerContainer;
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        NamedObj container = toDelete.getContainer();
        HashSet<Port> filter = new HashSet<Port>();
        filter.addAll(toDelete.linkedRelationList());
        if (container != null && !(container instanceof HandlesInternalLinks) && toDelete instanceof ComponentPort) {
            filter.addAll(((ComponentPort)toDelete).insideRelationList());
        }
        filter.add(toDelete);
        if (container instanceof CompositeEntity) {
            moml.append(((CompositeEntity)container).exportLinks(depth, filter));
        }
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        if (container != null && (containerContainer = container.getContainer()) instanceof CompositeEntity && !(containerContainer instanceof HandlesInternalLinks)) {
            moml.append(UndoContext.moveContextStart(this._current, container));
            if (depth == 0) {
                depth = 1;
            }
            moml.append(((CompositeEntity)containerContainer).exportLinks(depth - 1, filter));
            moml.append(UndoContext.moveContextEnd(this._current, container));
        }
        return moml.toString();
    }

    private String _getUndoForDeleteRelation(ComponentRelation toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        CompositeEntity container = (CompositeEntity)toDelete.getContainer();
        if (container instanceof HandlesInternalLinks) {
            return moml.toString();
        }
        HashSet<Relation> filter = new HashSet<Relation>();
        if (toDelete.getDerivedLevel() == Integer.MAX_VALUE) {
            filter.addAll(toDelete.linkedObjectsList());
        } else {
            for (Relation portOrRelation : toDelete.linkedObjectsList()) {
                if (portOrRelation == null || portOrRelation.getDerivedLevel() != Integer.MAX_VALUE) continue;
                filter.add(portOrRelation);
            }
        }
        filter.add(toDelete);
        moml.append(container.exportLinks(0, filter));
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private void _handlePropertyElement(String className, String propertyName, String value) throws Exception {
        boolean isIOPort = this._current instanceof IOPort;
        if (propertyName.equals("multiport") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isMultiport();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isMultiport() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is a multiport. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setMultiport(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setMultiport(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else if (propertyName.equals("output") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isOutput();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isOutput() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is an output. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setOutput(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setOutput(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else if (propertyName.equals("input") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isInput();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isInput() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is an input. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setInput(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setInput(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else {
            Settable settable;
            NamedObj property = null;
            if (this._current != null) {
                property = this._current.getAttribute(propertyName);
            }
            Class<Object> newClass = null;
            if (className != null) {
                try {
                    newClass = Class.forName(className, true, this._classLoader);
                }
                catch (NoClassDefFoundError ex) {
                    throw new XmlException("Failed to find class '" + className + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex);
                }
                catch (SecurityException ex) {
                    throw new XmlException("Failed to find class '" + className + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex);
                }
            }
            boolean previouslyExisted = property != null;
            boolean createdNew = false;
            String oldClassName = null;
            String oldValue = null;
            if (previouslyExisted) {
                oldClassName = property.getClass().getName();
                if (property instanceof Settable) {
                    settable = (Settable)((Object)property);
                    oldValue = settable.getExpression();
                }
            }
            if (!previouslyExisted || newClass != null && !newClass.isInstance(property)) {
                try {
                    if (newClass == null) {
                        newClass = Attribute.class;
                    }
                    if (this._current == null) {
                        Object[] arguments = new Object[]{this._workspace, propertyName};
                        this._toplevel = property = this._createInstance(newClass, arguments);
                    } else {
                        List derivedList = this._current.getDerivedList();
                        for (NamedObj derived : derivedList) {
                            Attribute other = derived.getAttribute(propertyName);
                            if (other == null || other instanceof Singleton) continue;
                            throw new IllegalActionException((Nameable)this._current, "Cannot create attribute because a subclass or instance contains an attribute with the same name: " + derived.getAttribute(propertyName).getFullName());
                        }
                        Object[] arguments = new Object[]{this._current, propertyName};
                        property = this._createInstance(newClass, arguments);
                        if (property instanceof Director) {
                            this._loadIconForClass(className, property);
                        }
                        if (!(property instanceof Attribute)) {
                            if (property instanceof ComponentEntity) {
                                ((ComponentEntity)property).setContainer(null);
                            } else if (property instanceof Port) {
                                ((Port)property).setContainer(null);
                            } else if (property instanceof ComponentRelation) {
                                ((ComponentRelation)property).setContainer(null);
                            }
                            throw new XmlException("Property is not an instance of Attribute. ", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        property.propagateExistence();
                    }
                    if (value != null) {
                        if (property == null) {
                            throw new XmlException("Property does not exist: " + propertyName + "\n", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        if (!(property instanceof Settable)) {
                            throw new XmlException("Property cannot be assigned a value: " + property.getFullName() + " (instance of " + property.getClass().toString() + ")\n", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        settable = (Settable)((Object)property);
                        settable.setExpression(value);
                        this._paramsToParse.add(property);
                        property.propagateValue();
                    }
                    createdNew = true;
                }
                catch (NameDuplicationException nameDuplicationException) {}
            }
            if (!createdNew && value != null) {
                if (!(property instanceof Settable)) {
                    throw new XmlException("Property is not an instance of Settable, so can't set the value.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                }
                settable = (Settable)((Object)property);
                settable.setExpression(value);
                property.propagateValue();
                this._paramsToParse.add(property);
            }
            this._pushContext();
            this._current = property;
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                if (!previouslyExisted) {
                    this._undoContext.appendUndoMoML("<deleteProperty name=\"" + propertyName + "\" />\n");
                    this._undoContext.setChildrenUndoable(false);
                    this._undoContext.setUndoable(false);
                    this._undoEnabled = false;
                } else {
                    this._undoContext.appendUndoMoML("<property name=\"" + property.getName() + "\" ");
                    this._undoContext.appendUndoMoML("class=\"" + oldClassName + "\" ");
                    if (oldValue != null) {
                        this._undoContext.appendUndoMoML("value=\"" + StringUtilities.escapeForXML(oldValue) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(">\n");
                    this._undoContext.appendClosingUndoMoML("</property>\n");
                    this._undoContext.setChildrenUndoable(true);
                }
            }
        }
    }

    private boolean _isLinkInClass(NamedObj context, Port port, Relation relation) {
        boolean portIsInClass;
        boolean bl = port.getContainer() == context ? port.getDerivedLevel() < Integer.MAX_VALUE : (portIsInClass = port.getContainer().getDerivedLevel() < Integer.MAX_VALUE);
        return portIsInClass && (relation == null || relation.getDerivedLevel() < Integer.MAX_VALUE);
    }

    private boolean _isLinkInClass(NamedObj context, Relation relation1, Relation relation2) {
        return relation1.getDerivedLevel() < Integer.MAX_VALUE && relation2.getDerivedLevel() < Integer.MAX_VALUE;
    }

    private boolean _isUndoableElement(String elementName) {
        return elementName.equals("property") || elementName.equals("class") || elementName.equals("doc") || elementName.equals("deleteEntity") || elementName.equals("deletePort") || elementName.equals("deleteProperty") || elementName.equals("deleteRelation") || elementName.equals("display") || elementName.equals("entity") || elementName.equals("group") || elementName.equals("link") || elementName.equals("port") || elementName.equals("relation") || elementName.equals("rename") || elementName.equals("unlink") || elementName.equals("vertex");
    }

    private boolean _loadFileInContext(String fileName, NamedObj context) throws Exception {
        URL xmlFile = this._classLoader.getResource(fileName);
        if (xmlFile == null) {
            return false;
        }
        InputStream input = xmlFile.openStream();
        boolean modified = MoMLParser.isModified();
        MoMLParser newParser = new MoMLParser(this._workspace, this._classLoader);
        newParser.setContext(context);
        MoMLParser.setModified(modified);
        newParser._topObjectsCreated = new LinkedList();
        newParser.parse(this._base, input);
        for (NamedObj newObject : newParser._topObjectsCreated) {
            newObject.setDerivedLevel(1);
            this._markContentsDerived(newObject, 1);
        }
        return true;
    }

    private boolean _loadIconForClass(String className, NamedObj context) throws Exception {
        if (_iconLoader != null) {
            return _iconLoader.loadIconForClass(className, context);
        }
        String fileName = String.valueOf(className.replace('.', '/')) + "Icon.xml";
        return this._loadFileInContext(fileName, context);
    }

    private void _markContentsDerived(NamedObj object, int depth) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            containedObject.setDerivedLevel(depth + 1);
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._markContentsDerived(containedObject, depth + 1);
        }
    }

    private void _markParametersToParse(NamedObj object) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._markParametersToParse(containedObject);
        }
    }

    private NamedObj _parse(MoMLParser parser, URL base, String source) throws Exception {
        this._xmlFile = this.fileNameToURL(source, base);
        InputStream input = null;
        try {
            input = this._xmlFile.openStream();
            try {
                NamedObj toplevel = parser.parse(this._xmlFile, input);
                input.close();
                NamedObj namedObj = toplevel;
                return namedObj;
            }
            catch (CancelException cancelException) {
                block13: {
                    if (input == null) break block13;
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + this._xmlFile);
                        throwable.printStackTrace();
                    }
                }
                this._xmlFile = null;
                return null;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {
                    System.out.println("Ignoring failure to close stream on " + this._xmlFile);
                    throwable.printStackTrace();
                }
            }
            this._xmlFile = null;
        }
    }

    private void _processLink(String relation1Name, String relation2Name) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"link\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        if (relation1Name == null || relation2Name == null) {
            throw new XmlException("Element link requires two relations.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentRelation relation1 = context.getRelation(relation1Name);
        this._checkForNull(relation1, "No relation named \"" + relation1Name + "\" in " + context.getFullName());
        ComponentRelation relation2 = context.getRelation(relation2Name);
        this._checkForNull(relation2, "No relation named \"" + relation2Name + "\" in " + context.getFullName());
        if (this._isLinkInClass((NamedObj)context, relation1, (Relation)relation2)) {
            throw new IllegalActionException((Nameable)relation1, relation2, "Cannot link relations when both are part of the class definition.");
        }
        relation1.link(relation2);
        for (ComponentRelation derivedRelation1 : relation1.getDerivedList()) {
            CompositeEntity derivedContext = (CompositeEntity)derivedRelation1.getContainer();
            ComponentRelation derivedRelation2 = derivedContext.getRelation(relation2Name);
            derivedRelation1.link(derivedRelation2);
        }
        if (this._undoEnabled && (relation1.getDerivedLevel() == Integer.MAX_VALUE || relation2.getDerivedLevel() == Integer.MAX_VALUE)) {
            this._undoContext.appendUndoMoML("<group><unlink relation1=\"" + relation1Name + "\" relation2=\"" + relation2Name + "\" /></group>\n");
        }
    }

    private void _processLink(String portName, String relationName, String insertAtSpec, String insertInsideAtSpec) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"link\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        int countArgs = 0;
        if (insertAtSpec != null) {
            ++countArgs;
        }
        if (insertInsideAtSpec != null) {
            ++countArgs;
        }
        if (relationName != null) {
            ++countArgs;
        }
        if (countArgs == 0) {
            throw new XmlException("Element link requires at least one of an insertAt, an insertInsideAt, or a relation.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (insertAtSpec != null && insertInsideAtSpec != null) {
            throw new XmlException("Element link requires at most one of insertAt and insertInsideAt, not both.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentPort port = this._getPort(portName, context);
        int origNumOutsideLinks = port.numLinks();
        int origNumInsideLinks = port.numInsideLinks();
        ComponentRelation relation = null;
        if (relationName != null) {
            ComponentRelation tmpRelation = context.getRelation(relationName);
            this._checkForNull(tmpRelation, "No relation named \"" + relationName + "\" in " + context.getFullName());
            relation = tmpRelation;
        }
        if (this._isLinkInClass((NamedObj)context, port, relation)) {
            throw new IllegalActionException((Nameable)port, "Cannot link a port to a relation when both are part of the class definition.");
        }
        int insertAt = -1;
        if (insertAtSpec != null) {
            insertAt = Integer.parseInt(insertAtSpec);
        }
        int insertInsideAt = -1;
        if (insertInsideAtSpec != null) {
            insertInsideAt = Integer.parseInt(insertInsideAtSpec);
        }
        if (insertAtSpec != null) {
            port.insertLink(insertAt, relation);
        } else if (insertInsideAtSpec != null) {
            port.insertInsideLink(insertInsideAt, relation);
        } else {
            port.link(relation);
        }
        if (relation != null) {
            for (ComponentRelation derivedRelation : relation.getDerivedList()) {
                CompositeEntity derivedContext = (CompositeEntity)derivedRelation.getContainer();
                ComponentPort derivedPort = this._getPort(portName, derivedContext);
                if (insertAtSpec != null) {
                    derivedPort.insertLink(insertAt, derivedRelation);
                    continue;
                }
                if (insertInsideAtSpec != null) {
                    derivedPort.insertInsideLink(insertInsideAt, derivedRelation);
                    continue;
                }
                derivedPort.link(derivedRelation);
            }
        } else {
            for (ComponentPort derivedPort : port.getDerivedList()) {
                if (insertAtSpec != null) {
                    derivedPort.insertLink(insertAt, null);
                    continue;
                }
                if (insertInsideAtSpec != null) {
                    derivedPort.insertInsideLink(insertInsideAt, null);
                    continue;
                }
                derivedPort.link(null);
            }
        }
        if (this._undoEnabled) {
            if (relation == null) {
                if (port.getDerivedLevel() == Integer.MAX_VALUE) {
                    if (insertAt != -1) {
                        if (port.numLinks() != origNumOutsideLinks) {
                            this._undoContext.appendUndoMoML("<group><unlink port=\"" + portName + "\" index=\"" + insertAtSpec + "\" /></group>\n");
                        }
                    } else if (port.numInsideLinks() != origNumInsideLinks) {
                        this._undoContext.appendUndoMoML("<group><unlink port=\"" + portName + "\" insideIndex=\"" + insertInsideAtSpec + "\" /></group>\n");
                    }
                }
            } else if (port.getDerivedLevel() == Integer.MAX_VALUE || relation.getDerivedLevel() == Integer.MAX_VALUE) {
                if (port.numInsideLinks() != origNumInsideLinks) {
                    if (insertInsideAt == -1) {
                        insertInsideAt = port.numInsideLinks() - 1;
                    }
                    this._undoContext.appendClosingUndoMoML("<group><unlink port=\"" + portName + "\" insideIndex=\"" + insertInsideAt + "\" /></group>" + "\n");
                } else if (port.numLinks() != origNumOutsideLinks) {
                    if (insertAt == -1) {
                        insertAt = port.numLinks() - 1;
                    }
                    this._undoContext.appendClosingUndoMoML("<group><unlink port=\"" + portName + "\" index=\"" + insertAt + "\" /></group>" + "\n");
                }
            }
        }
    }

    private void _processPendingRequests() throws Exception {
        int reply;
        if (this._linkRequests != null) {
            for (Object request : this._linkRequests) {
                try {
                    ((LinkRequest)request).execute();
                }
                catch (Exception ex) {
                    if (_handler != null) {
                        reply = _handler.handleError(((LinkRequest)request).toString(), this._current, ex);
                        if (reply == 0 || reply != 1) continue;
                        throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                    throw ex;
                }
            }
        }
        if (this._deleteRequests != null) {
            for (Object request : this._deleteRequests) {
                try {
                    ((DeleteRequest)request).execute();
                }
                catch (Exception ex) {
                    if (_handler != null) {
                        reply = _handler.handleError(request.toString(), this._current, ex);
                        if (reply == 0 || reply != 1) continue;
                        throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                    throw ex;
                }
            }
        }
    }

    private void _processUnlink(String relation1Name, String relation2Name) throws XmlException, IllegalActionException {
        if (relation1Name == null || relation2Name == null) {
            throw new XmlException("Element unlink requires two relations.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentRelation relation1 = context.getRelation(relation1Name);
        this._checkForNull(relation1, "No relation named \"" + relation1Name + "\" in " + context.getFullName());
        ComponentRelation relation2 = context.getRelation(relation2Name);
        this._checkForNull(relation2, "No relation named \"" + relation2Name + "\" in " + context.getFullName());
        if (this._isLinkInClass((NamedObj)context, relation1, (Relation)relation2)) {
            throw new IllegalActionException((Nameable)relation1, relation2, "Cannot unlink relations when both are part of the class definition.");
        }
        relation1.unlink(relation2);
        for (ComponentRelation derivedRelation1 : relation1.getDerivedList()) {
            CompositeEntity derivedContext = (CompositeEntity)derivedRelation1.getContainer();
            ComponentRelation derivedRelation2 = derivedContext.getRelation(relation2Name);
            derivedRelation1.unlink(derivedRelation2);
        }
        if (this._undoEnabled && (relation1.getDerivedLevel() == Integer.MAX_VALUE || relation2.getDerivedLevel() == Integer.MAX_VALUE)) {
            this._undoContext.appendUndoMoML("<link relation1=\"" + relation1Name + "\" relation2=\"" + relation2Name + "\" />\n");
        }
    }

    private void _processUnlink(String portName, String relationName, String indexSpec, String insideIndexSpec) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"unlink\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        int countArgs = 0;
        if (indexSpec != null) {
            ++countArgs;
        }
        if (insideIndexSpec != null) {
            ++countArgs;
        }
        if (relationName != null) {
            ++countArgs;
        }
        if (countArgs != 1) {
            throw new XmlException("Element unlink requires exactly one of an index, an insideIndex, or a relation.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentPort port = this._getPort(portName, context);
        if (relationName != null) {
            ComponentRelation tmpRelation = context.getRelation(relationName);
            this._checkForNull(tmpRelation, "No relation named \"" + relationName + "\" in " + context.getFullName());
            ComponentRelation relation = tmpRelation;
            if (this._isLinkInClass((NamedObj)context, port, (Relation)relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled && (port.getDerivedLevel() == Integer.MAX_VALUE || relation.getDerivedLevel() == Integer.MAX_VALUE)) {
                List linkedRelations = port.linkedRelationList();
                int index = linkedRelations.indexOf(tmpRelation);
                if (index != -1) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertAt=\"" + index + "\" relation=\"" + relationName + "\" />\n");
                } else {
                    List insideLinkedRelations = port.insideRelationList();
                    index = insideLinkedRelations.indexOf(tmpRelation);
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertInsideAt=\"" + index + "\" relation=\"" + relationName + "\" />\n");
                }
            }
            for (ComponentRelation derivedRelation : relation.getDerivedList()) {
                CompositeEntity derivedContext = (CompositeEntity)derivedRelation.getContainer();
                ComponentPort derivedPort = this._getPort(portName, derivedContext);
                derivedPort.unlink(derivedRelation);
            }
            port.unlink(relation);
        } else if (indexSpec != null) {
            int index = Integer.parseInt(indexSpec);
            List relationList = port.linkedRelationList();
            if (relationList.size() <= index) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink index " + indexSpec + ", because there is no such link.");
            }
            Relation relation = (Relation)relationList.get(index);
            if (this._isLinkInClass((NamedObj)context, port, relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled) {
                List linkedRelations = port.linkedRelationList();
                Relation r = (Relation)linkedRelations.get(index);
                if (port.getDerivedLevel() == Integer.MAX_VALUE || r != null && r.getDerivedLevel() == Integer.MAX_VALUE) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertAt=\"" + indexSpec + "\" ");
                    if (r != null) {
                        this._undoContext.appendUndoMoML("relation=\"" + r.getName(context) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(" />\n");
                }
            }
            for (ComponentPort derivedPort : port.getDerivedList()) {
                derivedPort.unlink(index);
            }
            port.unlink(index);
        } else {
            int index = Integer.parseInt(insideIndexSpec);
            List relationList = port.insideRelationList();
            Relation relation = (Relation)relationList.get(index);
            if (this._isLinkInClass((NamedObj)context, port, relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled) {
                List linkedRelations = port.insideRelationList();
                Relation r = (Relation)linkedRelations.get(index);
                if (port.getDerivedLevel() == Integer.MAX_VALUE || r != null && r.getDerivedLevel() == Integer.MAX_VALUE) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertInsideAt=\"" + index + "\" ");
                    if (r != null) {
                        this._undoContext.appendUndoMoML("relation=\"" + r.getName(context) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(" />\n");
                }
            }
            for (ComponentPort derivedPort : port.getDerivedList()) {
                derivedPort.unlinkInside(index);
            }
            port.unlinkInside(index);
        }
    }

    private void _pushContext() {
        this._containers.push(this._current);
        this._namespaces.push(this._namespace);
        this._namespace = _DEFAULT_NAMESPACE;
        this._namespaceTranslations.push(this._namespaceTranslationTable);
        this._namespaceTranslationTable = new HashMap();
        this._namespacesPushed = true;
    }

    private void _resetUndo() {
        this._undoContext = null;
        this._undoContexts = new Stack();
        this._undoEnabled = false;
    }

    private Attribute _searchForAttribute(String name) throws XmlException {
        Attribute result = null;
        String currentName = "(no top level)";
        if (this._current != null) {
            currentName = this._current.getFullName();
        }
        if (this._current != null && name.startsWith(currentName)) {
            int prefix = currentName.length();
            if (name.length() > prefix) {
                name = name.substring(prefix + 1);
            }
        }
        if ((result = this._current.getAttribute(name)) == null) {
            throw new XmlException("No such property: " + name + " in " + currentName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private ComponentEntity _searchForClassInContext(String name, String source) throws Exception {
        ComponentEntity candidate = this._searchForEntity(name, this._current);
        NamedObj context = this._current;
        while (!(candidate != null && candidate.isClassDefinition() || context == null)) {
            if (!((context = context.getContainer()) instanceof CompositeEntity)) continue;
            candidate = ((CompositeEntity)context).getEntity(name);
        }
        if (candidate != null) {
            URL candidateSourceURL;
            URL sourceURL;
            String candidateSource = candidate.getSource();
            if (source == null && candidateSource == null) {
                return candidate;
            }
            if (source != null && candidateSource != null && (sourceURL = this.fileNameToURL(source, this._base)).equals(candidateSourceURL = this.fileNameToURL(candidateSource, this._base))) {
                return candidate;
            }
        }
        return null;
    }

    private ComponentEntity _searchForEntity(String name, NamedObj context) throws XmlException {
        if (name.startsWith(".")) {
            int nextPeriod = name.indexOf(".", 1);
            String topLevelName = nextPeriod < 1 ? name.substring(1) : name.substring(1, nextPeriod);
            if (this._toplevel != null && this._toplevel instanceof ComponentEntity && topLevelName.equals(this._toplevel.getName())) {
                ComponentEntity result;
                if (nextPeriod < 1) {
                    return (ComponentEntity)this._toplevel;
                }
                if (name.length() > nextPeriod + 1 && (result = ((CompositeEntity)this._toplevel).getEntity(name.substring(nextPeriod + 1))) != null) {
                    return result;
                }
            }
            return null;
        }
        if (context instanceof CompositeEntity) {
            ComponentEntity result = ((CompositeEntity)context).getEntity(name);
            return result;
        }
        if (context == null) {
            return this._searchForEntity("." + name, null);
        }
        return null;
    }

    private Port _searchForPort(String name) throws XmlException {
        Port result = null;
        String topLevelName = "(no top level)";
        if (this._toplevel != null) {
            topLevelName = this._toplevel.getFullName();
        }
        if (this._toplevel != null && name.startsWith(topLevelName)) {
            int prefix = topLevelName.length();
            if (name.length() > prefix) {
                name = name.substring(1, name.length());
            }
        }
        if (this._current instanceof Entity) {
            result = ((Entity)this._current).getPort(name);
        }
        if (result == null) {
            throw new XmlException("No such port: " + name + " in " + topLevelName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private ComponentRelation _searchForRelation(String name) throws XmlException {
        ComponentRelation result = null;
        String topLevelName = "(no top level)";
        if (this._toplevel != null) {
            topLevelName = this._toplevel.getFullName();
        }
        if (this._toplevel != null && name.startsWith(topLevelName)) {
            int prefix = topLevelName.length();
            if (name.length() > prefix) {
                name = name.substring(1, name.length());
            }
        }
        if (this._current instanceof CompositeEntity) {
            result = ((CompositeEntity)this._current).getRelation(name);
        }
        if (result == null) {
            throw new XmlException("No such relation: " + name + " in " + topLevelName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private class DeleteRequest {
        private int _type;
        private String _name;
        private String _context;

        public DeleteRequest(int type, String name, String context) {
            this._type = type;
            this._name = name;
            this._context = context;
        }

        public NamedObj execute() throws Exception {
            if (this._type == _DELETE_ENTITY) {
                return MoMLParser.this._deleteEntity(this._name);
            }
            if (this._type == _DELETE_PORT) {
                return MoMLParser.this._deletePort(this._name, this._context);
            }
            if (this._type == _DELETE_PROPERTY) {
                return MoMLParser.this._deleteProperty(this._name);
            }
            return MoMLParser.this._deleteRelation(this._name);
        }
    }

    private class LinkRequest {
        protected String _portName;
        protected String _relationName;
        protected String _relation2Name;
        protected String _indexSpec;
        protected String _insideIndexSpec;

        public LinkRequest(String relation1Name, String relation2Name) {
            this._relationName = relation1Name;
            this._relation2Name = relation2Name;
        }

        public LinkRequest(String portName, String relationName, String insertAtSpec, String insertInsideAtSpec) {
            this._portName = portName;
            this._relationName = relationName;
            this._indexSpec = insertAtSpec;
            this._insideIndexSpec = insertInsideAtSpec;
        }

        public void execute() throws IllegalActionException, XmlException {
            if (this._portName != null) {
                MoMLParser.this._processLink(this._portName, this._relationName, this._indexSpec, this._insideIndexSpec);
            } else {
                MoMLParser.this._processLink(this._relationName, this._relation2Name);
            }
        }

        public String toString() {
            if (this._portName != null) {
                return "link " + this._portName + " to " + this._relationName;
            }
            return "link " + this._relationName + " to " + this._relation2Name;
        }
    }

    private class UnlinkRequest
    extends LinkRequest {
        public UnlinkRequest(String portName, String relationName, String indexSpec, String insideIndexSpec) {
            super(portName, relationName, indexSpec, insideIndexSpec);
        }

        public UnlinkRequest(String relation1Name, String relation2Name) {
            super(relation1Name, relation2Name);
        }

        public void execute() throws IllegalActionException, XmlException {
            if (this._portName != null) {
                MoMLParser.this._processUnlink(this._portName, this._relationName, this._indexSpec, this._insideIndexSpec);
            } else {
                MoMLParser.this._processUnlink(this._relationName, this._relation2Name);
            }
        }

        public String toString() {
            return "unlink " + this._portName + " from " + this._relationName;
        }
    }
}

