/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;
import ptolemy.util.MessageHandler;

public class EntityLibrary
extends CompositeEntity
implements Configurable {
    private URL _base;
    private boolean _cloning = false;
    private boolean _configureDone = false;
    private boolean _populating = false;
    private String _configureSource;
    private String _configureText;

    public EntityLibrary() {
        try {
            new Attribute(this, "_libraryMarker");
        }
        catch (KernelException ex) {
            throw new InternalErrorException(null, (Throwable)ex, null);
        }
    }

    public EntityLibrary(Workspace workspace) {
        super(workspace);
        try {
            new Attribute(this, "_libraryMarker");
        }
        catch (KernelException ex) {
            throw new InternalErrorException(ex.toString());
        }
    }

    public EntityLibrary(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        new Attribute(this, "_libraryMarker");
    }

    public List attributeList() {
        this.populate();
        return super.attributeList();
    }

    public List attributeList(Class filter) {
        this.populate();
        return super.attributeList(filter);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        this._cloning = true;
        try {
            EntityLibrary result = (EntityLibrary)super.clone(workspace);
            result._cloning = false;
            EntityLibrary entityLibrary = result;
            return entityLibrary;
        }
        finally {
            this._cloning = false;
        }
    }

    public void configure(URL base, String source, String text) {
        this._base = base;
        this._configureSource = source;
        this._configureText = text;
        this._configureDone = false;
    }

    public List classDefinitionList() {
        this.populate();
        return super.classDefinitionList();
    }

    public boolean deepContains(NamedObj inside) {
        return super.deepContains(inside);
    }

    public List deepEntityList() {
        this.populate();
        return super.deepEntityList();
    }

    public List entityList() {
        this.populate();
        return super.entityList();
    }

    public Attribute getAttribute(String name) {
        this.populate();
        return super.getAttribute(name);
    }

    public ComponentEntity getEntity(String name) {
        this.populate();
        return super.getEntity(name);
    }

    public String getConfigureSource() {
        return this._configureSource;
    }

    public String getConfigureText() {
        try {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<group>\n");
            for (ComponentEntity entity : this.classDefinitionList()) {
                entity.exportMoML(stringWriter, 1);
            }
            for (ComponentEntity entity : this.entityList()) {
                entity.exportMoML(stringWriter, 1);
            }
            stringWriter.write("</group>");
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public int numberOfEntities() {
        this.populate();
        return super.numberOfEntities();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void populate() throws InvalidStateException {
        try {
            if (this._populating) {
                return;
            }
            if (this._cloning) {
                return;
            }
            this._populating = true;
            if (this._configureDone) return;
            this._configureDone = true;
            MoMLParser parser = new MoMLParser(this.workspace());
            parser.setContext(this);
            if (this._configureSource != null && !this._configureSource.equals("")) {
                URL xmlFile = new URL(this._base, this._configureSource);
                parser.parse(xmlFile, xmlFile);
            }
            if (this._configureText == null) return;
            if (this._configureText.equals("")) return;
            String trimmed = this._configureText.trim();
            if (trimmed.startsWith("<?") && trimmed.endsWith("?>")) {
                if (!(trimmed = trimmed.substring(2, trimmed.length() - 2).trim()).startsWith("moml")) return;
                trimmed = trimmed.substring(4).trim();
                parser.parse(this._base, trimmed);
                return;
            }
            parser.parse(this._base, this._configureText);
            return;
        }
        catch (Exception ex) {
            MessageHandler.error("Failed to populate library.", ex);
            throw new InvalidStateException((Nameable)this, (Throwable)ex, "Failed to populate Library");
        }
        finally {
            this._populating = false;
        }
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        output.write(String.valueOf(EntityLibrary._getIndentPrefix(depth)) + "<configure>\n");
        output.write(String.valueOf(EntityLibrary._getIndentPrefix(depth + 1)) + "<group>\n");
        super._exportMoMLContents(output, depth + 2);
        output.write(String.valueOf(EntityLibrary._getIndentPrefix(depth + 1)) + "</group>\n");
        output.write(String.valueOf(EntityLibrary._getIndentPrefix(depth)) + "</configure>\n");
    }
}

