/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Rounding
implements Cloneable,
Serializable {
    public static final RoundCeiling CEILING = new RoundCeiling();
    public static final RoundFloor FLOOR;
    public static final RoundFloor TRUNCATE;
    public static final RoundDown DOWN;
    public static final RoundUp UP;
    public static final RoundHalfDown HALF_DOWN;
    public static final RoundHalfUp HALF_UP;
    public static final RoundHalfEven HALF_EVEN;
    public static final RoundHalfEven CONVERGENT;
    public static final RoundHalfCeiling HALF_CEILING;
    public static final RoundHalfCeiling NEAREST;
    public static final RoundHalfFloor HALF_FLOOR;
    public static final Rounding GENERAL;
    public static final Rounding UNKNOWN;
    public static final Rounding UNNECESSARY;
    private String _name;
    private static Map _nameToRounding;

    static {
        TRUNCATE = FLOOR = new RoundFloor();
        DOWN = new RoundDown();
        UP = new RoundUp();
        HALF_DOWN = new RoundHalfDown();
        HALF_UP = new RoundHalfUp();
        CONVERGENT = HALF_EVEN = new RoundHalfEven();
        NEAREST = HALF_CEILING = new RoundHalfCeiling();
        HALF_FLOOR = new RoundHalfFloor();
        GENERAL = UP;
        UNKNOWN = UP;
        UNNECESSARY = HALF_UP;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public static Rounding forName(String name) {
        return (Rounding)_nameToRounding.get(name);
    }

    public static Rounding getName(String name) throws IllegalArgumentException {
        Rounding rounding = (Rounding)_nameToRounding.get(name);
        if (rounding != null) {
            return rounding;
        }
        throw new IllegalArgumentException("Unknown rounding strategy \"" + name + "\".");
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static Iterator nameIterator() {
        return _nameToRounding.keySet().iterator();
    }

    public abstract BigInteger round(BigDecimal var1);

    public static BigDecimal roundCeiling(BigDecimal decimal) {
        return decimal.setScale(0, 2);
    }

    public static BigDecimal roundDown(BigDecimal decimal) {
        return decimal.setScale(0, 1);
    }

    public static BigDecimal roundFloor(BigDecimal decimal) {
        return decimal.setScale(0, 3);
    }

    public static BigDecimal roundHalfCeiling(BigDecimal decimal) {
        if (decimal.signum() == -1) {
            return Rounding.roundHalfDown(decimal);
        }
        return Rounding.roundHalfUp(decimal);
    }

    public static BigDecimal roundHalfDown(BigDecimal decimal) {
        return decimal.setScale(0, 5);
    }

    public static BigDecimal roundHalfEven(BigDecimal decimal) {
        return decimal.setScale(0, 6);
    }

    public static BigDecimal roundHalfFloor(BigDecimal decimal) {
        if (decimal.signum() == -1) {
            return Rounding.roundHalfUp(decimal);
        }
        return Rounding.roundHalfDown(decimal);
    }

    public static BigDecimal roundHalfUp(BigDecimal decimal) {
        return decimal.setScale(0, 4);
    }

    public static BigDecimal roundUp(BigDecimal decimal) {
        return decimal.setScale(0, 0);
    }

    public String toString() {
        return this._name;
    }

    protected Rounding(String name) {
        this._name = name;
        Rounding._addRounding(this, name);
    }

    static void _addRounding(Rounding type, String name) {
        if (_nameToRounding == null) {
            _nameToRounding = new HashMap();
        }
        _nameToRounding.put(name, type);
    }

    public static class RoundCeiling
    extends Rounding {
        private RoundCeiling() {
            super("ceiling");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundCeiling.roundCeiling(dec).toBigInteger();
        }
    }

    public static class RoundDown
    extends Rounding {
        private RoundDown() {
            super("down");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundDown.roundDown(dec).toBigInteger();
        }
    }

    public static class RoundFloor
    extends Rounding {
        private RoundFloor() {
            super("floor");
            RoundFloor._addRounding(this, "truncate");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundFloor.roundFloor(dec).toBigInteger();
        }
    }

    public static class RoundHalfCeiling
    extends Rounding {
        private RoundHalfCeiling() {
            super("half_ceiling");
            RoundHalfCeiling._addRounding(this, "nearest");
            RoundHalfCeiling._addRounding(this, "round");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundHalfCeiling.roundHalfCeiling(dec).toBigInteger();
        }
    }

    public static class RoundHalfDown
    extends Rounding {
        private RoundHalfDown() {
            super("half_down");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundHalfDown.roundHalfDown(dec).toBigInteger();
        }
    }

    public static class RoundHalfEven
    extends Rounding {
        private RoundHalfEven() {
            super("half_even");
            RoundHalfEven._addRounding(this, "convergent");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundHalfEven.roundHalfEven(dec).toBigInteger();
        }
    }

    public static class RoundHalfFloor
    extends Rounding {
        private RoundHalfFloor() {
            super("half_floor");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundHalfFloor.roundHalfFloor(dec).toBigInteger();
        }
    }

    public static class RoundHalfUp
    extends Rounding {
        private RoundHalfUp() {
            super("half_up");
            RoundHalfUp._addRounding(this, "unnecessary");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundHalfUp.roundHalfUp(dec).toBigInteger();
        }
    }

    public static class RoundUp
    extends Rounding {
        private RoundUp() {
            super("up");
            RoundUp._addRounding(this, "general");
            RoundUp._addRounding(this, "unknown");
        }

        public BigInteger round(BigDecimal dec) {
            return RoundUp.roundUp(dec).toBigInteger();
        }
    }
}

