/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.IntegerBinaryOperation;
import ptolemy.math.IntegerUnaryOperation;

public class IntegerMatrixMath {
    private IntegerMatrixMath() {
    }

    public static final int[][] add(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < IntegerMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] + z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] add(int[][] matrix1, int[][] matrix2) {
        IntegerMatrixMath._checkSameDimension("add", matrix1, matrix2);
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix1)][IntegerMatrixMath._columns(matrix1)];
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < IntegerMatrixMath._columns(matrix1)) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] allocCopy(int[][] matrix) {
        return IntegerMatrixMath.crop(matrix, 0, 0, IntegerMatrixMath._rows(matrix), IntegerMatrixMath._columns(matrix));
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int z, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] applyUnaryOperation(IntegerUnaryOperation op, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseAnd(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] & z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseAnd(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseAnd", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] & matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseComplement(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = ~matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseOr(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] | z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseOr(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseOr", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] | matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseXor(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] ^ z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] bitwiseXor(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseXor", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] ^ matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] crop(int[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        int[][] returnValue = new int[rowSpan][colSpan];
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
            ++i;
        }
        return returnValue;
    }

    public static final int[][] diag(int[] array) {
        int n = array.length;
        int[][] returnValue = new int[n][n];
        int i = 0;
        while (i < n) {
            returnValue[i][i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final int[][] divide(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < IntegerMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] / z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] divideElements(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[] fromMatrixToArray(int[][] matrix) {
        return IntegerMatrixMath.fromMatrixToArray(matrix, IntegerMatrixMath._rows(matrix), IntegerMatrixMath._columns(matrix));
    }

    public static final int[] fromMatrixToArray(int[][] matrix, int maxRow, int maxCol) {
        int[] returnValue = new int[maxRow * maxCol];
        int i = 0;
        while (i < maxRow) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
            ++i;
        }
        return returnValue;
    }

    public static final int[][] identity(int dim) {
        int[][] returnValue = new int[dim][dim];
        int i = 0;
        while (i < dim) {
            returnValue[i][i] = 1;
            ++i;
        }
        return returnValue;
    }

    public static final int[][] identityMatrixInt(int dim) {
        return IntegerMatrixMath.identity(dim);
    }

    public static final void matrixCopy(int[][] srcMatrix, int[][] destMatrix) {
        IntegerMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, IntegerMatrixMath._rows(srcMatrix), IntegerMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(int[][] srcMatrix, int srcRowStart, int srcColStart, int[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
            ++i;
        }
    }

    public static final int[][] modulo(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < IntegerMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] % z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] modulo(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("modulo", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] % matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] multiply(int[][] matrix, int scaleFactor) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[] multiply(int[][] matrix, int[] array) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        int[] returnValue = new int[columns];
        int i = 0;
        while (i < columns) {
            int sum = 0;
            int j = 0;
            while (j < rows) {
                sum += matrix[j][i] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final int[] multiply(int[] array, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        int[] returnValue = new int[rows];
        int i = 0;
        while (i < rows) {
            int sum = 0;
            int j = 0;
            while (j < columns) {
                sum += matrix[i][j] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final int[][] multiply(int[][] matrix1, int[][] matrix2) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix1)][matrix2[0].length];
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < matrix2[0].length) {
                int sum = 0;
                int k = 0;
                while (k < matrix2.length) {
                    sum += matrix1[i][k] * matrix2[k][j];
                    ++k;
                }
                returnValue[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] multiplyElements(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] negative(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = -matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] shiftArithmetic(int[][] matrix, int shiftAmount) {
        int[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = IntegerMatrixMath._rows(matrix);
                columns = IntegerMatrixMath._columns(matrix);
                returnValue = new int[rows][columns];
                if (shiftAmount < 0) break block4;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                        ++j;
                    }
                    ++i;
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    returnValue[i][j] = matrix[i][j] >>> -shiftAmount;
                    ++j;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public static final int[][] shiftLogical(int[][] matrix, int shiftAmount) {
        int[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = IntegerMatrixMath._rows(matrix);
                columns = IntegerMatrixMath._columns(matrix);
                returnValue = new int[rows][columns];
                if (shiftAmount < 0) break block4;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < columns) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                        ++j;
                    }
                    ++i;
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    returnValue[i][j] = matrix[i][j] >> -shiftAmount;
                    ++j;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public static final int[][] subtract(int[][] matrix1, int[][] matrix2) {
        IntegerMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int sum(int[][] matrix) {
        int sum = 0;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                sum += matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] toDoubleMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] toFloatMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] toMatrixFromArray(int[] array, int rows, int cols) {
        int[][] returnValue = new int[rows][cols];
        int i = 0;
        while (i < rows) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
            ++i;
        }
        return returnValue;
    }

    public static final String toString(int[][] matrix) {
        return IntegerMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(int[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        int i = 0;
        while (i < IntegerMatrixMath._rows(matrix)) {
            sb.append(vectorBegin);
            int j = 0;
            while (j < IntegerMatrixMath._columns(matrix)) {
                sb.append(Integer.toString(matrix[i][j]));
                if (j < IntegerMatrixMath._columns(matrix) - 1) {
                    sb.append(elementDelimiter);
                }
                ++j;
            }
            sb.append(vectorEnd);
            if (i < IntegerMatrixMath._rows(matrix) - 1) {
                sb.append(vectorDelimiter);
            }
            ++i;
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final int trace(int[][] matrix) {
        int dim = IntegerMatrixMath._checkSquare("trace", matrix);
        int sum = 0;
        int i = 0;
        while (i < dim) {
            sum += matrix[i][i];
            ++i;
        }
        return sum;
    }

    public static final int[][] transpose(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[columns][rows];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final boolean within(int[][] matrix1, int[][] matrix2, int distance) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("within", matrix1, matrix2);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + distance || matrix1[i][j] < matrix2[i][j] - distance) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(int[][] matrix1, int[][] matrix2, int[][] errorMatrix) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("within", matrix1, matrix2);
        IntegerMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + errorMatrix[i][j] || matrix1[i][j] < matrix2[i][j] - errorMatrix[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        if (rows != IntegerMatrixMath._rows(matrix2) || columns != IntegerMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.IntegerMatrixMath." + caller + "() : one matrix " + IntegerMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + IntegerMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, int[][] matrix) {
        if (IntegerMatrixMath._rows(matrix) != IntegerMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.IntegerMatrixMath." + caller + "() : matrix argument " + IntegerMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return IntegerMatrixMath._rows(matrix);
    }

    protected static final int _columns(int[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(int[][] matrix) {
        return "[" + IntegerMatrixMath._rows(matrix) + " x " + IntegerMatrixMath._columns(matrix) + "]";
    }

    protected static final int _rows(int[][] matrix) {
        return matrix.length;
    }
}

