/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.FloatArrayMath;
import ptolemy.math.FloatBinaryOperation;
import ptolemy.math.FloatUnaryOperation;

public class FloatMatrixMath {
    private FloatMatrixMath() {
    }

    public static final float[][] add(float[][] matrix, float z) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix)][FloatMatrixMath._columns(matrix)];
        int i = 0;
        while (i < FloatMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < FloatMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] + z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] add(float[][] matrix1, float[][] matrix2) {
        FloatMatrixMath._checkSameDimension("add", matrix1, matrix2);
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix1)][FloatMatrixMath._columns(matrix1)];
        int i = 0;
        while (i < FloatMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < FloatMatrixMath._columns(matrix1)) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] allocCopy(float[][] matrix) {
        return FloatMatrixMath.crop(matrix, 0, 0, FloatMatrixMath._rows(matrix), FloatMatrixMath._columns(matrix));
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float z, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float[][] matrix, float z) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] applyBinaryOperation(FloatBinaryOperation op, float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] applyUnaryOperation(FloatUnaryOperation op, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] crop(float[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        float[][] returnValue = new float[rowSpan][colSpan];
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
            ++i;
        }
        return returnValue;
    }

    public static final float determinant(float[][] matrix) {
        FloatMatrixMath._checkSquare("determinant", matrix);
        float det = 1.0f;
        int n = FloatMatrixMath._rows(matrix);
        float[][] a = FloatMatrixMath.allocCopy(matrix);
        int pivot = 0;
        while (pivot < n - 1) {
            float big = Math.abs(a[pivot][pivot]);
            int swapRow = 0;
            int row = pivot + 1;
            while (row < n) {
                float absElement = Math.abs(a[row][pivot]);
                if (absElement > big) {
                    swapRow = row;
                    big = absElement;
                }
                ++row;
            }
            if (swapRow != 0) {
                float[] aPtr = a[pivot];
                a[pivot] = a[swapRow];
                a[swapRow] = aPtr;
                det *= -a[pivot][pivot];
            } else {
                det *= a[pivot][pivot];
            }
            if (Math.abs(det) <= 1.0E-12f) {
                return det;
            }
            float pivotInverse = 1.0f / a[pivot][pivot];
            int col = pivot + 1;
            while (col < n) {
                float[] fArray = a[pivot];
                int n2 = col++;
                fArray[n2] = fArray[n2] * pivotInverse;
            }
            int row2 = pivot + 1;
            while (row2 < n) {
                float temp = a[row2][pivot];
                int col2 = pivot + 1;
                while (col2 < n) {
                    float[] fArray = a[row2];
                    int n3 = col2;
                    fArray[n3] = fArray[n3] - a[pivot][col2] * temp;
                    ++col2;
                }
                ++row2;
            }
            ++pivot;
        }
        return det *= a[n - 1][n - 1];
    }

    public static final float[][] diag(float[] array) {
        int n = array.length;
        float[][] returnValue = new float[n][n];
        int i = 0;
        while (i < n) {
            returnValue[i][i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[][] divide(float[][] matrix, float z) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix)][FloatMatrixMath._columns(matrix)];
        int i = 0;
        while (i < FloatMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < FloatMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] / z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] divideElements(float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[] fromMatrixToArray(float[][] matrix) {
        return FloatMatrixMath.fromMatrixToArray(matrix, FloatMatrixMath._rows(matrix), FloatMatrixMath._columns(matrix));
    }

    public static final float[] fromMatrixToArray(float[][] matrix, int maxRow, int maxCol) {
        float[] returnValue = new float[maxRow * maxCol];
        int i = 0;
        while (i < maxRow) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
            ++i;
        }
        return returnValue;
    }

    public static final float[][] hilbert(int dim) {
        float[][] returnValue = new float[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                returnValue[i][j] = 1.0f / (float)(i + j + 1);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] identity(int dim) {
        float[][] returnValue = new float[dim][dim];
        int i = 0;
        while (i < dim) {
            returnValue[i][i] = 1.0f;
            ++i;
        }
        return returnValue;
    }

    public static final float[][] inverse(float[][] A) {
        FloatMatrixMath._checkSquare("inverse", A);
        int n = FloatMatrixMath._rows(A);
        float[][] Ai = FloatMatrixMath.allocCopy(A);
        int[] pivotFlag = new int[n];
        int[] swapCol = new int[n];
        int[] swapRow = new int[n];
        int irow = 0;
        int icol = 0;
        int i = 0;
        while (i < n) {
            int col;
            float big = 0.0f;
            int row = 0;
            while (row < n) {
                if (pivotFlag[row] == 0) {
                    col = 0;
                    while (col < n) {
                        float absElement;
                        if (pivotFlag[col] == 0 && (absElement = Math.abs(Ai[row][col])) >= big) {
                            big = absElement;
                            irow = row;
                            icol = col;
                        }
                        ++col;
                    }
                }
                ++row;
            }
            int n2 = icol;
            pivotFlag[n2] = pivotFlag[n2] + 1;
            if (irow != icol) {
                int col2 = 0;
                while (col2 < n) {
                    float temp = Ai[irow][col2];
                    Ai[irow][col2] = Ai[icol][col2];
                    Ai[icol][col2] = temp;
                    ++col2;
                }
            }
            swapRow[i] = irow;
            swapCol[i] = icol;
            if (Ai[icol][icol] == 0.0f) {
                return null;
            }
            float pivotInverse = 1.0f / Ai[icol][icol];
            Ai[icol][icol] = 1.0f;
            col = 0;
            while (col < n) {
                float[] fArray = Ai[icol];
                int n3 = col++;
                fArray[n3] = fArray[n3] * pivotInverse;
            }
            int row2 = 0;
            while (row2 < n) {
                if (row2 != icol) {
                    float temp = Ai[row2][icol];
                    Ai[row2][icol] = 0.0f;
                    int col3 = 0;
                    while (col3 < n) {
                        float[] fArray = Ai[row2];
                        int n4 = col3;
                        fArray[n4] = fArray[n4] - Ai[icol][col3] * temp;
                        ++col3;
                    }
                }
                ++row2;
            }
            ++i;
        }
        int swap = n - 1;
        while (swap >= 0) {
            if (swapRow[swap] != swapCol[swap]) {
                int row = 0;
                while (row < n) {
                    float temp = Ai[row][swapRow[swap]];
                    Ai[row][swapRow[swap]] = Ai[row][swapCol[swap]];
                    Ai[row][swapCol[swap]] = temp;
                    ++row;
                }
            }
            --swap;
        }
        return Ai;
    }

    public static final void matrixCopy(float[][] srcMatrix, float[][] destMatrix) {
        FloatMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, FloatMatrixMath._rows(srcMatrix), FloatMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(float[][] srcMatrix, int srcRowStart, int srcColStart, float[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
            ++i;
        }
    }

    public static final float[][] multiply(float[][] matrix, float scaleFactor) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[] multiply(float[][] matrix, float[] array) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        float[] returnValue = new float[columns];
        int i = 0;
        while (i < columns) {
            float sum = 0.0f;
            int j = 0;
            while (j < rows) {
                sum += matrix[j][i] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final float[] multiply(float[] array, float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        float[] returnValue = new float[rows];
        int i = 0;
        while (i < rows) {
            float sum = 0.0f;
            int j = 0;
            while (j < columns) {
                sum += matrix[i][j] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final float[][] multiply(float[][] matrix1, float[][] matrix2) {
        float[][] returnValue = new float[FloatMatrixMath._rows(matrix1)][matrix2[0].length];
        int i = 0;
        while (i < FloatMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < matrix2[0].length) {
                float sum = 0.0f;
                int k = 0;
                while (k < matrix2.length) {
                    sum += matrix1[i][k] * matrix2[k][j];
                    ++k;
                }
                returnValue[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] multiplyElements(float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] negative(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = -matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] orthogonalizeColumns(float[][] matrix) {
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(FloatMatrixMath.transpose(matrix));
        return FloatMatrixMath.transpose((float[][])orthoInfo[0]);
    }

    public static final float[][] orthogonalizeRows(float[][] matrix) {
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(matrix);
        return (float[][])orthoInfo[0];
    }

    public static final float[][] orthonormalizeColumns(float[][] matrix) {
        return FloatMatrixMath.transpose(FloatMatrixMath.orthogonalizeRows(FloatMatrixMath.transpose(matrix)));
    }

    public static final float[][] orthonormalizeRows(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        Object[] orthoInfo = FloatMatrixMath._orthogonalizeRows(matrix);
        float[][] orthogonalMatrix = (float[][])orthoInfo[0];
        float[] oneOverNormSquaredArray = (float[])orthoInfo[2];
        int i = 0;
        while (i < rows) {
            orthogonalMatrix[i] = FloatArrayMath.scale(orthogonalMatrix[i], (float)Math.sqrt(oneOverNormSquaredArray[i]));
            ++i;
        }
        return orthogonalMatrix;
    }

    public static final float[][][] qr(float[][] matrix) {
        int columns = FloatMatrixMath._columns(matrix);
        Object[] orthoRowInfo = FloatMatrixMath._orthogonalizeRows(FloatMatrixMath.transpose(matrix));
        float[][] qT = (float[][])orthoRowInfo[0];
        float[][] dotProducts = (float[][])orthoRowInfo[1];
        float[] oneOverNormSquaredArray = (float[])orthoRowInfo[2];
        Integer nullity = (Integer)orthoRowInfo[3];
        if (nullity > 0) {
            throw new IllegalArgumentException("qr() : not all column vectors are linearly independent.");
        }
        int i = 0;
        while (i < columns) {
            float oneOverNorm = (float)Math.sqrt(oneOverNormSquaredArray[i]);
            qT[i] = FloatArrayMath.scale(qT[i], oneOverNorm);
            int j = i;
            while (j < columns) {
                float[] fArray = dotProducts[i];
                int n = j++;
                fArray[n] = fArray[n] * oneOverNorm;
            }
            ++i;
        }
        return new float[][][]{FloatMatrixMath.transpose(qT), dotProducts};
    }

    public static final float[][] subtract(float[][] matrix1, float[][] matrix2) {
        FloatMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float sum(float[][] matrix) {
        float sum = 0.0f;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                sum += matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] toDoubleMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] toIntegerMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = (int)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = (long)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] toMatrixFromArray(float[] array, int rows, int cols) {
        float[][] returnValue = new float[rows][cols];
        int i = 0;
        while (i < rows) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
            ++i;
        }
        return returnValue;
    }

    public static final String toString(float[][] matrix) {
        return FloatMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(float[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        int i = 0;
        while (i < FloatMatrixMath._rows(matrix)) {
            sb.append(vectorBegin);
            int j = 0;
            while (j < FloatMatrixMath._columns(matrix)) {
                sb.append(Float.toString(matrix[i][j]));
                if (j < FloatMatrixMath._columns(matrix) - 1) {
                    sb.append(elementDelimiter);
                }
                ++j;
            }
            sb.append(vectorEnd);
            if (i < FloatMatrixMath._rows(matrix) - 1) {
                sb.append(vectorDelimiter);
            }
            ++i;
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final float trace(float[][] matrix) {
        int dim = FloatMatrixMath._checkSquare("trace", matrix);
        float sum = 0.0f;
        int i = 0;
        while (i < dim) {
            sum += matrix[i][i];
            ++i;
        }
        return sum;
    }

    public static final float[][] transpose(float[][] matrix) {
        int rows = FloatMatrixMath._rows(matrix);
        int columns = FloatMatrixMath._columns(matrix);
        float[][] returnValue = new float[columns][rows];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final boolean within(float[][] matrix1, float[][] matrix2, float distance) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("within", matrix1, matrix2);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + distance || matrix1[i][j] < matrix2[i][j] - distance) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(float[][] matrix1, float[][] matrix2, float[][] errorMatrix) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        FloatMatrixMath._checkSameDimension("within", matrix1, matrix2);
        FloatMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + errorMatrix[i][j] || matrix1[i][j] < matrix2[i][j] - errorMatrix[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, float[][] matrix1, float[][] matrix2) {
        int rows = FloatMatrixMath._rows(matrix1);
        int columns = FloatMatrixMath._columns(matrix1);
        if (rows != FloatMatrixMath._rows(matrix2) || columns != FloatMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.FloatMatrixMath." + caller + "() : one matrix " + FloatMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + FloatMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, float[][] matrix) {
        if (FloatMatrixMath._rows(matrix) != FloatMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.FloatMatrixMath." + caller + "() : matrix argument " + FloatMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return FloatMatrixMath._rows(matrix);
    }

    protected static final int _columns(float[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(float[][] matrix) {
        return "[" + FloatMatrixMath._rows(matrix) + " x " + FloatMatrixMath._columns(matrix) + "]";
    }

    protected static final Object[] _orthogonalizeRows(float[][] rowArrays) {
        int rows = rowArrays.length;
        int columns = rowArrays[0].length;
        int nullity = 0;
        float[][] orthogonalMatrix = new float[rows][];
        float[] oneOverNormSquaredArray = new float[rows];
        float[][] dotProductMatrix = new float[rows][rows];
        int i = 0;
        while (i < rows) {
            float[] refArray;
            float[] rowArray = refArray = rowArrays[i];
            int j = 0;
            while (j < i) {
                float dotProduct;
                dotProductMatrix[j][i] = dotProduct = FloatArrayMath.dotProduct(refArray, orthogonalMatrix[j]);
                rowArray = FloatArrayMath.subtract(rowArray, FloatArrayMath.scale(orthogonalMatrix[j], dotProduct * oneOverNormSquaredArray[j]));
                ++j;
            }
            dotProductMatrix[i][i] = FloatArrayMath.dotProduct(refArray, rowArray);
            float normSquared = FloatArrayMath.sumOfSquares(rowArray);
            if (normSquared == 0.0f) {
                orthogonalMatrix[i] = i == 0 ? new float[columns] : rowArray;
                oneOverNormSquaredArray[i] = 0.0f;
                ++nullity;
            } else {
                orthogonalMatrix[i] = rowArray;
                oneOverNormSquaredArray[i] = 1.0f / normSquared;
            }
            ++i;
        }
        return new Object[]{orthogonalMatrix, dotProductMatrix, oneOverNormSquaredArray, nullity};
    }

    protected static final int _rows(float[][] matrix) {
        return matrix.length;
    }
}

