/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import ptolemy.graph.Edge;
import ptolemy.graph.Element;
import ptolemy.graph.Graph;
import ptolemy.graph.GraphException;
import ptolemy.graph.Node;

public class GraphElementException
extends GraphException {
    public GraphElementException(String message) {
        super(message);
    }

    public GraphElementException(Element element, Graph graph, String message) {
        super(GraphElementException._argumentsToString(element, graph, message));
    }

    public static void checkNode(Node node, Graph graph) {
        if (!graph.containsNode(node)) {
            throw new GraphElementException("Reference to a node that is not in the graph.\n" + GraphElementException.elementDump(node, graph));
        }
    }

    public static void checkEdge(Edge edge, Graph graph) {
        if (!graph.containsEdge(edge)) {
            throw new GraphElementException("Reference to an edge that is not in the graph.\n" + GraphElementException.elementDump(edge, graph));
        }
    }

    private static String _argumentsToString(Element element, Graph graph, String message) {
        return String.valueOf(message) + GraphElementException.elementDump(element, graph);
    }
}

