/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import ptolemy.data.unit.ParseException;
import ptolemy.data.unit.UnitConstraints;
import ptolemy.data.unit.UnitEquation;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.kernel.util.AbstractSettableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.util.StringUtilities;

public class UnitAttribute
extends AbstractSettableAttribute {
    Settable.Visibility _visibility = Settable.NONE;
    private List _valueListeners;
    private UnitExpr _unitExpr = null;
    private UnitConstraints _unitConstraints = null;
    private int _type = -1;
    private static final int _EXPRESSION = 0;
    private static final int _CONSTRAINTS = 1;

    public UnitAttribute() throws IllegalActionException, NameDuplicationException {
    }

    public UnitAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void addValueListener(ValueListener listener) {
        if (this._valueListeners == null) {
            this._valueListeners = new LinkedList();
        }
        if (!this._valueListeners.contains(listener)) {
            this._valueListeners.add(listener);
        }
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        String value = this.getExpression();
        String valueTerm = "";
        if (value != null && !value.equals("")) {
            valueTerm = " value=\"" + StringUtilities.escapeForXML(value) + "\"";
            output.write(String.valueOf(UnitAttribute._getIndentPrefix(depth)) + "<" + this._elementName + " name=\"" + name + "\" class=\"" + this.getClassName() + "\"" + valueTerm + ">\n");
            this._exportMoMLContents(output, depth + 1);
            output.write(String.valueOf(UnitAttribute._getIndentPrefix(depth)) + "</" + this._elementName + ">\n");
        }
    }

    public String getExpression() {
        switch (this._type) {
            case 0: {
                if (this._unitExpr == null) {
                    return "";
                }
                return this._unitExpr.descriptiveForm();
            }
            case 1: {
                if (this._unitConstraints == null) {
                    return "";
                }
                return this.getUnitConstraints().descriptiveForm();
            }
        }
        return null;
    }

    public UnitConstraints getUnitConstraints() {
        return this._unitConstraints;
    }

    public UnitExpr getUnitExpr() {
        return this._unitExpr;
    }

    public Settable.Visibility getVisibility() {
        return this._visibility;
    }

    public void removeValueListener(ValueListener listener) {
        if (this._valueListeners != null) {
            this._valueListeners.remove(listener);
        }
    }

    public void setExpression(String expression) throws IllegalActionException {
        super.setExpression(expression);
        try {
            if (this.getName().equals("_unitConstraints")) {
                Vector uEquations = UnitLibrary.getParser().parseEquations(expression);
                UnitConstraints uConstraints = new UnitConstraints();
                int i = 0;
                while (i < uEquations.size()) {
                    uConstraints.addConstraint((UnitEquation)uEquations.elementAt(i));
                    ++i;
                }
                this.setUnitConstraints(uConstraints);
            }
            if (this.getName().equals("_units")) {
                UnitExpr uExpr = UnitLibrary.getParser().parseUnitExpr(expression);
                this.setUnitExpr(uExpr);
            }
        }
        catch (ParseException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Can't parse the expression " + expression);
        }
    }

    public void setUnitConstraints(UnitConstraints constraints) {
        this._unitConstraints = constraints;
        this._type = 1;
    }

    public void setUnitExpr(UnitExpr expr) {
        this._unitExpr = expr;
        this._type = 0;
    }

    public void setVisibility(Settable.Visibility visibility) {
        this._visibility = visibility;
    }

    public Collection validate() throws IllegalActionException {
        return null;
    }

    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        ((Settable)((Object)destination)).setExpression(this.getExpression());
    }
}

