/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.EventToken;
import ptolemy.data.FixToken;
import ptolemy.data.FloatToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.PetiteToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.ShortToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.XMLToken;
import ptolemy.data.type.FixType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;

public abstract class BaseType
implements Type,
Serializable {
    public static final UnknownType UNKNOWN = new UnknownType();
    public static final ArrayBottomType ARRAY_BOTTOM = new ArrayBottomType();
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final MatrixType.BooleanMatrixType BOOLEAN_MATRIX = new MatrixType.BooleanMatrixType();
    public static final UnsignedByteType UNSIGNED_BYTE = new UnsignedByteType();
    public static final ComplexType COMPLEX = new ComplexType();
    public static final MatrixType.ComplexMatrixType COMPLEX_MATRIX = new MatrixType.ComplexMatrixType();
    public static final FloatType FLOAT = new FloatType();
    public static final DoubleType DOUBLE = new DoubleType();
    public static final MatrixType.DoubleMatrixType DOUBLE_MATRIX = new MatrixType.DoubleMatrixType();
    public static final UnsizedFixType FIX;
    public static final UnsizedFixType UNSIZED_FIX;
    public static final FixType SIZED_FIX;
    public static final MatrixType.FixMatrixType FIX_MATRIX;
    public static final ShortType SHORT;
    public static final IntType INT;
    public static final MatrixType.IntMatrixType INT_MATRIX;
    public static final LongType LONG;
    public static final MatrixType.LongMatrixType LONG_MATRIX;
    public static final ObjectType OBJECT;
    public static final XmlTokenType XMLTOKEN;
    public static final ScalarType SCALAR;
    public static final MatrixType MATRIX;
    public static final StringType STRING;
    public static final GeneralType GENERAL;
    public static final EventType EVENT;
    public static final PetiteType PETITE;
    public static final NilType NIL;
    private Class _tokenClass;
    private String _name;
    private static Map _nameToType;
    private static Map _classNameToType;

    static {
        UNSIZED_FIX = FIX = new UnsizedFixType();
        SIZED_FIX = FixType.BOTTOM;
        FIX_MATRIX = new MatrixType.FixMatrixType();
        SHORT = new ShortType();
        INT = new IntType();
        INT_MATRIX = new MatrixType.IntMatrixType();
        LONG = new LongType();
        LONG_MATRIX = new MatrixType.LongMatrixType();
        OBJECT = new ObjectType();
        XMLTOKEN = new XmlTokenType();
        SCALAR = new ScalarType();
        MATRIX = new MatrixType(MatrixToken.class, SCALAR, "matrix");
        STRING = new StringType();
        GENERAL = new GeneralType();
        EVENT = new EventType();
        PETITE = new PetiteType();
        NIL = new NilType();
    }

    public Type add(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Object clone() {
        return this;
    }

    public abstract Token convert(Token var1) throws IllegalActionException;

    public Type divide(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public static Type forClassName(String className) {
        return (Type)_classNameToType.get(className);
    }

    public static Type forName(String name) {
        return (Type)_nameToType.get(name);
    }

    public Class getTokenClass() {
        return this._tokenClass;
    }

    public int getTypeHash() {
        return Integer.MIN_VALUE;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Type modulo(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Type multiply(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public boolean isAbstract() {
        if (!this.isInstantiable()) {
            return true;
        }
        int mod = this._tokenClass.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return true;
        }
        return this._tokenClass.isInterface();
    }

    public boolean isCompatible(Type type) {
        if (this == UNKNOWN) {
            return true;
        }
        int typeInfo = TypeLattice.compare((Type)this, type);
        return typeInfo == 0 || typeInfo == 1;
    }

    public boolean isConstant() {
        return this != UNKNOWN;
    }

    public boolean isInstantiable() {
        return this != UNKNOWN;
    }

    public boolean isSubstitutionInstance(Type type) {
        return this == UNKNOWN || this == type;
    }

    public Type one() {
        return this;
    }

    public Type subtract(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public String toString() {
        return this._name;
    }

    public Type zero() {
        return this;
    }

    static void _addType(Type type, String name, Class theClass) {
        if (_nameToType == null) {
            _nameToType = new HashMap();
        }
        if (_classNameToType == null) {
            _classNameToType = new HashMap();
        }
        _nameToType.put(name, type);
        _classNameToType.put(theClass.getName(), type);
    }

    private BaseType(Class c, String name) {
        this._tokenClass = c;
        this._name = name;
        BaseType._addType(this, name, c);
    }

    /* synthetic */ BaseType(Class clazz, String string, BaseType baseType) {
        this(clazz, string);
    }

    public static class ArrayBottomType
    extends BaseType {
        private ArrayBottomType() {
            super(Void.TYPE, "arrayBottom", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return t;
        }
    }

    public static class BooleanType
    extends BaseType {
        private BooleanType() {
            super(BooleanToken.class, "boolean", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return BooleanToken.convert(t);
        }

        public int getTypeHash() {
            return 1;
        }
    }

    public static class ComplexType
    extends BaseType {
        private ComplexType() {
            super(ComplexToken.class, "complex", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return ComplexToken.convert(t);
        }

        public int getTypeHash() {
            return 3;
        }
    }

    public static class DoubleType
    extends BaseType {
        private DoubleType() {
            super(DoubleToken.class, "double", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return DoubleToken.convert(t);
        }

        public int getTypeHash() {
            return 4;
        }
    }

    public static class EventType
    extends BaseType {
        private EventType() {
            super(EventToken.class, "event", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return t;
        }

        public int getTypeHash() {
            return 12;
        }
    }

    public static class FloatType
    extends BaseType {
        private FloatType() {
            super(FloatToken.class, "float", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return FloatToken.convert(t);
        }

        public int getTypeHash() {
            return 16;
        }
    }

    public static class GeneralType
    extends BaseType {
        private GeneralType() {
            super(Token.class, "general", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return t;
        }

        public int getTypeHash() {
            return 11;
        }
    }

    public static class IntType
    extends BaseType {
        private IntType() {
            super(IntToken.class, "int", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return IntToken.convert(t);
        }

        public int getTypeHash() {
            return 5;
        }
    }

    public static class LongType
    extends BaseType {
        private LongType() {
            super(LongToken.class, "long", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return LongToken.convert(t);
        }

        public int getTypeHash() {
            return 6;
        }
    }

    public static class NilType
    extends BaseType {
        private NilType() {
            super(Token.class, "niltype", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return t;
        }

        public int getTypeHash() {
            return 14;
        }
    }

    public static class ObjectType
    extends BaseType {
        private ObjectType() {
            super(ObjectToken.class, "Object", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return ObjectToken.convert(t);
        }

        public int getTypeHash() {
            return 8;
        }
    }

    public static class PetiteType
    extends BaseType {
        private PetiteType() {
            super(PetiteToken.class, "petite", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return PetiteToken.convert(t);
        }

        public int getTypeHash() {
            return 13;
        }
    }

    public static class ScalarType
    extends BaseType {
        private ScalarType() {
            super(ScalarToken.class, "scalar", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            if (t instanceof ScalarToken) {
                return t;
            }
            throw new IllegalActionException(Token.notSupportedIncomparableConversionMessage(t, "scalar"));
        }

        public int getTypeHash() {
            return 9;
        }
    }

    public static class ShortType
    extends BaseType {
        private ShortType() {
            super(ShortToken.class, "short", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return ShortToken.convert(t);
        }

        public int getTypeHash() {
            return 15;
        }
    }

    public static class StringType
    extends BaseType {
        private StringType() {
            super(StringToken.class, "string", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return StringToken.convert(t);
        }

        public int getTypeHash() {
            return 10;
        }
    }

    public static class UnknownType
    extends BaseType {
        private UnknownType() {
            super(Void.TYPE, "unknown", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return t;
        }

        public int getTypeHash() {
            return 0;
        }
    }

    public static class UnsignedByteType
    extends BaseType {
        private UnsignedByteType() {
            super(UnsignedByteToken.class, "unsignedByte", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return UnsignedByteToken.convert(t);
        }

        public int getTypeHash() {
            return 2;
        }
    }

    public static class UnsizedFixType
    extends BaseType {
        private UnsizedFixType() {
            super(FixToken.class, "fixedpoint", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            if (t instanceof FixToken) {
                return t;
            }
            throw new IllegalActionException("Cannot convert token " + t + " to type fixed point.");
        }
    }

    public static class XmlTokenType
    extends BaseType {
        private XmlTokenType() {
            super(XMLToken.class, "xmltoken", null);
        }

        public Token convert(Token t) throws IllegalActionException {
            return XMLToken.convert(t);
        }

        public int getTypeHash() {
            return 8;
        }
    }
}

