/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import ptolemy.data.expr.ScopeExtender;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ScopeExtendingAttribute
extends Attribute
implements ScopeExtender {
    public ScopeExtendingAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        NamedObj oldContainer = this.getContainer();
        super.setContainer(container);
        if (oldContainer != container) {
            if (container != null) {
                this._invalidateShadowedSettables(container.getContainer());
            }
            for (Variable var : this.attributeList(Variable.class)) {
                var.validate();
            }
        }
    }

    private void _invalidateShadowedSettables(NamedObj object) throws IllegalActionException {
        if (object == null) {
            return;
        }
        for (Variable variable : object.attributeList(Variable.class)) {
            if (this.getAttribute(variable.getName()) == null) continue;
            variable.invalidate();
        }
        for (ScopeExtendingAttribute attribute : object.attributeList(ScopeExtendingAttribute.class)) {
            for (Variable variable : attribute.attributeList(Variable.class)) {
                if (this.getAttribute(variable.getName()) == null) continue;
                variable.invalidate();
            }
        }
        NamedObj container = object.getContainer();
        if (container != null) {
            this._invalidateShadowedSettables(container);
        }
    }
}

