/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.StringUtilities;

public class Parameter
extends Variable {
    private List _choices;

    public Parameter() {
        this.setVisibility(Settable.FULL);
        this._isPersistent = null;
    }

    public Parameter(Workspace workspace) {
        super(workspace);
        this.setVisibility(Settable.FULL);
        this._isPersistent = null;
    }

    public Parameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setVisibility(Settable.FULL);
        this._isPersistent = null;
    }

    public Parameter(NamedObj container, String name, Token token) throws IllegalActionException, NameDuplicationException {
        super(container, name, token);
        this.setVisibility(Settable.FULL);
        this._isPersistent = null;
    }

    public void addChoice(String choice) {
        if (this._choices == null) {
            this._choices = new ArrayList();
        }
        this._choices.add(choice);
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        String value = this._currentExpression;
        if (value == null) {
            Token token = null;
            try {
                token = this.getToken();
            }
            catch (IllegalActionException illegalActionException) {}
            if (token != null) {
                value = this.isStringMode() ? ((StringToken)token).stringValue() : token.toString();
            }
        }
        String valueTerm = "";
        if (value != null) {
            valueTerm = " value=\"" + StringUtilities.escapeForXML(value) + "\"";
        }
        output.write(String.valueOf(Parameter._getIndentPrefix(depth)) + "<" + this._elementName + " name=\"" + name + "\" class=\"" + this.getClassName() + "\"" + valueTerm + ">\n");
        this._exportMoMLContents(output, depth + 1);
        output.write(String.valueOf(Parameter._getIndentPrefix(depth)) + "</" + this._elementName + ">\n");
    }

    public String[] getChoices() {
        if (this._choices == null || this._choices.size() == 0) {
            return null;
        }
        return this._choices.toArray(new String[this._choices.size()]);
    }

    public void removeAllChoices() {
        this._choices = null;
    }

    public void removeChoice(String choice) {
        if (this._choices != null) {
            this._choices.remove(choice);
        }
    }
}

