/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;

public class LongToken
extends ScalarToken {
    public static final LongToken NIL = new LongToken(Long.MAX_VALUE);
    public static final LongToken ONE = new LongToken(1L);
    public static final LongToken ZERO = new LongToken(0L);
    private long _value;

    public LongToken() {
        this._value = 0L;
    }

    public LongToken(long value) {
        this._value = value;
    }

    public LongToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(LongToken.notSupportedNullNilStringMessage("LongToken", init));
        }
        if ((init = init.trim()).endsWith("L") || init.endsWith("l")) {
            init = init.substring(0, init.length() - 1);
        }
        try {
            this._value = Long.parseLong(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    public static LongToken convert(Token token) throws IllegalActionException {
        if (token instanceof LongToken) {
            return (LongToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.LONG, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(LongToken.notSupportedIncomparableConversionMessage(token, "long"));
        }
        compare = TypeLattice.compare((Type)BaseType.INT, token);
        if (compare == 0 || compare == 1) {
            IntToken intToken = IntToken.convert(token);
            LongToken result = new LongToken(intToken.longValue());
            if (intToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(intToken._unitCategoryExponents)) {
                result._unitCategoryExponents = intToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(LongToken.notSupportedConversionMessage(token, "long"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((LongToken)object).isNil()) {
            return false;
        }
        return ((LongToken)object).longValue() == this._value;
    }

    public Type getType() {
        return BaseType.LONG;
    }

    public int hashCode() {
        return (int)this._value;
    }

    public boolean isNil() {
        return this == NIL;
    }

    public ScalarToken leftShift(int bits) {
        if (this.isNil()) {
            return IntToken.NIL;
        }
        return new LongToken(this._value << bits);
    }

    public ScalarToken logicalRightShift(int bits) {
        if (this.isNil()) {
            return IntToken.NIL;
        }
        return new LongToken(this._value >>> bits);
    }

    public long longValue() {
        return this._value;
    }

    public Token one() {
        return ONE;
    }

    public ScalarToken rightShift(int bits) {
        if (this.isNil()) {
            return IntToken.NIL;
        }
        return new LongToken(this._value >> bits);
    }

    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return String.valueOf(Long.toString(this._value)) + "L" + unitString;
    }

    public UnsignedByteToken truncatedUnsignedByteValue() throws IllegalActionException {
        if (this.isNil()) {
            return UnsignedByteToken.NIL;
        }
        if (this._value < 0L || this._value > 255L) {
            throw new IllegalActionException("Value cannot be represented as an unsigned Byte");
        }
        return new UnsignedByteToken((int)this._value);
    }

    public Token zero() {
        return ZERO;
    }

    protected ScalarToken _absolute() {
        LongToken result = this._value >= 0L ? this : new LongToken(-this._value);
        return result;
    }

    protected ScalarToken _add(ScalarToken rightArgument) {
        long sum = this._value + ((LongToken)rightArgument).longValue();
        return new LongToken(sum);
    }

    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) {
        long sum = this._value & ((LongToken)rightArgument).longValue();
        return new LongToken(sum);
    }

    protected ScalarToken _bitwiseNot() {
        LongToken result = new LongToken(this._value ^ 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) {
        long sum = this._value | ((LongToken)rightArgument).longValue();
        return new LongToken(sum);
    }

    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) {
        long sum = this._value ^ ((LongToken)rightArgument).longValue();
        return new LongToken(sum);
    }

    protected ScalarToken _divide(ScalarToken rightArgument) {
        long quotient = this._value / ((LongToken)rightArgument).longValue();
        return new LongToken(quotient);
    }

    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        long distance;
        long left;
        long right = ((LongToken)rightArgument).longValue();
        if (right > (left = this.longValue()) + (distance = Math.round(Math.floor(epsilon))) || right < left - distance) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        LongToken convertedArgument = (LongToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.longValue());
    }

    protected ScalarToken _modulo(ScalarToken rightArgument) {
        long remainder = this._value % ((LongToken)rightArgument).longValue();
        return new LongToken(remainder);
    }

    protected ScalarToken _multiply(ScalarToken rightArgument) {
        long product = this._value * ((LongToken)rightArgument).longValue();
        return new LongToken(product);
    }

    protected ScalarToken _subtract(ScalarToken rightArgument) {
        long difference = this._value - ((LongToken)rightArgument).longValue();
        return new LongToken(difference);
    }
}

