/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.IntMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.LongArrayMath;
import ptolemy.math.LongMatrixMath;

public class LongMatrixToken
extends MatrixToken {
    private long[] _value;
    private int _rowCount;
    private int _columnCount;

    public LongMatrixToken() {
        this._value = new long[1];
        this._value[0] = 0L;
        this._rowCount = 1;
        this._columnCount = 1;
    }

    public LongMatrixToken(long[] value, int rows, int columns) throws IllegalActionException {
        this(value, rows, columns, 0);
    }

    public LongMatrixToken(long[] value, int rows, int columns, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("LongMatrixToken: The specified matrix is null.");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = copy == 0 ? LongArrayMath.allocCopy(value) : value;
    }

    public LongMatrixToken(long[][] value) throws IllegalActionException {
        this(value, 0);
    }

    public LongMatrixToken(long[][] value, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("LongMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, copy);
    }

    public LongMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof LongMatrixToken)) {
            throw new IllegalActionException("A matrix token cannot be created from the expression '" + init + "'");
        }
        long[][] value = ((LongMatrixToken)token).longMatrix();
        this._initialize(value, 0);
    }

    public LongMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        int elements = rows * columns;
        if (tokens == null) {
            throw new IllegalActionException("LongMatrixToken: The specified array is null.");
        }
        if (tokens.length != elements) {
            throw new IllegalActionException("LongMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new long[elements];
        int i = 0;
        while (i < elements) {
            Token token = tokens[i];
            if (!(token instanceof ScalarToken)) {
                throw new IllegalActionException("LongMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            this._value[i] = ((ScalarToken)token).longValue();
            ++i;
        }
    }

    public static LongMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof LongMatrixToken) {
            return (LongMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.LONG_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(LongMatrixToken.notSupportedIncomparableConversionMessage(token, "[long]"));
        }
        compare = TypeLattice.compare((Type)BaseType.INT_MATRIX, token);
        if (compare == 0 || compare == 1) {
            IntMatrixToken tem = IntMatrixToken.convert(token);
            long[][] result = tem.longMatrix();
            return new LongMatrixToken(result);
        }
        throw new IllegalActionException(LongMatrixToken.notSupportedConversionMessage(token, "[long]"));
    }

    public static Token convert(ScalarToken token, int size) throws IllegalActionException {
        int compare = TypeLattice.compare((Type)BaseType.LONG, (Token)token);
        if (compare == 0 || compare == 1) {
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, "[long]"));
            }
            LongToken longToken = LongToken.convert(token);
            long longValue = longToken.longValue();
            long[] result = new long[size * size];
            int i = 0;
            while (i < size) {
                result[i] = longValue;
                ++i;
            }
            return new LongMatrixToken(result, size, size, 1);
        }
        throw new IllegalActionException(LongMatrixToken.notSupportedConversionMessage(token, "[long]"));
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        long[][] value = this.longMatrix();
        try {
            long[][] result = LongMatrixMath.crop(value, rowStart, colStart, rowSpan, colSpan);
            return new LongMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        LongMatrixToken matrixArgument = (LongMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        long[] value = matrixArgument._value;
        int elements = this._rowCount * this._columnCount;
        int i = 0;
        while (i < elements) {
            if (this._value[i] != value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new LongToken(this._value[row * this._columnCount + column]);
    }

    public long getElementAt(int row, int column) {
        return this._value[row * this._columnCount + column];
    }

    public Type getElementType() {
        return BaseType.LONG;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Type getType() {
        return BaseType.LONG_MATRIX;
    }

    public int hashCode() {
        long code = 0L;
        int elements = this._rowCount * this._columnCount;
        int i = 0;
        while (i < elements) {
            code += this._value[i];
            ++i;
        }
        return (int)code;
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        int i = 0;
        while (i < matrices.length) {
            rows += matrices[i][0].getRowCount();
            ++i;
        }
        int j = 0;
        while (j < matrices[0].length) {
            columns += matrices[0][j].getColumnCount();
            ++j;
        }
        long[][] tiled = new long[rows][columns];
        int row = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            int column = 0;
            int j2 = 0;
            while (j2 < matrices[i2].length) {
                int columnCount;
                if (!(matrices[i2][j2] instanceof LongMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i2][j2].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i2][j2].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                LongMatrixMath.matrixCopy(matrices[i2][j2].longMatrix(), 0, 0, tiled, row, column, rowCount, columnCount);
                column += matrices[0][j2].getColumnCount();
                ++j2;
            }
            row += matrices[i2][0].getRowCount();
            ++i2;
        }
        return new LongMatrixToken(tiled);
    }

    public long[][] longMatrix() {
        return LongMatrixMath.toMatrixFromArray(this._value, this._rowCount, this._columnCount);
    }

    public Token one() {
        try {
            return new LongMatrixToken(LongMatrixMath.identity(this._rowCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("LongMatrixToken.one: Cannot create identity matrix.");
        }
    }

    public Token oneRight() {
        try {
            return new LongMatrixToken(LongMatrixMath.identity(this._columnCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("LongMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        long[][] source = this.longMatrix();
        int row = 0;
        int i = 0;
        while (i < rows.length) {
            int column = 0;
            int j = 0;
            while (j < columns.length) {
                int columnspan;
                long[][] contents = new long[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    LongMatrixMath.matrixCopy(source, row, column, contents, 0, 0, rowspan, columnspan);
                }
                column += columns[j];
                try {
                    result[i][j] = new LongMatrixToken(contents);
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
                ++j;
            }
            row += rows[i];
            ++i;
        }
        return result;
    }

    public Token zero() {
        try {
            return new LongMatrixToken(new long[this._rowCount * this._columnCount], this._rowCount, this._columnCount, 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("LongMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        LongMatrixToken convertedArgument = (LongMatrixToken)rightArgument;
        long[] result = LongArrayMath.add(convertedArgument._getInternalLongArray(), this._value);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.add(this._value, scalar);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _divideElement(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.divide(this._value, scalar);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected long[] _getInternalLongArray() {
        return this._value;
    }

    protected MatrixToken _moduloElement(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.modulo(this._value, scalar);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        LongMatrixToken convertedArgument = (LongMatrixToken)rightArgument;
        long[] A = this._value;
        long[] B = convertedArgument._getInternalLongArray();
        int m = this._rowCount;
        int n = this._columnCount;
        int p = convertedArgument.getColumnCount();
        long[] newMatrix = new long[m * p];
        int in = 0;
        int ta = 0;
        int i = 0;
        while (i < m) {
            ta += n;
            int j = 0;
            while (j < p) {
                long sum = 0L;
                int ib = j;
                int ia = i * n;
                while (ia < ta) {
                    sum += A[ia] * B[ib];
                    ++ia;
                    ib += p;
                }
                newMatrix[in++] = sum;
                ++j;
            }
            ++i;
        }
        return new LongMatrixToken(newMatrix, m, p, 1);
    }

    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.multiply(this._value, scalar);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        LongMatrixToken convertedArgument = (LongMatrixToken)rightArgument;
        long[] result = LongArrayMath.subtract(this._value, convertedArgument._getInternalLongArray());
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.add(this._value, -scalar);
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        long scalar;
        if (rightArgument instanceof LongMatrixToken) {
            if (((LongMatrixToken)rightArgument).getRowCount() != 1 || ((LongMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((LongMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((LongToken)rightArgument).longValue();
        }
        long[] result = LongArrayMath.negative(LongArrayMath.add(this._value, -scalar));
        return new LongMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    private void _initialize(long[][] value, int copy) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = LongMatrixMath.fromMatrixToArray(value);
    }
}

