/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.Function;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class FunctionToken
extends Token {
    private Function _function;
    private FunctionType _type;

    public FunctionToken(Function f, FunctionType type) {
        this._function = f;
        this._type = type;
    }

    public FunctionToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        ParseTreeTypeInference inference = new ParseTreeTypeInference();
        inference.inferTypes(tree);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof FunctionToken)) {
            throw new IllegalActionException("A function token cannot be created from the expression '" + init + "'");
        }
        this._function = ((FunctionToken)token)._function;
        this._type = ((FunctionToken)token)._type;
    }

    public Token apply(Token[] args) throws IllegalActionException {
        return this._function.apply(args);
    }

    public Function getFunction() {
        return this._function;
    }

    public int getNumberOfArguments() {
        return this._function.getNumberOfArguments();
    }

    public Type getType() {
        return this._type;
    }

    public BooleanToken isCloseTo(Token rightArgument, double epsilon) {
        return this.isEqualTo(rightArgument);
    }

    public BooleanToken isEqualTo(Token rightArgument) {
        FunctionToken convertedArgument = (FunctionToken)rightArgument;
        return BooleanToken.getInstance(convertedArgument._function.isCongruent(this._function));
    }

    public String toString() {
        return this._function.toString();
    }
}

