/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.sched.FixedPointDirector;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.Nameable;

public class FixedPointReceiver
extends AbstractReceiver {
    private FixedPointDirector _director;
    private boolean _known = false;
    private Token _token = null;

    public FixedPointReceiver() {
        this((FixedPointDirector)null);
    }

    public FixedPointReceiver(FixedPointDirector director) {
        this.reset();
        this._director = director;
    }

    public void clear() throws IllegalActionException {
        if (this.isKnown()) {
            if (this.hasToken()) {
                throw new IllegalActionException((Nameable)this.getContainer(), "Cannot change the status from present to absent.");
            }
        } else {
            this._token = null;
            this._known = true;
            if (this._director != null) {
                this._director._receiverChanged();
            }
        }
    }

    public Token get() throws NoTokenException {
        if (!this.isKnown()) {
            throw new InvalidStateException("FixedPointReceiver: get() called on an FixedPointReceiver with status unknown.");
        }
        if (this._token == null) {
            throw new NoTokenException("FixedPointReceiver: Attempt to get data from an empty receiver.");
        }
        return this._token;
    }

    public boolean hasRoom() {
        return !this.isKnown();
    }

    public boolean hasRoom(int numberOfTokens) throws IllegalArgumentException {
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("FixedPointReceiver: hasRoom() requires a positive argument.");
        }
        if (numberOfTokens == 1) {
            return !this.isKnown();
        }
        return false;
    }

    public boolean hasToken() {
        if (this.isKnown()) {
            return this._token != null;
        }
        throw new InvalidStateException(this.getContainer(), "hasToken() called on FixedPointReceiver with unknown status.");
    }

    public boolean hasToken(int numberOfTokens) {
        if (!this.isKnown()) {
            throw new InvalidStateException(this.getContainer(), "hasToken(int) called on FixedPointReceiver with unknown status.");
        }
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("FixedPointReceiver: hasToken(int) requires a positive argument.");
        }
        if (numberOfTokens == 1) {
            return this.hasToken();
        }
        return false;
    }

    public boolean isKnown() {
        return this._known;
    }

    public void put(Token token) throws IllegalActionException {
        if (token == null) {
            throw new IllegalArgumentException("FixedPointReceiver.put(null) is invalid. To set the status to absent, use the clear() method.");
        }
        if (!this.isKnown()) {
            this._token = token;
            this._known = true;
            if (this._director != null) {
                this._director._receiverChanged();
            }
        } else {
            if (!this.hasToken()) {
                throw new IllegalActionException((Nameable)this.getContainer(), "Cannot change from an absent status to a present status.  Call reset() first.");
            }
            if (!token.isEqualTo(this._token).booleanValue()) {
                throw new IllegalActionException((Nameable)this.getContainer(), "Cannot put a token with a different value into a receiver with present status.");
            }
        }
    }

    public void reset() {
        this._token = null;
        this._known = false;
    }

    public void setContainer(IOPort port) throws IllegalActionException {
        if (port == null && this._director != null) {
            this._director._receivers.remove(this);
        }
        super.setContainer(port);
    }
}

