/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Mailbox;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.ProcessDirector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class MailboxBoundaryReceiver
extends Mailbox
implements ProcessReceiver {
    private BoundaryDetector _boundaryDetector = new BoundaryDetector(this);
    private ProcessDirector _director;
    private Thread _readPending = null;
    private boolean _terminate = false;
    private Thread _writePending = null;

    public MailboxBoundaryReceiver() {
    }

    public MailboxBoundaryReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token get() {
        Workspace workspace = this.getContainer().workspace();
        Token result = null;
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            while (!this._terminate) {
                if (super.hasToken()) {
                    result = super.get();
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this);
                    this._writePending = null;
                    break;
                }
                try {
                    this._readPending = Thread.currentThread();
                    this._director.threadBlocked(Thread.currentThread(), this);
                    workspace.wait(this._director);
                }
                catch (InterruptedException interruptedException) {
                    this._terminate = true;
                }
            }
            if (!this._terminate) return result;
            throw new TerminateProcessException("");
        }
    }

    public ProcessDirector getDirector() {
        return this._director;
    }

    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadBlocked() {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            return this._readPending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteBlocked() {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            return this._writePending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Token token) {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            while (!this._terminate) {
                if (super.hasRoom()) {
                    super.put(token);
                    if (this._readPending != null) {
                        this._director.threadUnblocked(this._readPending, this);
                        this._readPending = null;
                    }
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this);
                    this._writePending = null;
                    break;
                }
                try {
                    this._writePending = Thread.currentThread();
                    this._director.threadBlocked(this._writePending, this);
                    Workspace workspace = this.getContainer().workspace();
                    workspace.wait(this._director);
                }
                catch (InterruptedException interruptedException) {
                    this._terminate = true;
                }
            }
            if (!this._terminate) return;
            throw new TerminateProcessException("Process terminated.");
        }
    }

    public synchronized void requestFinish() {
        this._terminate = true;
        this.notifyAll();
    }

    public void reset() {
        if (this._readPending != null) {
            this._director.threadUnblocked(this._readPending, this);
        }
        if (this._writePending != null) {
            this._director.threadUnblocked(this._writePending, this);
        }
        this._terminate = false;
        this._boundaryDetector.reset();
    }

    public void setContainer(IOPort port) throws IllegalActionException {
        super.setContainer(port);
        if (port == null) {
            this._director = null;
        } else {
            Actor actor = (Actor)((Object)port.getContainer());
            Director director = port.isInput() ? actor.getExecutiveDirector() : actor.getDirector();
            if (!(director instanceof ProcessDirector)) {
                throw new IllegalActionException((Nameable)port, "Cannot use an instance of PNQueueReceiver since the director is not a PNDirector.");
            }
            this._director = (ProcessDirector)director;
        }
    }
}

