/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.Branch;
import ptolemy.actor.process.CompositeProcessDirector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public class BranchController
implements Runnable {
    private int _branchesBlocked = 0;
    private CompositeActor _parentActor;
    private LinkedList _branches = new LinkedList();
    private LinkedList _ports = new LinkedList();
    private boolean _isActive = false;

    public BranchController(CompositeActor container) {
        this._parentActor = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateBranches() {
        LinkedList branchesCopy;
        BranchController branchController = this;
        synchronized (branchController) {
            if (!this.hasBranches()) {
                return;
            }
            this.setActive(true);
            branchesCopy = new LinkedList(this._branches);
        }
        for (Branch branch : branchesCopy) {
            Thread thread = new Thread(branch);
            this._getDirector().addThread(thread);
            thread.start();
        }
    }

    public void addBranches(IOPort port) throws IllegalActionException {
        if (port.getContainer() != this.getParent()) {
            throw new IllegalActionException("Can not contain a port that is not contained by this BranchController's container.");
        }
        if (this._ports.contains(port)) {
            throw new IllegalActionException((Nameable)port, "This port is already controlled by this BranchController");
        }
        if (this._hasInputPorts() && !port.isInput()) {
            throw new IllegalActionException("BranchControllers must contain only input ports or only output ports; not both");
        }
        if (this._hasOutputPorts() && !port.isOutput()) {
            throw new IllegalActionException("BranchControllers must contain only input ports or only output ports; not both");
        }
        this._ports.add(port);
        Branch branch = null;
        ProcessReceiver producerReceiver = null;
        ProcessReceiver consumerReceiver = null;
        Receiver[][] producerReceivers = null;
        Receiver[][] consumerReceivers = null;
        int i = 0;
        while (i < port.getWidth()) {
            if (port.isInput()) {
                producerReceivers = port.getReceivers();
                consumerReceivers = port.deepGetReceivers();
            } else if (port.isOutput()) {
                producerReceivers = port.getInsideReceivers();
                consumerReceivers = port.getRemoteReceivers();
            } else {
                throw new IllegalActionException("Bad news");
            }
            if (producerReceivers.length > i && consumerReceivers.length > i) {
                try {
                    producerReceiver = (ProcessReceiver)producerReceivers[i][0];
                    consumerReceiver = (ProcessReceiver)consumerReceivers[i][0];
                }
                catch (ClassCastException ex) {
                    throw new IllegalActionException((Nameable)port, ex, "At the current time, process-oriented domains (PN and CSP) cannot be nested inside firing-based domains (SDF, DE, CT, etc.).");
                }
                branch = new Branch(producerReceiver, consumerReceiver, this);
                this._branches.add(branch);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivateBranches() {
        this.setActive(false);
        Iterator branches = this._branches.iterator();
        Branch branch = null;
        while (branches.hasNext()) {
            ProcessReceiver receiver;
            branch = (Branch)branches.next();
            branch.setActive(false);
            ProcessReceiver processReceiver = receiver = branch.getConsumerReceiver();
            synchronized (processReceiver) {
                receiver.notifyAll();
            }
            processReceiver = receiver = branch.getProducerReceiver();
            synchronized (processReceiver) {
                receiver.notifyAll();
            }
        }
        this.notifyAll();
    }

    public LinkedList getBranchList() {
        return this._branches;
    }

    public CompositeActor getParent() {
        return this._parentActor;
    }

    public boolean hasBranches() {
        return this._branches.size() > 0;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    public synchronized boolean isBlocked() {
        if (!this.hasBranches()) {
            return true;
        }
        return this._branchesBlocked >= this._branches.size() && this._branchesBlocked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            this.activateBranches();
            var1_1 = this;
            synchronized (var1_1) {
                ** GOTO lbl15
                {
                    this.wait();
                    do {
                        if (!this.isBlocked() && this.isActive()) continue block5;
                        while (this.isBlocked() && this.isActive()) {
                            this._getDirector()._controllerBlocked(this);
                            this.wait();
                        }
                        this._getDirector()._controllerUnBlocked(this);
lbl15:
                        // 2 sources

                    } while (this.isActive());
                }
            }
        }
        catch (InterruptedException v1) {}
    }

    public void setActive(boolean active) {
        this._isActive = active;
    }

    protected CompositeProcessDirector _getDirector() {
        try {
            return (CompositeProcessDirector)this._parentActor.getDirector();
        }
        catch (NullPointerException nullPointerException) {
            String name = this.getParent().getName();
            throw new TerminateProcessException("Error: " + name + " contains a branch controller that has a " + "receiver that does not have a director");
        }
    }

    private boolean _hasInputPorts() {
        if (this._ports.size() == 0) {
            return false;
        }
        Iterator ports = this._ports.iterator();
        if (ports.hasNext()) {
            IOPort port = (IOPort)ports.next();
            return port.isInput();
        }
        return false;
    }

    private boolean _hasOutputPorts() {
        if (this._ports.size() == 0) {
            return false;
        }
        Iterator ports = this._ports.iterator();
        if (ports.hasNext()) {
            IOPort port = (IOPort)ports.next();
            return port.isOutput();
        }
        return false;
    }
}

