/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.parameters;

import ptolemy.actor.TypedActor;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class PortParameter
extends Parameter {
    protected ParameterPort _port;
    private boolean _settingName = false;

    public PortParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        if (container instanceof TypedActor) {
            this._port = new ParameterPort((ComponentEntity)container, name);
        }
    }

    public PortParameter(NamedObj container, String name, Token token) throws IllegalActionException, NameDuplicationException {
        this(container, name);
        this.setToken(token);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute instanceof Locatable) {
            Locatable location = (Locatable)((Object)attribute);
            if (this._port != null) {
                Attribute portAttribute = this._port.getAttribute("_location");
                Locatable portLocation = null;
                if (portAttribute instanceof Locatable) {
                    portLocation = (Locatable)((Object)portAttribute);
                } else {
                    try {
                        portLocation = new Location(this._port, "_location");
                        ((NamedObj)((Object)portLocation)).propagateExistence();
                    }
                    catch (KernelException ex) {
                        throw new InternalErrorException(ex);
                    }
                }
                double[] locationValues = location.getLocation();
                double[] portLocationValues = new double[]{locationValues[0] - 20.0, locationValues[1] - 5.0};
                portLocation.setLocation(portLocationValues);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public ParameterPort getPort() {
        return this._port;
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        PortParameter newObject = (PortParameter)super.clone(workspace);
        newObject._port = null;
        return newObject;
    }

    public void setContainer(Entity entity) throws IllegalActionException, NameDuplicationException {
        Port port;
        Entity previousContainer = (Entity)this.getContainer();
        super.setContainer(entity);
        if (this._port != null && entity != previousContainer) {
            this._port._parameter = null;
            this._port = null;
        }
        if (entity instanceof TypedActor && (port = entity.getPort(this.getName())) instanceof ParameterPort) {
            this._port = (ParameterPort)port;
            if (this._port._parameter == null) {
                this._port._parameter = this;
                this._port.setTypeSameAs(this);
            }
        }
    }

    public void setCurrentValue(Token token) throws IllegalActionException {
        if (this._debugging) {
            this._debug("setCurrentValue: " + token);
        }
        this._setTokenAndNotify(token);
        this.setUnknown(false);
    }

    public void setDisplayName(String name) {
        if (this._settingName) {
            return;
        }
        super.setDisplayName(name);
        if (this._port != null) {
            try {
                this._settingName = true;
                this._port._settingName = true;
                this._port.setDisplayName(name);
            }
            finally {
                this._settingName = false;
                this._port._settingName = false;
            }
        }
    }

    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        if (this._settingName) {
            return;
        }
        super.setName(name);
        if (this._port != null) {
            String oldName = this.getName();
            try {
                try {
                    this._settingName = true;
                    this._port._settingName = true;
                    this._port.setName(name);
                }
                catch (IllegalActionException ex) {
                    super.setName(oldName);
                    throw ex;
                }
                catch (NameDuplicationException ex) {
                    super.setName(oldName);
                    throw ex;
                }
            }
            finally {
                this._settingName = false;
                this._port._settingName = false;
            }
        }
    }

    public void update() throws IllegalActionException {
        ParameterPort port = this._port;
        if (port != null && port.getWidth() > 0 && port.hasToken(0)) {
            Token token = port.get(0);
            this.setCurrentValue(token);
            if (this._debugging) {
                this._debug("Updated parameter value to: " + token);
            }
        }
    }
}

