/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.IOException;
import java.io.OutputStreamWriter;
import ptolemy.actor.lib.Sink;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class Writer
extends Sink {
    private java.io.Writer _writer = null;
    private static java.io.Writer _stdOut = null;

    public Writer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        if (_stdOut == null) {
            _stdOut = new OutputStreamWriter(System.out);
        }
        this.setWriter(_stdOut);
    }

    public boolean postfire() throws IllegalActionException {
        try {
            int width = this.input.getWidth();
            int i = 0;
            while (i < width) {
                if (i > 0) {
                    this._writer.write("\t");
                }
                if (this.input.hasToken(i)) {
                    Token inputToken = this.input.get(i);
                    this._writer.write(inputToken.toString());
                }
                ++i;
            }
            this._writer.write("\n");
            this._writer.flush();
            return super.postfire();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "postfire() failed");
        }
    }

    public void setWriter(java.io.Writer writer) throws IllegalActionException {
        try {
            if (this._writer != null && this._writer != _stdOut) {
                this._writer.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "setWriter(" + writer + ") failed");
        }
        this._writer = writer != null ? writer : _stdOut;
    }

    public void wrapup() throws IllegalActionException {
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "wrapup(" + this._writer + ") failed");
        }
    }
}

