/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class VectorAssembler
extends Transformer {
    public Parameter isColumn;

    public VectorAssembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.input.setMultiport(true);
        this.output.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.output.setMultiport(false);
        this.isColumn = new Parameter((NamedObj)this, "isColumn", BooleanToken.TRUE);
        this.isColumn.setTypeEquals(BaseType.BOOLEAN);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:blue\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        int i;
        double[][] data;
        super.fire();
        int size = this.input.getWidth();
        boolean isColumnValue = ((BooleanToken)this.isColumn.getToken()).booleanValue();
        if (isColumnValue) {
            data = new double[size][1];
            i = 0;
            while (i < size) {
                data[i][0] = ((DoubleToken)this.input.get(i)).doubleValue();
                ++i;
            }
        } else {
            data = new double[1][size];
            i = 0;
            while (i < size) {
                data[0][i] = ((DoubleToken)this.input.get(i)).doubleValue();
                ++i;
            }
        }
        DoubleMatrixToken result = new DoubleMatrixToken(data);
        this.output.send(0, result);
    }

    public boolean prefire() throws IllegalActionException {
        int i = 0;
        while (i < this.input.getWidth()) {
            if (!this.input.hasToken(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

