/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import ptolemy.actor.lib.Source;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public abstract class URLReader
extends Source {
    public Parameter sourceURL;
    public Parameter refresh;
    protected BufferedReader _reader = null;
    protected static BufferedReader _stdIn = null;
    protected String _source;
    protected boolean _refreshFlag;

    public URLReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setMultiport(true);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.sourceURL = new Parameter((NamedObj)this, "sourceURL", new StringToken(""));
        this.sourceURL.setTypeEquals(BaseType.STRING);
        this.refresh = new Parameter((NamedObj)this, "refresh", new BooleanToken(false));
        this.refresh.setTypeEquals(BaseType.BOOLEAN);
        if (_stdIn == null) {
            _stdIn = new BufferedReader(new InputStreamReader(System.in));
        }
        this._setURLReader(_stdIn);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.sourceURL) {
            StringToken urlToken = null;
            try {
                urlToken = (StringToken)this.sourceURL.getToken();
                if (urlToken == null) {
                    this._source = null;
                    this._setURLReader(null);
                }
                this._source = urlToken.stringValue();
                if (this._source.equals("")) {
                    this._setURLReader(null);
                }
                URL url = new URL(this._source);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                this._setURLReader(reader);
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Failed to evaluate sourceURL '" + urlToken + "'");
            }
        } else if (attribute == this.refresh) {
            this._refreshFlag = ((BooleanToken)this.refresh.getToken()).booleanValue();
        }
        super.attributeChanged(attribute);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this.attributeChanged(this.sourceURL);
    }

    public void wrapup() throws IllegalActionException {
        try {
            if (this._reader != null && this._reader != _stdIn) {
                this._reader.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to close");
        }
    }

    protected void _setURLReader(BufferedReader reader) throws IllegalActionException {
        try {
            if (this._reader != null && this._reader != _stdIn) {
                this._reader.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to close");
        }
        this._reader = reader != null ? reader : _stdIn;
    }
}

