/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class TrigFunction
extends Transformer {
    public StringParameter function;
    private DoubleToken[] _resultArray = new DoubleToken[1];
    private int _function;
    private static final int _ACOS = 0;
    private static final int _ASIN = 1;
    private static final int _ATAN = 2;
    private static final int _COS = 3;
    private static final int _SIN = 4;
    private static final int _TAN = 5;

    public TrigFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function = new StringParameter(this, "function");
        this.function.setExpression("sin");
        this.function.addChoice("acos");
        this.function.addChoice("asin");
        this.function.addChoice("atan");
        this.function.addChoice("cos");
        this.function.addChoice("sin");
        this.function.addChoice("tan");
        this._function = 4;
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = this.function.stringValue();
            if (functionName.equals("acos")) {
                this._function = 0;
                return;
            } else if (functionName.equals("asin")) {
                this._function = 1;
                return;
            } else if (functionName.equals("atan")) {
                this._function = 2;
                return;
            } else if (functionName.equals("cos")) {
                this._function = 3;
                return;
            } else if (functionName.equals("sin")) {
                this._function = 4;
                return;
            } else {
                if (!functionName.equals("tan")) throw new IllegalActionException((Nameable)this, "Unrecognized trigonometric function: " + functionName);
                this._function = 5;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            double in = ((DoubleToken)this.input.get(0)).doubleValue();
            this.output.send(0, new DoubleToken(this._doFunction(in)));
        }
    }

    public int iterate(int count) throws IllegalActionException {
        if (count > this._resultArray.length) {
            this._resultArray = new DoubleToken[count];
        }
        if (this.input.hasToken(0, count)) {
            Token[] inArray = this.input.get(0, count);
            int i = 0;
            while (i < count) {
                double inputValue = ((DoubleToken)inArray[i]).doubleValue();
                this._resultArray[i] = new DoubleToken(this._doFunction(inputValue));
                ++i;
            }
            this.output.send(0, this._resultArray, count);
            return 0;
        }
        return 1;
    }

    private double _doFunction(double in) {
        double result;
        switch (this._function) {
            case 0: {
                result = Math.acos(in);
                break;
            }
            case 1: {
                result = Math.asin(in);
                break;
            }
            case 2: {
                result = Math.atan(in);
                break;
            }
            case 3: {
                result = Math.cos(in);
                break;
            }
            case 4: {
                result = Math.sin(in);
                break;
            }
            case 5: {
                result = Math.tan(in);
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for _function private variable. TrigFunction actor (" + this.getFullName() + ")" + " on function type " + this._function);
            }
        }
        return result;
    }
}

