/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class Synchronizer
extends Transformer {
    public Synchronizer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.output.setMultiport(true);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int outWidth = this.output.getWidth();
        int inWidth = this.input.getWidth();
        if (inWidth != outWidth) {
            throw new IllegalActionException((Nameable)this, "Unequal synchronizer channels: " + inWidth + " inputs and " + outWidth + " outputs.");
        }
        int i = 0;
        while (i < inWidth) {
            this.output.send(i, this.input.get(i));
            ++i;
        }
    }

    public boolean prefire() throws IllegalActionException {
        int i = 0;
        while (i < this.input.getWidth()) {
            if (!this.input.hasToken(i)) {
                return false;
            }
            ++i;
        }
        return super.prefire();
    }
}

