/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class Quantizer
extends Transformer {
    public Parameter levels = new Parameter(this, "levels");
    private double[] _thresholds;

    public Quantizer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.levels.setExpression("{-1.0, 1.0}");
        this.levels.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.attributeChanged(this.levels);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.levels) {
            ArrayToken levelsValue = (ArrayToken)this.levels.getToken();
            double[] _levels = new double[levelsValue.length()];
            double previous = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < levelsValue.length()) {
                _levels[i] = ((DoubleToken)levelsValue.getElement(i)).doubleValue();
                if (_levels[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of levels is not nondecreasing.");
                }
                previous = _levels[i];
                ++i;
            }
            this._thresholds = new double[_levels.length - 1];
            int j = 0;
            while (j < _levels.length - 1) {
                this._thresholds[j] = (_levels[j + 1] + _levels[j]) / 2.0;
                ++j;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            double in = ((DoubleToken)this.input.get(0)).doubleValue();
            int index = this._getQuantizationIndex(in);
            this.output.send(0, ((ArrayToken)this.levels.getToken()).getElement(index));
        }
    }

    private int _getQuantizationIndex(double in) {
        int index = this._thresholds.length;
        int i = 0;
        while (i < this._thresholds.length) {
            if (in <= this._thresholds[i]) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

