/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class PhaseUnwrap
extends Transformer {
    private double _previousPhaseInput = 0.0;
    private double _tempPreviousPhaseInput = 0.0;
    private double _previousPhaseOutput = 0.0;
    private double _tempPreviousPhaseOutput = 0.0;

    public PhaseUnwrap(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            double newPhase = ((DoubleToken)this.input.get(0)).doubleValue();
            double phaseChange = newPhase - this._previousPhaseInput;
            if (phaseChange < -Math.PI) {
                phaseChange += Math.PI * 2;
            }
            if (phaseChange > Math.PI) {
                phaseChange -= Math.PI * 2;
            }
            this._tempPreviousPhaseOutput = this._previousPhaseOutput + phaseChange;
            this._tempPreviousPhaseInput = newPhase;
            this.output.send(0, new DoubleToken(this._tempPreviousPhaseOutput));
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._previousPhaseInput = 0.0;
        this._previousPhaseOutput = 0.0;
        this._tempPreviousPhaseInput = 0.0;
        this._tempPreviousPhaseOutput = 0.0;
    }

    public boolean postfire() throws IllegalActionException {
        this._previousPhaseInput = this._tempPreviousPhaseInput;
        this._previousPhaseOutput = this._tempPreviousPhaseOutput;
        return super.postfire();
    }
}

