/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class MaxIndex
extends Transformer {
    public MaxIndex(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.input.setMultiport(true);
        this.output.setTypeEquals(BaseType.INT);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        double maxValue = Double.NEGATIVE_INFINITY;
        int maxIndex = -1;
        boolean foundFirst = false;
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i)) {
                double val = ((DoubleToken)this.input.get(i)).doubleValue();
                if (foundFirst) {
                    if (maxValue < val) {
                        maxValue = val;
                        maxIndex = i;
                    }
                } else {
                    maxValue = val;
                    maxIndex = i;
                    foundFirst = true;
                }
            }
            ++i;
        }
        if (foundFirst) {
            this.output.send(0, new IntToken(maxIndex));
        }
    }
}

