/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class MathFunction
extends TypedAtomicActor {
    public StringParameter function;
    public TypedIOPort firstOperand = null;
    public TypedIOPort secondOperand = null;
    public TypedIOPort output = null;
    private DoubleToken[] _resultArray = new DoubleToken[0];
    private int _function;
    private static final int _EXP = 0;
    private static final int _LOG = 1;
    private static final int _MODULO = 2;
    private static final int _SIGN = 3;
    private static final int _SQUARE = 4;
    private static final int _SQRT = 5;

    public MathFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function = new StringParameter(this, "function");
        this.function.setExpression("exp");
        this.function.addChoice("exp");
        this.function.addChoice("log");
        this.function.addChoice("modulo");
        this.function.addChoice("sign");
        this.function.addChoice("square");
        this.function.addChoice("sqrt");
        this._function = 0;
        this.firstOperand = new TypedIOPort(this, "firstOperand");
        this.firstOperand.setInput(true);
        this.output = new TypedIOPort(this, "output");
        this.output.setOutput(true);
        this.firstOperand.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        try {
            if (attribute == this.function) {
                String functionName = this.function.stringValue();
                if (functionName.equals("exp")) {
                    this._function = 0;
                    if (this.secondOperand == null) return;
                    this.secondOperand.setContainer(null);
                    return;
                } else if (functionName.equals("log")) {
                    this._function = 1;
                    if (this.secondOperand == null) return;
                    this.secondOperand.setContainer(null);
                    return;
                } else if (functionName.equals("modulo")) {
                    this._function = 2;
                    this._createSecondPort();
                    return;
                } else if (functionName.equals("sign")) {
                    this._function = 3;
                    if (this.secondOperand == null) return;
                    this.secondOperand.setContainer(null);
                    return;
                } else if (functionName.equals("square")) {
                    this._function = 4;
                    if (this.secondOperand == null) return;
                    this.secondOperand.setContainer(null);
                    return;
                } else {
                    if (!functionName.equals("sqrt")) throw new IllegalActionException((Nameable)this, "Unrecognized math function: " + functionName);
                    this._function = 5;
                    if (this.secondOperand == null) return;
                    this.secondOperand.setContainer(null);
                }
                return;
            } else {
                super.attributeChanged(attribute);
            }
            return;
        }
        catch (NameDuplicationException nameDuplication) {
            throw new InternalErrorException(this, (Throwable)nameDuplication, "Unexpected name duplication");
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.firstOperand.hasToken(0)) {
            double input1 = ((DoubleToken)this.firstOperand.get(0)).doubleValue();
            double input2 = 1.0;
            if (this._function == 2 && this.secondOperand.hasToken(0)) {
                input2 = ((DoubleToken)this.secondOperand.get(0)).doubleValue();
            }
            this.output.send(0, new DoubleToken(this._doFunction(input1, input2)));
        }
    }

    public int iterate(int count) throws IllegalActionException {
        if (count > this._resultArray.length) {
            this._resultArray = new DoubleToken[count];
        }
        if (this.firstOperand.hasToken(0, count)) {
            if (this._function == 2) {
                if (this.secondOperand.hasToken(0, count)) {
                    Token[] inArray1 = this.firstOperand.get(0, count);
                    Token[] inArray2 = this.secondOperand.get(0, count);
                    int i = 0;
                    while (i < count) {
                        double input1 = ((DoubleToken)inArray1[i]).doubleValue();
                        double input2 = ((DoubleToken)inArray2[i]).doubleValue();
                        this._resultArray[i] = new DoubleToken(this._doFunction(input1, input2));
                        ++i;
                    }
                    this.output.send(0, this._resultArray, count);
                    return 0;
                }
                return 1;
            }
            Token[] inArray1 = this.firstOperand.get(0, count);
            int i = 0;
            while (i < count) {
                double input1 = ((DoubleToken)inArray1[i]).doubleValue();
                this._resultArray[i] = new DoubleToken(this._doFunction(input1, 0.0));
                ++i;
            }
            this.output.send(0, this._resultArray, count);
            return 0;
        }
        return 1;
    }

    private void _createSecondPort() throws NameDuplicationException, IllegalActionException {
        this.secondOperand = (TypedIOPort)this.getPort("secondOperand");
        if (this.secondOperand == null) {
            this.secondOperand = new TypedIOPort(this, "secondOperand", true, false);
        } else if (this.secondOperand.getContainer() == null) {
            this.secondOperand.setContainer(this);
        }
        this.secondOperand.setTypeEquals(BaseType.DOUBLE);
    }

    private double _doFunction(double input1, double input2) {
        double result;
        switch (this._function) {
            case 0: {
                result = Math.exp(input1);
                break;
            }
            case 1: {
                result = Math.log(input1);
                break;
            }
            case 2: {
                result = input1 % input2;
                break;
            }
            case 3: {
                if (input1 > 0.0) {
                    result = 1.0;
                    break;
                }
                if (input1 < 0.0) {
                    result = -1.0;
                    break;
                }
                result = 0.0;
                break;
            }
            case 4: {
                result = input1 * input1;
                break;
            }
            case 5: {
                result = Math.sqrt(input1);
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for _function private variable. MathFunction actor (" + this.getFullName() + ")" + " on function type " + this._function);
            }
        }
        return result;
    }
}

