/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Lattice;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class GradientAdaptiveLattice
extends Lattice {
    public TypedIOPort adaptedReflectionCoefficients;
    public Parameter timeConstant = new Parameter(this, "timeConstant");
    private double _alpha = 0.0;
    private double _oneMinusAlpha = 1.0;
    private double[] _estimatedErrorPower;
    private double[] _estimatedErrorPowerCache;
    private double[] _reflectionCoefficientsCache;

    public GradientAdaptiveLattice(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.timeConstant.setExpression("1.0");
        this.timeConstant.setTypeEquals(BaseType.DOUBLE);
        this.timeConstant.validate();
        this.adaptedReflectionCoefficients = new TypedIOPort(this, "adaptedReflectionCoefficients", false, true);
        this.adaptedReflectionCoefficients.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.output.setTypeAtLeast(this.input);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.timeConstant) {
            double timeConstantValue = ((DoubleToken)this.timeConstant.getToken()).doubleValue();
            this._oneMinusAlpha = (timeConstantValue - 1.0) / (timeConstantValue + 1.0);
            this._alpha = 1.0 - this._oneMinusAlpha;
        }
        super.attributeChanged(attribute);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        GradientAdaptiveLattice newObject = (GradientAdaptiveLattice)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        int i = 0;
        while (i <= this._order) {
            this._estimatedErrorPower[i] = 0.0;
            this._estimatedErrorPowerCache[i] = 0.0;
            if (i < this._order) {
                this._reflectionCoefficientsCache[i] = 0.0;
            }
            ++i;
        }
        ArrayToken value = (ArrayToken)this.reflectionCoefficients.getToken();
        int i2 = 0;
        while (i2 < this._order) {
            this._reflectionCoefficients[i2] = ((DoubleToken)value.getElement(i2)).doubleValue();
            ++i2;
        }
    }

    public boolean postfire() throws IllegalActionException {
        System.arraycopy(this._estimatedErrorPowerCache, 0, this._estimatedErrorPower, 0, this._order + 1);
        System.arraycopy(this._reflectionCoefficientsCache, 0, this._reflectionCoefficients, 0, this._order);
        return super.postfire();
    }

    protected void _doFilter() throws IllegalActionException {
        double k;
        int i = 0;
        while (i < this._order) {
            k = this._reflectionCoefficients[i];
            this._forwardCache[i + 1] = -k * this._backwardCache[i] + this._forwardCache[i];
            ++i;
        }
        Token[] outputArray = new DoubleToken[this._order];
        int i2 = this._order;
        while (i2 > 0) {
            k = this._reflectionCoefficients[i2 - 1];
            this._backwardCache[i2] = -k * this._forwardCache[i2 - 1] + this._backwardCache[i2 - 1];
            double fe_i = this._forwardCache[i2];
            double be_i = this._backwardCache[i2];
            double fe_ip = this._forwardCache[i2 - 1];
            double be_ip = this._backwardCache[i2 - 1];
            double newError = this._estimatedErrorPower[i2] * this._oneMinusAlpha + this._alpha * (fe_ip * fe_ip + be_ip * be_ip);
            double newCoefficient = this._reflectionCoefficients[i2 - 1];
            if (newError != 0.0) {
                if ((newCoefficient += this._alpha * (fe_i * be_ip + be_i * fe_ip) / newError) > 1.0) {
                    newCoefficient = 1.0;
                } else if (newCoefficient < -1.0) {
                    newCoefficient = -1.0;
                }
            }
            outputArray[i2 - 1] = new DoubleToken(newCoefficient);
            this._reflectionCoefficientsCache[i2 - 1] = newCoefficient;
            this._estimatedErrorPowerCache[i2] = newError;
            --i2;
        }
        this.adaptedReflectionCoefficients.send(0, new ArrayToken(BaseType.DOUBLE, outputArray));
    }

    protected void _reallocate() {
        super._reallocate();
        this._estimatedErrorPower = new double[this._order + 1];
        this._estimatedErrorPowerCache = new double[this._order + 1];
        this._reflectionCoefficientsCache = new double[this._order];
    }
}

