/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeConstant;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Expression
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public StringAttribute expression = new StringAttribute(this, "expression");
    private int _iterationCount = 1;
    private ASTPtRootNode _parseTree = null;
    private ParseTreeEvaluator _parseTreeEvaluator = null;
    private VariableScope _scope = null;
    private Map _tokenMap;

    public Expression(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.expression.setExpression("");
        Parameter hide = new Parameter(this.expression, "_hide");
        hide.setExpression("true");
        this._setOutputTypeConstraint();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.expression) {
            this._parseTree = null;
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Expression newObject = (Expression)super.clone(workspace);
        newObject._iterationCount = 1;
        newObject._parseTree = null;
        newObject._parseTreeEvaluator = null;
        newObject._scope = null;
        newObject._setOutputTypeConstraint();
        newObject._tokenMap = null;
        return newObject;
    }

    public void fire() throws IllegalActionException {
        Token result;
        super.fire();
        for (IOPort port : this.inputPortList()) {
            if (port.getWidth() <= 0) continue;
            if (port.hasToken(0)) {
                Token inputToken = port.get(0);
                this._tokenMap.put(port.getName(), inputToken);
                continue;
            }
            throw new IllegalActionException((Nameable)this, "Input port " + port.getName() + " has no data.");
        }
        try {
            if (this._parseTree == null) {
                PtParser parser = new PtParser();
                this._parseTree = parser.generateParseTree(this.expression.getExpression());
            }
            if (this._parseTreeEvaluator == null) {
                this._parseTreeEvaluator = new ParseTreeEvaluator();
            }
            if (this._scope == null) {
                this._scope = new VariableScope();
            }
            result = this._parseTreeEvaluator.evaluateParseTree(this._parseTree, this._scope);
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Expression invalid.");
        }
        if (result == null) {
            throw new IllegalActionException((Nameable)this, "Expression yields a null result: " + this.expression.getExpression());
        }
        this.output.send(0, result);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this.getPort("time") != null) {
            throw new IllegalActionException((Nameable)this, "This actor has a port named \"time\", which will not be read, instead the reserved system variable \"time\" will be read. Delete the \"time\" port to avoid this message.");
        }
        if (this.getPort("iteration") != null) {
            throw new IllegalActionException((Nameable)this, "This actor has a port named \"iteration\", which will not be read, instead the reserved system variable \"iteration\" will be read. Delete the \"iteration\" port to avoid this message.");
        }
        this._iterationCount = 1;
    }

    public boolean postfire() throws IllegalActionException {
        ++this._iterationCount;
        return true;
    }

    public boolean prefire() throws IllegalActionException {
        for (IOPort port : this.inputPortList()) {
            if (port.getWidth() <= 0 || port.hasToken(0)) continue;
            return false;
        }
        return super.prefire();
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._tokenMap = new HashMap();
    }

    private void _setOutputTypeConstraint() {
        this.output.setTypeAtLeast(new OutputTypeFunction());
    }

    private class OutputTypeFunction
    extends MonotonicFunction {
        private ParseTreeTypeInference _typeInference = new ParseTreeTypeInference();
        private ParseTreeFreeVariableCollector _variableCollector = new ParseTreeFreeVariableCollector();

        private OutputTypeFunction() {
        }

        public Object getValue() throws IllegalActionException {
            try {
                InequalityTerm[] terms = this.getVariables();
                int i = 0;
                while (i < terms.length) {
                    InequalityTerm term = terms[i];
                    if (term != this && term.getValue() == BaseType.UNKNOWN) {
                        return BaseType.UNKNOWN;
                    }
                    ++i;
                }
                if (Expression.this._parseTree == null) {
                    PtParser parser = new PtParser();
                    Expression.this._parseTree = parser.generateParseTree(Expression.this.expression.getExpression());
                }
                if (Expression.this._scope == null) {
                    Expression.this._scope = new VariableScope();
                }
                Type type = this._typeInference.inferTypes(Expression.this._parseTree, Expression.this._scope);
                return type;
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)Expression.this, ex, "An error occurred during expression type inference");
            }
        }

        public InequalityTerm[] getVariables() {
            try {
                if (Expression.this._parseTree == null) {
                    PtParser parser = new PtParser();
                    Expression.this._parseTree = parser.generateParseTree(Expression.this.expression.getExpression());
                }
                if (Expression.this._scope == null) {
                    Expression.this._scope = new VariableScope();
                }
                Set set = this._variableCollector.collectFreeVariables(Expression.this._parseTree, Expression.this._scope);
                LinkedList<InequalityTerm> termList = new LinkedList<InequalityTerm>();
                for (String name : set) {
                    InequalityTerm term = Expression.this._scope.getTypeTerm(name);
                    if (term == null || !term.isSettable()) continue;
                    termList.add(term);
                }
                return termList.toArray(new InequalityTerm[termList.size()]);
            }
            catch (IllegalActionException illegalActionException) {
                return new InequalityTerm[0];
            }
        }

        public String getVerboseString() {
            return Expression.this.expression.getExpression();
        }
    }

    private class VariableScope
    extends ModelScope {
        private VariableScope() {
        }

        public Token get(String name) throws IllegalActionException {
            if (name.equals("time")) {
                return new DoubleToken(Expression.this.getDirector().getModelTime().getDoubleValue());
            }
            if (name.equals("iteration")) {
                return new IntToken(Expression.this._iterationCount);
            }
            Token token = (Token)Expression.this._tokenMap.get(name);
            if (token != null) {
                return token;
            }
            Variable result = VariableScope.getScopedVariable(null, Expression.this, name);
            if (result != null) {
                return result.getToken();
            }
            return null;
        }

        public Type getType(String name) throws IllegalActionException {
            if (name.equals("time")) {
                return BaseType.DOUBLE;
            }
            if (name.equals("iteration")) {
                return BaseType.INT;
            }
            TypedIOPort port = (TypedIOPort)Expression.this.getPort(name);
            if (port != null) {
                return port.getType();
            }
            Variable result = VariableScope.getScopedVariable(null, Expression.this, name);
            if (result != null) {
                return (Type)result.getTypeTerm().getValue();
            }
            return null;
        }

        public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
            if (name.equals("time")) {
                return new TypeConstant(BaseType.DOUBLE);
            }
            if (name.equals("iteration")) {
                return new TypeConstant(BaseType.INT);
            }
            TypedIOPort port = (TypedIOPort)Expression.this.getPort(name);
            if (port != null) {
                return port.getTypeTerm();
            }
            Variable result = VariableScope.getScopedVariable(null, Expression.this, name);
            if (result != null) {
                return result.getTypeTerm();
            }
            return null;
        }

        public Set identifierSet() {
            return VariableScope.getAllScopedVariableNames(null, Expression.this);
        }
    }
}

