/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.IOException;
import java.util.StringTokenizer;
import ptolemy.actor.lib.URLReader;
import ptolemy.data.DoubleToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DoubleReader
extends URLReader {
    private double[] _data;
    private int _dataSize;

    public DoubleReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int i = 0;
        while (i < this._dataSize) {
            this.output.send(i, new DoubleToken(this._data[i]));
            ++i;
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._dataSize = this.output.getWidth();
        this._data = new double[this._dataSize];
        this.attributeChanged(this.sourceURL);
    }

    public boolean prefire() throws IllegalActionException {
        String oneRow;
        block6: {
            this._dataSize = this.output.getWidth();
            if (this._data.length != this._dataSize) {
                this._data = new double[this._dataSize];
            }
            if ((oneRow = this._reader.readLine()) != null) break block6;
            return false;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(oneRow);
            int columnCount = tokenizer.countTokens();
            if (this._dataSize > columnCount) {
                this._dataSize = columnCount;
            }
            int i = 0;
            while (i < this._dataSize) {
                this._data[i] = Double.valueOf(tokenizer.nextToken());
                ++i;
            }
            return super.prefire();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "prefire() failed");
        }
    }
}

