/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Manager;
import ptolemy.actor.lib.TimedSource;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class Clock
extends TimedSource {
    public Parameter numberOfCycles;
    public Parameter offsets;
    public PortParameter period = new PortParameter(this, "period");
    public Parameter values;
    protected transient int _cycleCount;
    protected transient Time _cycleStartTime;
    protected transient boolean _enabled;
    protected transient boolean _firstOutputProduced = false;
    protected transient Time _nextOutputTime;
    protected transient double[] _offsets;
    protected transient boolean _outputProduced = false;
    protected transient int _phase;
    protected transient Time _tentativeNextOutputTime;
    private transient double _previousPeriod;
    private transient Time _tentativeCycleStartTime;
    private transient boolean _tentative = false;
    private transient boolean _tentativeEnabled;
    private transient int _tentativePhase;
    private transient boolean _tentativeTriggered;
    private transient boolean _triggered;

    public Clock(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.period.setExpression("2.0");
        this.period.setTypeEquals(BaseType.DOUBLE);
        this.offsets = new Parameter(this, "offsets");
        this.offsets.setExpression("{0.0, 1.0}");
        this.offsets.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.attributeChanged(this.offsets);
        this.values = new Parameter(this, "values");
        this.values.setExpression("{1, 0}");
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
        this.attributeChanged(this.values);
        Parameter unbounded = new Parameter(this, "UNBOUNDED");
        unbounded.setPersistent(false);
        unbounded.setExpression("-1");
        unbounded.setVisibility(Settable.EXPERT);
        this.numberOfCycles = new Parameter(this, "numberOfCycles");
        this.numberOfCycles.setTypeEquals(BaseType.INT);
        this.numberOfCycles.setExpression("UNBOUNDED");
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        new Parameter((NamedObj)this.trigger, "signalType", new StringToken("DISCRETE"));
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.offsets) {
            Manager.State state;
            ArrayToken offsetsValue = (ArrayToken)this.offsets.getToken();
            this._offsets = new double[offsetsValue.length()];
            double previous = 0.0;
            int i = 0;
            while (i < offsetsValue.length()) {
                this._offsets[i] = ((DoubleToken)offsetsValue.getElement(i)).doubleValue();
                if (this._offsets[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of offsets is not nondecreasing and nonnegative.");
                }
                previous = this._offsets[i];
                ++i;
            }
            if (this.getManager() != null && ((state = this.getManager().getState()) == Manager.ITERATING || state == Manager.PAUSED)) {
                this.initialize();
            }
        } else if (attribute == this.period) {
            Manager.State state;
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            if (this._debugging) {
                this._debug("Setting period to " + periodValue);
            }
            if (periodValue <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Period is required to be positive.  Period given: " + periodValue);
            }
            if (this.getManager() != null && ((state = this.getManager().getState()) == Manager.ITERATING || state == Manager.PAUSED)) {
                Time potentialNextOutputTime;
                this._catchUp();
                if (this._phase == 0 && this._firstOutputProduced && (potentialNextOutputTime = this._tentativeCycleStartTime.subtract(this._previousPeriod).add(periodValue)).compareTo(this.getDirector().getModelTime()) >= 0) {
                    this._tentativeNextOutputTime = potentialNextOutputTime;
                    this._tentativeCycleStartTime = potentialNextOutputTime;
                    if (!this._tentative) {
                        this._nextOutputTime = this._tentativeNextOutputTime;
                        this._cycleStartTime = this._tentativeCycleStartTime;
                    }
                }
                this.getDirector().fireAt((Actor)this, this._tentativeNextOutputTime);
            }
            this._previousPeriod = periodValue;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Clock newObject = (Clock)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        if (this._debugging) {
            this._debug("Called fire() at time " + currentTime);
        }
        this._updateTentativeValues();
        try {
            this._tentative = true;
            this.period.update();
        }
        finally {
            this._tentative = false;
        }
        boolean triggerConnected = false;
        if (this.trigger.numberOfSources() > 0) {
            triggerConnected = true;
            int i = 0;
            while (i < this.trigger.getWidth()) {
                if (this.trigger.isKnown(i) && this.trigger.hasToken(i)) {
                    this.trigger.get(i);
                    this._tentativeTriggered = true;
                }
                ++i;
            }
        }
        if (this._enabled) {
            this._catchUp();
            if (this._isTimeForOutput()) {
                if (!triggerConnected || this._tentativeTriggered) {
                    this.output.send(0, this._getValue(this._tentativePhase));
                }
                this._outputProduced = true;
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._tentativeCycleStartTime = this._cycleStartTime = this.getDirector().getModelTime();
        this._cycleCount = 0;
        this._tentativePhase = this._phase = 0;
        this._tentativeNextOutputTime = this._nextOutputTime = this._cycleStartTime.add(this._offsets[this._phase]);
        this._firstOutputProduced = false;
        this._outputProduced = false;
        this._tentativeEnabled = this._enabled = true;
        this._previousPeriod = ((DoubleToken)this.period.getToken()).doubleValue();
        this._tentativeTriggered = this._triggered = true;
        if (this._debugging) {
            this._debug("Requesting firing at time " + this._nextOutputTime);
        }
        this.getDirector().fireAt((Actor)this, this._nextOutputTime);
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Postfiring at " + this.getDirector().getModelTime());
        }
        this._updateStates();
        if (this._outputProduced) {
            this._firstOutputProduced = true;
        }
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        ArrayToken val;
        if (this._debugging) {
            this._debug("Called prefire()");
        }
        if (this._offsets.length != (val = (ArrayToken)this.values.getToken()).length()) {
            throw new IllegalActionException((Nameable)this, "Values and offsets vectors do not have the same length.");
        }
        return true;
    }

    protected void _catchUp() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        if (this._tentativeNextOutputTime.compareTo(currentTime) >= 0) {
            return;
        }
        double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        Time phaseStartTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase]);
        while (phaseStartTime.compareTo(currentTime) < 0) {
            ++this._tentativePhase;
            if (this._tentativePhase >= this._offsets.length) {
                this._tentativePhase = 0;
                this._tentativeCycleStartTime = this._tentativeCycleStartTime.add(periodValue);
            }
            phaseStartTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase]);
        }
        this._tentativeNextOutputTime = phaseStartTime;
    }

    protected Token _getValue(int index) throws IllegalActionException {
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (val == null || val.length() <= index) {
            throw new IllegalActionException((Nameable)this, "Index out of range of the values parameter.");
        }
        return val.getElement(index);
    }

    protected boolean _isTimeForOutput() {
        Time currentTime = this.getDirector().getModelTime();
        return this._tentativeNextOutputTime.equals(currentTime);
    }

    protected void _updateTentativeValues() throws IllegalActionException {
        this._outputProduced = false;
        this._tentativeCycleStartTime = this._cycleStartTime;
        this._tentativeEnabled = this._enabled;
        this._tentativeNextOutputTime = this._nextOutputTime;
        this._tentativePhase = this._phase;
        this._tentativeTriggered = this._triggered;
    }

    protected void _updateStates() throws IllegalActionException {
        boolean triggerConnected = this.trigger.numberOfSources() > 0;
        boolean fireAtNeeded = this._tentativeEnabled && (!triggerConnected && this._outputProduced || triggerConnected && this._tentativeTriggered && !this._outputProduced);
        this._cycleStartTime = this._tentativeCycleStartTime;
        this._phase = this._tentativePhase;
        if (this._outputProduced) {
            ++this._phase;
            if (this._phase == this._offsets.length) {
                double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
                this._tentativeCycleStartTime = this._cycleStartTime = this._cycleStartTime.add(periodValue);
                ++this._cycleCount;
                this._phase = 0;
            }
            this._tentativeTriggered = false;
        }
        this._triggered = this._tentativeTriggered;
        this._enabled = this._tentativeEnabled;
        this._nextOutputTime = this._cycleStartTime.add(this._offsets[this._phase]);
        if (fireAtNeeded) {
            if (this._debugging) {
                this._debug("Requesting firing at: " + this._nextOutputTime + ".");
            }
            this.getDirector().fireAt((Actor)this, this._nextOutputTime);
        }
        int cycleLimit = ((IntToken)this.numberOfCycles.getToken()).intValue();
        this._enabled = this._enabled && (cycleLimit <= 0 || this._cycleCount <= cycleLimit);
    }
}

