/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArrayElementAsMatrix
extends Transformer {
    public PortParameter xOffset;
    public PortParameter yOffset;
    public PortParameter x;
    public PortParameter y;

    public ArrayElementAsMatrix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType(this.input));
        this.xOffset = new PortParameter(this, "xOffset");
        this.xOffset.setTypeEquals(BaseType.INT);
        this.xOffset.setExpression("1");
        this.yOffset = new PortParameter(this, "yOffset");
        this.yOffset.setTypeEquals(BaseType.INT);
        this.yOffset.setExpression("1");
        this.x = new PortParameter(this, "x");
        this.x.setTypeEquals(BaseType.INT);
        this.x.setExpression("0");
        this.y = new PortParameter(this, "y");
        this.y.setTypeEquals(BaseType.INT);
        this.y.setExpression("0");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayElementAsMatrix newObject = (ArrayElementAsMatrix)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.xOffset.update();
        this.yOffset.update();
        this.x.update();
        this.y.update();
        int xOffsetValue = ((IntToken)this.xOffset.getToken()).intValue();
        int yOffsetValue = ((IntToken)this.yOffset.getToken()).intValue();
        int xValue = ((IntToken)this.x.getToken()).intValue();
        int yValue = ((IntToken)this.y.getToken()).intValue();
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            if (xOffsetValue < 0 || yOffsetValue < 0 || xValue < 0 || yValue < 0 || xValue * xOffsetValue + yValue * yOffsetValue >= token.length()) {
                throw new IllegalActionException((Nameable)this, "xValue (" + xValue + ") * xOffsetValue *(" + xOffsetValue + " ) + yValue (" + yValue + ") * yOffsetValue (" + yOffsetValue + ") = " + xValue * xOffsetValue + yValue * yOffsetValue + " is less than zero or otherwise " + "out of range for the input " + "array, which has length " + token.length());
            }
            this.output.send(0, token.getElement(xValue * xOffsetValue + yValue * yOffsetValue));
        }
    }
}

