/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArrayElement
extends Transformer {
    public PortParameter index;

    public ArrayElement(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType(this.input));
        this.index = new PortParameter(this, "index");
        this.index.setTypeEquals(BaseType.INT);
        this.index.setExpression("0");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayElement newObject = (ArrayElement)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.index.update();
        int indexValue = ((IntToken)this.index.getToken()).intValue();
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            if (indexValue < 0 || indexValue >= token.length()) {
                throw new IllegalActionException((Nameable)this, "index " + indexValue + " is out of range for the input " + "array, which has length " + token.length());
            }
            this.output.send(0, token.getElement(indexValue));
        }
    }
}

