/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArrayAppend
extends Transformer {
    public ArrayAppend(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.output.setTypeAtLeast(this.input);
        this.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayAppend newObject = (ArrayAppend)super.clone(workspace);
        newObject.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject.output.setTypeAtLeast(newObject.input);
        newObject.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int width = this.input.getWidth();
        if (width == 0) {
            throw new IllegalActionException((Nameable)this, "No input channels.");
        }
        int outputWidth = 0;
        Token[][] inputs = new Token[width][];
        int i = 0;
        while (i < width) {
            if (this.input.hasToken(i)) {
                ArrayToken token = (ArrayToken)this.input.get(i);
                inputs[i] = token.arrayValue();
                outputWidth += inputs[i].length;
            }
            ++i;
        }
        Token[] array = new Token[outputWidth];
        int runningPosition = 0;
        int i2 = 0;
        while (i2 < width) {
            System.arraycopy(inputs[i2], 0, array, runningPosition, inputs[i2].length);
            runningPosition += inputs[i2].length;
            ++i2;
        }
        Type elementType = ((ArrayType)this.input.getType()).getElementType();
        this.output.send(0, new ArrayToken(elementType, array));
    }
}

