/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.sequence;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.internal.sequence.SequenceTrace;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class SequenceTracker
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(SequenceTracker.class);
    private Map sequences = new HashMap();
    private boolean seqFinishedMsgPending = false;
    public Port handled = PortFactory.getInstance().createInputPort((Actor)this, "handledMsg", null);
    private PortHandler handledHandler = null;
    public Port seqFinished = PortFactory.getInstance().createOutputPort((Actor)this, "seqFinished");

    public SequenceTracker(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        super.doInitialize();
        this.sequences.clear();
        this.seqFinishedMsgPending = false;
        this.handledHandler = new PortHandler((IOPort)this.handled, new PortListener(){

            public void tokenReceived() {
                Token token = SequenceTracker.this.handledHandler.getToken();
                try {
                    ManagedMessage managedMessage = MessageHelper.getMessageFromToken((Token)token);
                    SequenceTracker.this.acceptHandledMessage(managedMessage);
                }
                catch (PasserelleException passerelleException) {
                    logger.error(String.valueOf(SequenceTracker.this.getInfo()) + " error getting message from handled port", (Throwable)passerelleException);
                }
            }

            public void noMoreTokens() {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.valueOf(SequenceTracker.this.getInfo()) + " handled port exhausted");
                }
            }
        });
        if (this.handled.getWidth() <= 0) {
            throw new InitializationException("handled port not connected", (Object)this, null);
        }
        this.handledHandler.start();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - exit");
        }
    }

    protected void acceptHandledMessage(ManagedMessage managedMessage) {
        SequenceTrace sequenceTrace = (SequenceTrace)this.sequences.get(managedMessage.getSequenceID());
        if (sequenceTrace == null) {
            try {
                ((Director)this.getDirector()).reportError((PasserelleException)((Object)new ProcessingException("Received message feedback for unknown sequence " + managedMessage.getSequenceID(), (Object)managedMessage, null)));
            }
            catch (ClassCastException classCastException) {
                logger.info(String.valueOf(this.getInfo()) + " - used without Passerelle Director!!, so automated error collecting does NOT work !!");
            }
        } else {
            sequenceTrace.messageHandled(managedMessage);
            boolean bl = sequenceTrace.isHandled();
            if (bl) {
                this.seqFinishedMsgPending = true;
                try {
                    try {
                        this.sequences.remove(managedMessage.getSequenceID());
                        ManagedMessage managedMessage2 = this.createTriggerMessage();
                        managedMessage2.setSequenceID(managedMessage.getSequenceID());
                        managedMessage2.setSequenceEnd(true);
                        this.sendOutputMsg(this.seqFinished, managedMessage2);
                    }
                    catch (ProcessingException processingException) {
                        try {
                            this.sendErrorMessage((PasserelleException)((Object)processingException));
                        }
                        catch (IllegalActionException illegalActionException) {
                            logger.error("", (Throwable)illegalActionException);
                        }
                        this.seqFinishedMsgPending = false;
                    }
                }
                finally {
                    this.seqFinishedMsgPending = false;
                }
            }
        }
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry - message :" + managedMessage);
        }
        try {
            if (managedMessage.isPartOfSequence()) {
                SequenceTrace sequenceTrace = (SequenceTrace)this.sequences.get(managedMessage.getSequenceID());
                if (sequenceTrace == null) {
                    sequenceTrace = new SequenceTrace(managedMessage.getSequenceID());
                    this.sequences.put(sequenceTrace.getSequenceID(), sequenceTrace);
                }
                sequenceTrace.addMessage(managedMessage);
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("", (Object)managedMessage, (Throwable)exception);
        }
        this.sendOutputMsg(this.output, managedMessage);
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    protected boolean doPostFire() throws ProcessingException {
        return super.doPostFire() || this.handled.getWidth() > 0 && (!this.sequences.isEmpty() || this.seqFinishedMsgPending);
    }

    protected String getExtendedInfo() {
        return "";
    }
}

