/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.sequence;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class MessagesToArrayConverter
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(MessagesToArrayConverter.class);
    public static final String TRIGGER_PORT = "trigger";
    public Port trigger = null;
    private boolean triggerConnected = false;
    private PortHandler triggerHandler = null;
    private List<ManagedMessage> msgQueue = new ArrayList<ManagedMessage>();

    public MessagesToArrayConverter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.trigger = PortFactory.getInstance().createInputPort((Actor)this, TRIGGER_PORT, null);
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        this.msgQueue.clear();
        boolean bl = this.triggerConnected = this.trigger.getWidth() > 0;
        if (this.triggerConnected) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Trigger(s) connected");
            }
            this.triggerHandler = new PortHandler((IOPort)this.trigger, new PortListener(){

                public void tokenReceived() {
                    block11: {
                        if (logger.isTraceEnabled()) {
                            logger.trace(String.valueOf(MessagesToArrayConverter.this.getInfo()) + " tokenReceived() - entry - received trigger");
                        }
                        try {
                            ManagedMessage managedMessage = MessageHelper.getMessageFromToken((Token)MessagesToArrayConverter.this.triggerHandler.getToken());
                            if (managedMessage == null) break block11;
                            try {
                                MessagesToArrayConverter.this.flushQueue();
                            }
                            catch (MessageException messageException) {
                                try {
                                    MessagesToArrayConverter.this.sendErrorMessage((PasserelleException)((Object)messageException));
                                }
                                catch (IllegalActionException illegalActionException) {
                                    logger.error("", (Throwable)illegalActionException);
                                }
                            }
                            catch (ProcessingException processingException) {
                                try {
                                    MessagesToArrayConverter.this.sendErrorMessage((PasserelleException)((Object)processingException));
                                }
                                catch (IllegalActionException illegalActionException) {
                                    logger.error("", (Throwable)illegalActionException);
                                }
                            }
                        }
                        catch (PasserelleException passerelleException) {
                            logger.error(String.valueOf(MessagesToArrayConverter.this.getInfo()) + " error getting message from handled port", (Throwable)passerelleException);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.valueOf(MessagesToArrayConverter.this.getInfo()) + " tokenReceived() - exit");
                    }
                }

                public void noMoreTokens() {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(MessagesToArrayConverter.this.getInfo()) + " - trigger exhausted");
                    }
                }
            });
            this.triggerHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public boolean isTriggerConnected() {
        return this.triggerConnected;
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doFire() - entry - message :" + managedMessage);
        }
        if (this.isTriggerConnected()) {
            this.msgQueue.add(managedMessage);
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - doFire() - queued message :" + managedMessage);
            }
        } else {
            this.sendOutputMsg(this.output, managedMessage);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doFire() - exit");
        }
    }

    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doWrapUp() - entry");
        }
        try {
            this.flushQueue();
        }
        catch (Exception exception) {
            throw new TerminationException("", (Object)this, (Throwable)exception);
        }
        super.doWrapUp();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - doWrapUp() - exit");
        }
    }

    protected String getExtendedInfo() {
        return "";
    }

    private void flushQueue() throws MessageException, ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - flushQueue() - entry");
        }
        if (!this.msgQueue.isEmpty()) {
            ManagedMessage managedMessage = this.createMessage();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ManagedMessage managedMessage2 : this.msgQueue) {
                managedMessage.addCauseID(managedMessage2.getID());
                arrayList.add(managedMessage2.getBodyContent());
            }
            managedMessage.setBodyContent((Object)arrayList.toArray(), "application/java");
            this.msgQueue.clear();
            this.sendOutputMsg(this.output, managedMessage);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - flushQueue() - exit");
        }
    }
}

