/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.mail;

import com.isencia.message.ISenderChannel;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.message.mail.MailSenderChannel;
import com.isencia.passerelle.actor.ChannelSink;
import com.isencia.passerelle.actor.mail.MessageToMailMessageConverter;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class SMTPSender
extends ChannelSink {
    public static final String MAILSERVER_PARAM = "MailServer";
    public static final String FROM_PARAM = "From";
    public static final String TO_PARAM = "To";
    public static final String SUBJECT_PARAM = "Subject";
    public static final String MAILHOST_HEADER = "MailHost";
    public static final String FROM_HEADER = "From";
    public static final String TO_HEADER = "To";
    public static final String CC_HEADER = "Cc";
    public static final String BCC_HEADER = "Bcc";
    public static final String SUBJECT_HEADER = "Subject";
    private static Logger logger = LoggerFactory.getLogger(SMTPSender.class);
    public Parameter mailServerParam = new StringParameter((NamedObj)this, "MailServer");
    public Parameter fromParam;
    public Parameter toParam;
    public Parameter subjectParam;
    private String mailHost = null;
    private String from = null;
    private String to = null;
    private String subject = null;

    public SMTPSender(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.mailServerParam.setExpression(System.getProperty("mail.host", "host"));
        this.fromParam = new StringParameter((NamedObj)this, "From");
        this.fromParam.setExpression(System.getProperty("mail.from", "host"));
        this.toParam = new StringParameter((NamedObj)this, "To");
        this.registerConfigurableParameter(this.toParam);
        this.subjectParam = new StringParameter((NamedObj)this, "Subject");
        this.registerConfigurableParameter(this.subjectParam);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.mailServerParam) {
            StringToken stringToken = (StringToken)this.mailServerParam.getToken();
            if (stringToken != null && stringToken.stringValue().length() > 0) {
                this.mailHost = stringToken.stringValue();
                logger.debug("Mailhost Attribute changed to : " + this.mailHost);
            }
        } else if (attribute == this.fromParam) {
            StringToken stringToken = (StringToken)this.fromParam.getToken();
            if (stringToken != null) {
                this.from = stringToken.stringValue();
                logger.debug("From Attribute changed to : " + this.from);
            }
        } else if (attribute == this.toParam) {
            StringToken stringToken = (StringToken)this.toParam.getToken();
            if (stringToken != null) {
                this.to = stringToken.stringValue();
                logger.debug("To Attribute changed to : " + this.to);
            }
        } else if (attribute == this.subjectParam) {
            StringToken stringToken = (StringToken)this.subjectParam.getToken();
            if (stringToken != null) {
                this.subject = stringToken.stringValue();
                logger.debug("Subject Attribute changed to : " + this.subject);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.mailHost;
    }

    protected ISenderChannel createChannel() {
        return new MailSenderChannel();
    }

    protected IMessageInterceptorChain createInterceptorChain() {
        MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
        messageInterceptorChain.add(new IMessageInterceptor(){

            public Object accept(Object object) throws MessageException {
                ManagedMessage managedMessage = (ManagedMessage)object;
                if (!managedMessage.hasBodyHeader(SMTPSender.MAILHOST_HEADER) && SMTPSender.this.mailHost != null && SMTPSender.this.mailHost.length() > 0) {
                    managedMessage.addBodyHeader(SMTPSender.MAILHOST_HEADER, SMTPSender.this.mailHost);
                }
                if (!managedMessage.hasBodyHeader("From") && SMTPSender.this.from != null && SMTPSender.this.from.length() > 0) {
                    managedMessage.addBodyHeader("From", SMTPSender.this.from);
                }
                if (!managedMessage.hasBodyHeader("To") && SMTPSender.this.to != null && SMTPSender.this.to.length() > 0) {
                    managedMessage.addBodyHeader("To", SMTPSender.this.to);
                }
                if (!managedMessage.hasBodyHeader("Subject") && SMTPSender.this.subject != null && SMTPSender.this.subject.length() > 0) {
                    managedMessage.addBodyHeader("Subject", SMTPSender.this.subject);
                }
                return managedMessage;
            }
        });
        messageInterceptorChain.add((IMessageInterceptor)new MessageToMailMessageConverter(this.isPassThrough()));
        return messageInterceptorChain;
    }
}

