/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.general;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.util.ExecutionTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class TracerConsole
extends Sink {
    private static Logger logger = LoggerFactory.getLogger(TracerConsole.class);
    public Parameter chopLengthParam = new Parameter((NamedObj)this, "Chop output at #chars", (Token)new IntToken(this.chopLength));
    private int chopLength = 80;

    public TracerConsole(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.chopLengthParam) {
            IntToken intToken = (IntToken)this.chopLengthParam.getToken();
            if (intToken != null) {
                this.chopLength = intToken.intValue();
                logger.debug("Chop length changed to : " + this.chopLength);
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void sendMessage(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (managedMessage != null) {
            if (this.isPassThrough()) {
                ExecutionTracerService.trace((Actor)this, (String)managedMessage.toString());
            } else {
                String string = null;
                try {
                    string = managedMessage.getBodyContentAsString();
                    if (this.chopLength < string.length()) {
                        string = String.valueOf(string.substring(0, this.chopLength)) + " !! CHOPPED !! ";
                    }
                }
                catch (MessageException messageException) {
                    throw new ProcessingException(PasserelleException.Severity.NON_FATAL, "", (Object)managedMessage, (Throwable)messageException);
                }
                if (string != null) {
                    ExecutionTracerService.trace((Actor)this, (String)string);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public int getChopLength() {
        return this.chopLength;
    }
}

