/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.general;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageHelper;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.Manager;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ModelExecutor
extends Actor {
    public static final String MODEL_HEADER = "Model";
    public static final String TRIGGER_PORT = "trigger";
    public static final String MODEL_PARAMETER = "model";
    private static Logger logger = LoggerFactory.getLogger(ModelExecutor.class);
    private PortHandler triggerHandler = null;
    public FileParameter modelParameter = new FileParameter((NamedObj)this, "model");
    private String defaultModelPath;
    public Port trigger = null;
    private boolean triggerConnected = false;
    private Manager manager;

    public ModelExecutor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.modelParameter.setExpression("");
        this.registerConfigurableParameter((Parameter)this.modelParameter);
        this.trigger = PortFactory.getInstance().createInputPort((Actor)this, TRIGGER_PORT, null);
        this.defaultModelPath = null;
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-9\" y1=\"-16\" x2=\"-12\" y2=\"-8\" style=\"stroke-width:2.0\"/>\n<line x1=\"-11\" y1=\"-7\" x2=\"-16\" y2=\"-7\" style=\"stroke-width:1.0\"/>\n<line x1=\"-13\" y1=\"-8\" x2=\"-15\" y2=\"-8\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-16\" y1=\"-7\" x2=\"-16\" y2=\"-5\" style=\"stroke-width:1.0\"/>\n<line x1=\"-11\" y1=\"-11\" x2=\"-8\" y2=\"-8\" style=\"stroke-width:1.5\"/>\n<line x1=\"-8\" y1=\"-8\" x2=\"-8\" y2=\"-6\" style=\"stroke-width:1.0\"/>\n<line x1=\"-8\" y1=\"-5\" x2=\"-6\" y2=\"-5\" style=\"stroke-width:1.0\"/>\n<line x1=\"-10\" y1=\"-14\" x2=\"-7\" y2=\"-11\" style=\"stroke-width:1.0\"/>\n<line x1=\"-7\" y1=\"-11\" x2=\"-5\" y2=\"-14\" style=\"stroke-width:1.0\"/>\n<line x1=\"-11\" y1=\"-14\" x2=\"-14\" y2=\"-14\" style=\"stroke-width:1.0\"/>\n<line x1=\"-14\" y1=\"-14\" x2=\"-12\" y2=\"-11\" style=\"stroke-width:1.0\"/>\n<rect x=\"-16\" y=\"-2\" width=\"32\" height=\"20\" style=\"fill:white;stroke:darkgrey\"/>\n<circle cx=\"-12\" cy=\"2\" r=\"2\"style=\"fill:red;stroke:red\"/>\n<rect x=\"-14\" y=\"10\" width=\"6\" height=\"6\" style=\"fill:orange;stroke:orange\"/>\n<circle cx=\"-12\" cy=\"12\" r=\"2\"style=\"fill:white;stroke:black\"/>\n<rect x=\"-4\" y=\"10\" width=\"4\" height=\"4\" style=\"fill:grey;stroke:grey\"/>\n<rect x=\"-2\" y=\"2\" width=\"4\" height=\"4\" style=\"fill:grey;stroke:grey\"/>\n<rect x=\"8\" y=\"0\" width=\"6\" height=\"6\" style=\"fill:green;stroke:green\"/>\n<circle cx=\"10\" cy=\"2\" r=\"2\"style=\"fill:white;stroke:black\"/>\n<rect x=\"8\" y=\"8\" width=\"6\" height=\"6\" style=\"fill:green;stroke:green\"/>\n<circle cx=\"10\" cy=\"10\" r=\"2\"style=\"fill:white;stroke:black\"/>\n<line x1=\"-7\" y1=\"13\" x2=\"-3\" y2=\"5\" style=\"stroke-width:0.5;stroke:grey\"/>\n<line x1=\"-7\" y1=\"13\" x2=\"-5\" y2=\"12\" style=\"stroke-width:0.5;stroke:grey\"/>\n<line x1=\"3\" y1=\"4\" x2=\"7\" y2=\"3\" style=\"stroke-width:0.5;stroke:grey\"/>\n<line x1=\"1\" y1=\"12\" x2=\"7\" y2=\"11\" style=\"stroke-width:0.5;stroke:grey\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.modelParameter) {
            try {
                this.defaultModelPath = this.modelParameter.asURL().getPath();
                logger.debug("Model Path changed to : " + this.defaultModelPath);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doFire() throws ProcessingException {
        ManagedMessage managedMessage = null;
        String[] stringArray = null;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.triggerConnected) {
            Token token;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Waiting for trigger");
            }
            if ((token = this.triggerHandler.getToken()) == null) {
                this.requestFinish();
            }
            try {
                managedMessage = MessageHelper.getMessageFromToken((Token)token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while reading message", (Object)token, (Throwable)passerelleException);
            }
            if (managedMessage == null) {
                this.requestFinish();
            }
            logger.debug("Received msg :" + managedMessage);
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Trigger received");
            }
        }
        if (!this.isFinishRequested()) {
            try {
                if (managedMessage != null && managedMessage.hasBodyHeader(MODEL_HEADER)) {
                    stringArray = managedMessage.getBodyHeader(MODEL_HEADER);
                }
            }
            catch (MessageException messageException) {
                logger.error("", (Throwable)messageException);
            }
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{this.defaultModelPath};
            }
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        File file = new File(stringArray[n]);
                        if (ModelExecutor.getAuditLogger().isInfoEnabled()) {
                            ModelExecutor.getAuditLogger().info("Executing " + stringArray[n]);
                        }
                        this.manager = new com.isencia.passerelle.executor.ModelExecutor(this.getName()).executeModel(file, null);
                    }
                    catch (Exception exception) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception " + exception, null, (Throwable)exception);
                    }
                    ++n;
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        boolean bl = this.triggerConnected = this.trigger.getWidth() > 0;
        if (this.triggerConnected) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Trigger(s) connected");
            }
            this.triggerHandler = new PortHandler((IOPort)this.trigger);
            this.triggerHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean doPostFire() throws ProcessingException {
        boolean bl;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (bl = this.triggerConnected) {
            bl = super.doPostFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    protected void doStop() {
        super.doStop();
        if (this.manager != null) {
            this.manager.finish();
        }
    }

    protected void doStopFire() {
        super.doStopFire();
        if (this.manager != null) {
            this.manager.finish();
        }
    }

    protected String getExtendedInfo() {
        return this.defaultModelPath;
    }
}

