/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.flow;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Delay
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(Delay.class);
    public Parameter timeParameter = new Parameter((NamedObj)this, "time(s)", (Token)new IntToken(1));
    private int time = 0;

    public Delay(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.timeParameter.setTypeEquals((Type)BaseType.INT);
        this.registerConfigurableParameter(this.timeParameter);
    }

    public void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry");
        }
        try {
            if (this.time > 0) {
                logger.debug("Delay action, sleeping for " + this.time + " seconds.");
                Thread.sleep(this.time * 1000);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            throw new ProcessingException("", (Object)this, (Throwable)exception);
        }
        try {
            this.sendOutputMsg(this.output, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - entry :" + attribute);
        }
        if (attribute == this.timeParameter) {
            this.time = ((IntToken)this.timeParameter.getToken()).intValue();
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - exit");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(Integer.toString(this.time)) + " (s)";
    }
}

