/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.util.StringConvertor;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.FileParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class XSLTConverter
extends Transformer {
    public static final String PATH_PARAM = "Path";
    private static Logger logger = LoggerFactory.getLogger(XSLTConverter.class);
    public FileParameter xsltPathParam = null;
    protected String xsltPath = null;

    public XSLTConverter(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.input.setExpectedMessageContentType(String.class);
        this.xsltPathParam = new FileParameter((NamedObj)this, PATH_PARAM);
        try {
            URI uRI = new URI("file://" + StringConvertor.convertPathDelimiters((String)EnvironmentUtils.getApplicationRootFolder()));
            this.xsltPathParam.setBaseDirectory(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.xsltPathParam) {
            try {
                this.xsltPath = this.xsltPathParam.asURL().getPath();
                logger.debug("Xslt Path changed to : " + this.xsltPath);
            }
            catch (Exception exception) {}
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - message :" + managedMessage);
        }
        if (managedMessage != null) {
            Object[] objectArray = MessageHelper.getFilteredContent((ManagedMessage)managedMessage, (String[])new String[]{"text/xml"});
            if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Content :" + objectArray[n]);
                        logger.debug("XsltPath :" + this.xsltPath);
                    }
                    StringWriter stringWriter = new StringWriter();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    String string = null;
                    try {
                        javax.xml.transform.Transformer transformer = transformerFactory.newTransformer(new StreamSource(this.xsltPath));
                        transformer.transform(new StreamSource(new StringReader((String)objectArray[n])), new StreamResult(stringWriter));
                        string = transformer.getOutputProperty("media-type");
                        logger.debug("Seems like something came out : " + stringWriter.toString());
                    }
                    catch (Exception exception) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while transforming part of the message " + exception, objectArray[n], (Throwable)exception);
                    }
                    try {
                        managedMessage = MessageFactory.getInstance().copyMessage(managedMessage);
                        managedMessage.setBodyContentPlainText(stringWriter.toString());
                        managedMessage.addBodyHeader("Content-Type", string);
                    }
                    catch (Exception exception) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated an exception while generating/sending the result message " + exception, (Object)managedMessage, (Throwable)exception);
                    }
                    try {
                        this.sendOutputMsg(this.output, managedMessage);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
                    }
                    ++n;
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " :no valid content");
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return this.xsltPath;
    }
}

