/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.convert;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.xml.XmlMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class BodyToHeaderExtractor
extends Transformer {
    private static final String MODE_ADD = "Add";
    private static final String MODE_MODIFY = "Modify";
    private static Logger logger = LoggerFactory.getLogger(BodyToHeaderExtractor.class);
    public Parameter propNameParam = null;
    public Parameter xpathSelectorParam = null;
    public Parameter propModeParam = null;
    private String propName = "";
    private String xpathSelector = "";
    private String propMode = null;

    public BodyToHeaderExtractor(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.output.setMultiport(true);
        this.input.setExpectedMessageContentType(String.class);
        this.propNameParam = new StringParameter((NamedObj)this, "header name");
        this.propNameParam.setExpression("");
        this.xpathSelectorParam = new StringParameter((NamedObj)this, "XPath selector");
        this.xpathSelectorParam.setExpression("");
        this.propModeParam = new StringParameter((NamedObj)this, "mode");
        this.propModeParam.addChoice(MODE_ADD);
        this.propModeParam.addChoice(MODE_MODIFY);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.propNameParam) {
            this.propName = ((StringToken)this.propNameParam.getToken()).stringValue();
        } else if (attribute == this.xpathSelectorParam) {
            this.xpathSelector = ((StringToken)this.xpathSelectorParam.getToken()).stringValue();
        } else if (attribute == this.propModeParam) {
            this.propMode = this.propModeParam.getExpression();
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public void doFire(ManagedMessage managedMessage) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - message :" + managedMessage);
        }
        if (managedMessage != null && this.propName != null && this.propName.length() > 0) {
            String string = null;
            try {
                NodeList nodeList = XmlMessageHelper.selectWithXPath((String)this.xpathSelector, (ManagedMessage)managedMessage);
                if (nodeList != null && nodeList.getLength() > 0) {
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Node node = nodeList.item(n);
                        if (node.getNodeType() == 3) {
                            string = node.getNodeValue();
                        } else {
                            NodeList nodeList2 = node.getChildNodes();
                            if (nodeList2 != null && nodeList2.getLength() > 0) {
                                int n2 = 0;
                                while (n2 < nodeList2.getLength()) {
                                    Node node2 = nodeList2.item(n2);
                                    if (node2.getNodeType() == 3) {
                                        string = node2.getNodeValue();
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        if (string != null) {
                            if (this.propMode.equalsIgnoreCase(MODE_ADD)) {
                                managedMessage.addBodyHeader(this.propName, string);
                            } else if (this.propMode.equalsIgnoreCase(MODE_MODIFY)) {
                                managedMessage.setBodyHeader(this.propName, string);
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                throw new ProcessingException(String.valueOf(this.getInfo()) + "doFire() - Exception while applying Xpath " + this.xpathSelector, (Object)managedMessage, (Throwable)exception);
            }
        }
        try {
            this.sendOutputMsg(this.output, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getExtendedInfo() {
        return String.valueOf(this.propMode) + ":" + this.propName + ":" + this.xpathSelector;
    }
}

