/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.control;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.util.SchedulerUtils;
import com.isencia.passerelle.util.ptolemy.DateTimeParameter;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;
import org.quartz.jobs.NoOpJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class QuartzScheduler
extends Actor {
    private static final String END_OF_MONTH = "EndOfMonth";
    private static final String ILLEGAL_ENTRY = "--";
    private static Logger logger = LoggerFactory.getLogger(QuartzScheduler.class);
    private static final String[] WEEK_DAYS = new String[]{"--", "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    private static final String[] MONTH_DAYS = new String[]{"EndOfMonth", "--", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] HOURS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String[] SECONDS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private static final String[] MINUTES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    public Parameter paramPeriodSpec;
    public Parameter paramExecutionType;
    public DateTimeParameter paramStartDate;
    public DateTimeParameter paramEndDate;
    public Parameter paramRecoverTriggers;
    private Date startDate = null;
    private Date endDate = null;
    private int periodSpec = -1;
    private ExecutionType executionType = ExecutionType.ONCE;
    private boolean recoverTriggers = false;
    public Port output = PortFactory.getInstance().createOutputPort((Actor)this, "output");
    private BlockingReaderQueue queue = null;
    private Scheduler scheduler = null;
    private Trigger myTrigger = null;
    private boolean itsMyScheduler = false;

    public QuartzScheduler(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.paramRecoverTriggers = new Parameter((NamedObj)this, "recoverTriggers", (Token)new BooleanToken(false));
        this.paramRecoverTriggers.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerConfigurableParameter(this.paramRecoverTriggers);
        this.startDate = new Date();
        this.paramStartDate = new DateTimeParameter((NamedObj)this, "startDate");
        this.paramStartDate.setDateValue(this.startDate);
        this.registerConfigurableParameter((Parameter)this.paramStartDate);
        this.endDate = new Date();
        this.paramEndDate = new DateTimeParameter((NamedObj)this, "endDate");
        this.paramEndDate.setDateValue(this.endDate);
        this.registerConfigurableParameter((Parameter)this.paramEndDate);
        this.paramExecutionType = new StringParameter((NamedObj)this, "executionType");
        this.paramExecutionType.setExpression(ExecutionType.ONCE.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.ONCE.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.PERIODIC_SECONDS.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.PERIODIC_MINUTES.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.PERIODIC_HOURS.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.PERIODIC_WEEKLY.getDescription());
        this.paramExecutionType.addChoice(ExecutionType.PERIODIC_MONTHLY.getDescription());
        this.registerConfigurableParameter(this.paramExecutionType);
        this.paramPeriodSpec = new StringParameter((NamedObj)this, "periodSpecifier");
        this.paramPeriodSpec.setExpression("");
        ExecutionType.ONCE.fillChoices(this.paramPeriodSpec);
        this.registerConfigurableParameter(this.paramPeriodSpec);
        this.queue = new BlockingReaderQueue((IQueue)new FIFOQueue());
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"16\"style=\"fill:white\"/>\n<line x1=\"0\" y1=\"-14\" x2=\"0\" y2=\"-12\"/>\n<line x1=\"0\" y1=\"12\" x2=\"0\" y2=\"14\"/>\n<line x1=\"-14\" y1=\"0\" x2=\"-12\" y2=\"0\"/>\n<line x1=\"12\" y1=\"0\" x2=\"14\" y2=\"0\"/>\n<line x1=\"0\" y1=\"-7\" x2=\"0\" y2=\"0\"/>\n<line x1=\"0\" y1=\"0\" x2=\"11.26\" y2=\"-6.5\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " Attribute :" + attribute);
        }
        if (attribute == this.paramRecoverTriggers) {
            BooleanToken booleanToken = (BooleanToken)this.paramRecoverTriggers.getToken();
            if (booleanToken != null) {
                this.recoverTriggers = booleanToken.booleanValue();
            }
        } else if (attribute == this.paramStartDate) {
            this.startDate = this.paramStartDate.getDateValue();
        } else if (attribute == this.paramEndDate) {
            this.endDate = this.paramEndDate.getDateValue();
        } else if (attribute == this.paramExecutionType) {
            ExecutionType executionType = this.executionType;
            this.executionType = ExecutionType.getByDescription(this.paramExecutionType.getExpression());
            if (!executionType.equals(this.executionType)) {
                String string = this.paramPeriodSpec.getExpression();
                this.executionType.fillChoices(this.paramPeriodSpec);
                this.paramPeriodSpec.setExpression("Pick one...");
                this.paramPeriodSpec.setExpression(string);
            }
        } else if (attribute == this.paramPeriodSpec) {
            this.periodSpec = this.executionType.getValueIdentifier(this.paramPeriodSpec.getExpression());
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit");
        }
    }

    protected void doFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        ManagedMessage managedMessage = null;
        try {
            managedMessage = (ManagedMessage)this.queue.get();
        }
        catch (EmptyQueueException emptyQueueException) {
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - No more triggers");
            }
            this.requestFinish();
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + exception, (Object)managedMessage, (Throwable)exception);
        }
        try {
            this.sendOutputMsg(this.output, managedMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception " + illegalArgumentException, (Object)managedMessage, (Throwable)illegalArgumentException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) {
        return "generated scheduled trigger.";
    }

    protected void doInitialize() throws InitializationException {
        Director director;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - Parameters :" + this.attributeList(Parameter.class));
        }
        super.doInitialize();
        this.startDate = this.paramStartDate.getDateValue();
        this.endDate = this.paramEndDate.getDateValue();
        String string = String.valueOf(this.getManager().getName()) + "_" + this.getName();
        if (this.scheduler == null) {
            if (this.getDirector() instanceof Director) {
                this.itsMyScheduler = false;
                director = (Director)this.getDirector();
                this.scheduler = director.getScheduler();
            } else {
                this.itsMyScheduler = true;
                try {
                    this.scheduler = SchedulerUtils.getQuartzScheduler((String)string);
                    this.scheduler.start();
                }
                catch (SchedulerException schedulerException) {
                    throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Error starting the scheduler", (Object)this, (Throwable)schedulerException);
                }
            }
            try {
                this.scheduler.addSchedulerListener((SchedulerListener)new SchedulerActorManager());
            }
            catch (SchedulerException schedulerException) {
                try {
                    this.scheduler.shutdown();
                }
                catch (SchedulerException schedulerException2) {}
                throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Error registering with the scheduler", (Object)this, (Throwable)schedulerException);
            }
        }
        try {
            this.myTrigger = this.createTrigger();
            director = new JobDetail(String.valueOf(string) + "_Job", this.getName(), NoOpJob.class);
            SchedulerActorJob schedulerActorJob = new SchedulerActorJob(String.valueOf(string) + "_JobListener");
            this.scheduler.addJobListener((JobListener)schedulerActorJob);
            director.addJobListener(schedulerActorJob.getName());
            this.scheduler.scheduleJob((JobDetail)director, this.myTrigger);
        }
        catch (Exception exception) {
            throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getInfo()) + " - Error configuring the scheduler", (Object)this, (Throwable)exception);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doWrapUp() throws TerminationException {
        block8: {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getInfo());
            }
            try {
                if (this.scheduler == null) break block8;
                try {
                    if (this.itsMyScheduler) {
                        this.scheduler.shutdown(true);
                    }
                    this.scheduler = null;
                }
                catch (SchedulerException schedulerException) {
                    throw new TerminationException(String.valueOf(this.getInfo()) + " - Error closing the scheduler", (Object)this, (Throwable)schedulerException);
                }
            }
            finally {
                super.doWrapUp();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected void doStopFire() {
        this.queue.trigger();
    }

    protected String getExtendedInfo() {
        return "";
    }

    private Trigger createTrigger() throws Exception {
        Trigger trigger = this.executionType.createTrigger(this.periodSpec, String.valueOf(this.getManager().getName()) + "_" + this.getName() + "_Trigger");
        if (!this.recoverTriggers) {
            if (trigger instanceof CronTrigger) {
                trigger.setMisfireInstruction(2);
            } else {
                trigger.setMisfireInstruction(4);
            }
        } else if (trigger instanceof CronTrigger) {
            trigger.setMisfireInstruction(0);
        } else {
            trigger.setMisfireInstruction(0);
        }
        trigger.setGroup(this.getName());
        trigger.setStartTime(this.startDate);
        trigger.setEndTime(this.endDate);
        return trigger;
    }

    static /* synthetic */ String[] access$0() {
        return SECONDS;
    }

    static /* synthetic */ String[] access$1() {
        return MINUTES;
    }

    static /* synthetic */ String[] access$2() {
        return HOURS;
    }

    static /* synthetic */ String[] access$3() {
        return WEEK_DAYS;
    }

    static /* synthetic */ String[] access$4() {
        return MONTH_DAYS;
    }

    static abstract class ExecutionType {
        static Map entries = new HashMap();
        private String description;
        private List valueRange;
        static final ExecutionType ONCE = new ExecutionType("Execute once", new String[]{"Not periodic"}){

            @Override
            public Trigger createTrigger(int n, String string) {
                SimpleTrigger simpleTrigger = new SimpleTrigger("SingleShotTrigger", string);
                return simpleTrigger;
            }
        };
        static final ExecutionType PERIODIC_SECONDS = new ExecutionType("Periodic - seconds", QuartzScheduler.access$0()){

            @Override
            public Trigger createTrigger(int n, String string) {
                Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)n);
                trigger.setName("PeriodicalTriggerBySeconds");
                return trigger;
            }
        };
        static final ExecutionType PERIODIC_MINUTES = new ExecutionType("Periodic - minutes", QuartzScheduler.access$1()){

            @Override
            public Trigger createTrigger(int n, String string) {
                Trigger trigger = TriggerUtils.makeMinutelyTrigger((int)n);
                trigger.setName("PeriodicalTriggerByMinutes");
                return trigger;
            }
        };
        static final ExecutionType PERIODIC_HOURS = new ExecutionType("Periodic - hours", QuartzScheduler.access$2()){

            @Override
            public Trigger createTrigger(int n, String string) {
                Trigger trigger = TriggerUtils.makeHourlyTrigger((int)n);
                trigger.setName("PeriodicalTriggerByHours");
                return trigger;
            }
        };
        static final ExecutionType PERIODIC_WEEKLY = new ExecutionType("Periodic - weekly", QuartzScheduler.access$3()){

            @Override
            public Trigger createTrigger(int n, String string) {
                Trigger trigger = TriggerUtils.makeWeeklyTrigger((int)n, (int)0, (int)0);
                trigger.setName("PeriodicalTriggerByWeekDay");
                return trigger;
            }
        };
        static final ExecutionType PERIODIC_MONTHLY = new ExecutionType("Periodic - monthly", QuartzScheduler.access$4()){

            @Override
            public Trigger createTrigger(int n, String string) {
                Trigger trigger = TriggerUtils.makeMonthlyTrigger((int)n, (int)0, (int)0);
                trigger.setName("PeriodicalTriggerByMonthDay");
                return trigger;
            }
        };

        private ExecutionType(String string, String[] stringArray) {
            this.description = string;
            this.valueRange = Arrays.asList(stringArray);
            entries.put(string, this);
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getValueRange() {
            return this.valueRange.toArray(new String[0]);
        }

        public int getValueIdentifier(String string) {
            if (QuartzScheduler.END_OF_MONTH.equalsIgnoreCase(string)) {
                return -1;
            }
            if (!QuartzScheduler.ILLEGAL_ENTRY.equals(string)) {
                return this.valueRange.indexOf(string);
            }
            return -1;
        }

        void fillChoices(Parameter parameter) {
            if (parameter != null) {
                parameter.removeAllChoices();
                for (String string : this.valueRange) {
                    parameter.addChoice(string);
                }
            }
        }

        public static ExecutionType getByDescription(String string) {
            return (ExecutionType)entries.get(string);
        }

        public abstract Trigger createTrigger(int var1, String var2);
    }

    class SchedulerActorJob
    implements JobListener {
        private String name = "SchedulerActorJob";

        public SchedulerActorJob(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        }

        public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        }

        public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
            if (jobExecutionContext.getTrigger().equals((Object)QuartzScheduler.this.myTrigger)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("jobWasExecuted() - entry");
                }
                QuartzScheduler.this.queue.put((Object)QuartzScheduler.this.createTriggerMessage());
                if (logger.isTraceEnabled()) {
                    logger.trace("jobWasExecuted() - exit");
                }
            }
        }
    }

    class SchedulerActorManager
    implements SchedulerListener {
        SchedulerActorManager() {
        }

        public void jobScheduled(Trigger trigger) {
        }

        public void jobUnscheduled(String string, String string2) {
        }

        public void triggerFinalized(Trigger trigger) {
            if (trigger.equals((Object)QuartzScheduler.this.myTrigger)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("triggerFinalized() - entry");
                }
                QuartzScheduler.this.requestFinish();
                if (logger.isTraceEnabled()) {
                    logger.trace("triggerFinalized() - exit");
                }
            }
        }

        public void triggersPaused(String string, String string2) {
        }

        public void triggersResumed(String string, String string2) {
        }

        public void jobsPaused(String string, String string2) {
        }

        public void jobsResumed(String string, String string2) {
        }

        public void schedulerError(String string, SchedulerException schedulerException) {
        }

        public void schedulerShutdown() {
        }
    }
}

